/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.admin.cli.EntityUtils;
import com.iplanet.am.admin.cli.SearchReq;
import com.iplanet.am.sdk.AMEntity;
import com.iplanet.am.sdk.AMEntityType;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class ContGetEntitiesReq
extends SearchReq {
    private Set entityDNs = new HashSet();
    private boolean DNsOnly = true;
    private String entityType = null;

    ContGetEntitiesReq(String string) {
        super(string);
    }

    void setDNsOnly(boolean bl) {
        this.DNsOnly = bl;
    }

    void setEntityType(String string) {
        this.entityType = string;
    }

    void addDNs(Set set) {
        if (set != null) {
            this.entityDNs = set;
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription91") + " " + this.targetDN);
        printWriter.println("   DNsOnly = " + this.DNsOnly);
        printWriter.println("   filter = " + this.filter);
        printWriter.println("   sizeLimit = " + this.sizeLimit);
        printWriter.println("   timeLimit = " + this.timeLimit);
        if (this.entityDNs.isEmpty()) {
            printWriter.println("  DN set is empty");
        } else {
            printUtils.printSet(this.entityDNs, 2);
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        EntityUtils entityUtils = new EntityUtils();
        Map map = entityUtils.getEntityTypesMap(aMStoreConnection);
        AMEntityType aMEntityType = (AMEntityType)map.get(this.entityType);
        if (aMEntityType == null) {
            throw new AdminException(AdminReq.bundle.getString("invalidEntity"));
        }
        Object[] objectArray = new String[]{entityUtils.getL10NAttributeName(aMStoreConnection, aMEntityType.getServiceName(), "entities-description")};
        String string = MessageFormat.format(AdminReq.bundle.getString("getEntities"), objectArray);
        PrintUtils printUtils = new PrintUtils(AdminReq.writer);
        AdminReq.writer.println(AdminReq.bundle.getString("container") + " " + this.targetDN + "\n" + string);
        try {
            Object object;
            Object object2;
            AMOrganizationalUnit aMOrganizationalUnit = aMStoreConnection.getOrganizationalUnit(this.targetDN);
            AdminReq.writer.println(this.targetDN);
            boolean bl = false;
            if (this.entityDNs.isEmpty()) {
                object2 = this.createSearchControl(1);
                object = aMOrganizationalUnit.searchEntities(this.filter, null, aMEntityType.getSearchTemplate(), (AMSearchControl)object2);
                this.errorCode = ((AMSearchResults)object).getErrorCode();
                this.entityDNs = ((AMSearchResults)object).getSearchResults();
            } else {
                bl = true;
            }
            object2 = this.entityDNs.iterator();
            while (object2.hasNext()) {
                object = object2.next().toString();
                AMEntity aMEntity = aMStoreConnection.getEntity((String)object);
                if (bl && (!aMEntity.isExists() || !AdminUtils.isDescendantOf(aMEntity, this.targetDN, 1))) continue;
                EntityUtils.printEntityInformation(printUtils, aMEntity, aMStoreConnection, this.DNsOnly);
            }
            this.printSearchLimitError();
        }
        catch (AMException aMException) {
            throw new AdminException(aMException.toString());
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException.toString());
        }
    }
}

