/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AddDeleteReq;
import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMPeopleContainer;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;

class ContDeletePCReq
extends AddDeleteReq {
    private boolean recursiveDelete = false;

    ContDeletePCReq(String string) {
        super(string);
    }

    void setRecursiveDelete(boolean bl) {
        this.recursiveDelete = bl;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription8") + " " + this.targetDN);
        if (this.DNSet.isEmpty()) {
            printWriter.println("  DN set is empty");
        } else {
            printUtils.printSet(this.DNSet, 1);
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(AdminReq.bundle.getString("container") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("deletepeoplecontainers"));
        }
        AdminReq.writer.println(AdminReq.bundle.getString("container") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("deletepeoplecontainers"));
        try {
            Iterator iterator = this.DNSet.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                AMPeopleContainer aMPeopleContainer = aMStoreConnection.getPeopleContainer(string);
                if (aMPeopleContainer.isExists()) {
                    this.doLog(aMPeopleContainer, "DELETE_PC_ATTEMPT");
                    aMPeopleContainer.delete(this.recursiveDelete);
                    AdminReq.writer.println(string);
                    if (AdminUtils.logEnabled()) {
                        AdminUtils.log(AdminReq.bundle.getString("container") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("deletedpeoplecontainers") + ": " + string);
                    }
                    this.doLog(aMPeopleContainer, "DELETE_PC");
                    continue;
                }
                throw new AdminException(AdminReq.bundle.getString("invalidPeopleContainerDN"));
            }
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

