/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class ContCreateSubContReq
extends AdminReq {
    private Map subContReq = new HashMap();

    ContCreateSubContReq(String string) {
        super(string);
    }

    void addSubContReq(String string, Map map) {
        this.subContReq.put(string, map);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription5") + " " + this.targetDN);
        AdminUtils.printAttributeNameValuesMap(printWriter, printUtils, this.subContReq);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(AdminReq.bundle.getString("container") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("createsubcontainers"));
        }
        AdminReq.writer.println(AdminReq.bundle.getString("container") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("createsubcontainers"));
        try {
            this.doLogStringSet(this.subContReq.keySet(), "CREATE_CONTAINER_ATTEMPT");
            AMOrganizationalUnit aMOrganizationalUnit = aMStoreConnection.getOrganizationalUnit(this.targetDN);
            Set set = aMOrganizationalUnit.createSubOrganizationalUnits(this.subContReq);
            this.printAMObjectDN(set);
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(AdminReq.bundle.getString("statusmsg19"));
            }
            this.doLog(set, "CREATE_CONTAINER");
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

