/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;

abstract class ArgumentValidator {
    static Set nonOperatorUnaryOperators = new HashSet(5);
    static Set debugUnaryOperators = new HashSet(4);
    static Set nonOperatorBinaryOperators = new HashSet(4);

    ArgumentValidator() {
    }

    static boolean validateArguments(String[] stringArray, ResourceBundle resourceBundle) {
        boolean bl = false;
        int n = stringArray.length;
        if (n == 0) {
            bl = true;
        } else if (n == 1) {
            String string = stringArray[0];
            if (!nonOperatorUnaryOperators.contains(string.toLowerCase())) {
                System.err.println(resourceBundle.getString("invopt") + string);
                bl = true;
            }
        } else if (ArgumentValidator.hasMandatoryArguments(stringArray, resourceBundle)) {
            if (!ArgumentValidator.hasOperator(stringArray)) {
                System.err.println(resourceBundle.getString("nodataschemawarning"));
                bl = true;
            }
        } else {
            bl = true;
        }
        return !bl;
    }

    private static boolean hasMandatoryArguments(String[] stringArray, ResourceBundle resourceBundle) {
        boolean bl = false;
        boolean bl2 = false;
        int n = stringArray.length;
        int n2 = 0;
        while (!(n2 >= n - 1 || bl && bl2)) {
            String string = stringArray[n2].toLowerCase();
            if (!bl && (string.equals("--runasdn") || string.equals("-u")) && stringArray[n2 + 1].charAt(0) != '-') {
                bl = true;
                ++n2;
            }
            if (!bl2 && (string.equals("--password") || string.equals("-w") || string.equals("--passwordfile") || string.equals("-f")) && stringArray[n2 + 1].charAt(0) != '-') {
                bl2 = true;
                ++n2;
            }
            ++n2;
        }
        if (!bl) {
            System.err.println(resourceBundle.getString("nodnforadmin"));
        }
        if (!bl2) {
            System.err.println(resourceBundle.getString("nopwdforadmin"));
        }
        return bl && bl2;
    }

    private static boolean hasOperator(String[] stringArray) {
        int n = stringArray.length;
        ArrayList<String> arrayList = new ArrayList<String>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(stringArray[n2].toLowerCase());
            ++n2;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (debugUnaryOperators.contains(string)) {
                iterator.remove();
                continue;
            }
            if (!nonOperatorBinaryOperators.contains(string)) continue;
            iterator.remove();
            if (!iterator.hasNext()) continue;
            iterator.next();
            iterator.remove();
        }
        return !arrayList.isEmpty();
    }

    static {
        nonOperatorUnaryOperators.add("--help");
        nonOperatorUnaryOperators.add("-h");
        nonOperatorUnaryOperators.add("--version");
        nonOperatorUnaryOperators.add("-n");
        nonOperatorUnaryOperators.add("--cleanpolicyrules");
        debugUnaryOperators.add("--verbose");
        debugUnaryOperators.add("-v");
        debugUnaryOperators.add("--debug");
        debugUnaryOperators.add("-d");
        nonOperatorBinaryOperators.add("--runasdn");
        nonOperatorBinaryOperators.add("-u");
        nonOperatorBinaryOperators.add("--password");
        nonOperatorBinaryOperators.add("-w");
        nonOperatorBinaryOperators.add("--passwordfile");
        nonOperatorBinaryOperators.add("-f");
    }
}

