/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.sdk.AMEntity;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.Logger;
import com.sun.identity.log.messageid.LogMessageProvider;
import com.sun.identity.log.messageid.MessageProviderFactory;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import netscape.ldap.LDAPDN;
import netscape.ldap.util.DN;

class AdminUtils {
    public static final int VERBOSE = 1;
    public static final int DEBUG = 2;
    private static final String ACCESS_LOG = "amAdmin.access";
    private static final String ERROR_LOG = "amAdmin.error";
    private static int level;
    private static Debug debug;
    private static Logger logger;
    protected static boolean verboseEnabled;
    protected static boolean debugEnabled;
    private static boolean logEnabled;
    private static SSOToken ssot;
    static final String USER_SERVICE = "iPlanetAMUserService";
    public static final int LOG_ACCESS = 0;
    public static final int LOG_ERROR = 1;
    public static final String SERVICE_NOT_FOUND = "SVC_NOT_FOUND";
    public static final String ADMIN_EXCEPTION = "ADMIN_EXCEPTION";
    public static final String LOGIN_FAIL = "LOGIN_FAIL";
    public static final String LOAD_SERVICE = "LOAD_SERVICE";
    public static final String DELETE_SERVICE = "DELETE_SERVICE";
    public static final String ADD_ATTRIBUTES = "ADD_ATTRS";
    public static final String NO_POLICY_PRIVILEGES = "NO_POLICY_PRIVS";
    public static final String START_DELETING_RULES = "START_DELETING_POLICIES";
    public static final String DONE_DELETING_RULES = "DONE_DELETING_POLICIES";
    public static final String ADD_RESOURCE_BUNDLE_TO_DIRECTORY_SERVER = "ADD_RESOURCE_BUNDLE_TO_DIRECTORY_SERVER";
    public static final String ADD_DEFAULT_RESOURCE_BUNDLE_TO_DIRECTORY_SERVER = "ADD_DEFAULT_RESOURCE_BUNDLE_TO_DIRECTORY_SERVER";
    public static final String DELETE_RESOURCE_BUNDLE_FROM_DIRECTORY_SERVER = "DELETE_RESOURCE_BUNDLE_FROM_DIRECTORY_SERVER";
    public static final String DELETE_DEFAULT_RESOURCE_BUNDLE_FROM_DIRECTORY_SERVER = "DELETE_DEFAULT_RESOURCE_BUNDLE_FROM_DIRECTORY_SERVER";
    public static final String CREATE_POLICY = "CREATE_POLICY";
    public static final String DELETE_POLICY = "DELETE_POLICY";
    public static final String MODIFY_SUB_CONFIG_IN_ORG = "MODIFY_SUB_CONFIG_IN_ORG";
    public static final String ADD_SUB_CONFIG_IN_ORG = "ADD_SUB_CONFIG_IN_ORG";
    public static final String DELETE_SUB_CONFIG_IN_ORG = "DELETE_SUB_CONFIG_IN_ORG";
    public static final String CREATE_REMOTE_PROV = "CREATE_REMOTE_PROV";
    public static final String MODIFY_REMOTE_PROV = "MODIFY_REMOTE_PROV";
    public static final String MODIFY_HOSTED_PROV = "MODIFY_HOSTED_PROV";
    public static final String CREATE_HOSTED_PROV = "CREATE_HOSTED_PROV";
    public static final String DELETE_PROV = "DELETE_PROV";
    public static final String CREATE_COT = "CREATE_COT";
    public static final String DELETE_COT = "DELETE_COT";
    public static final String MODIFY_COT = "MODIFY_COT";
    public static final String MODIFY_SERVICE_SCHEMA = "MODIFY_SERVICE_SCHEMA";
    public static final String DELETE_SERVICE_SUBSCHEMA = "DELETE_SERVICE_SUBSCHEMA";
    public static final String ADD_SERVICE_SUBSCHEMA = "ADD_SERVICE_SUBSCHEMA";
    public static final String ADD_SUB_CONFIGURATION_TO_DEFAULT = "ADD_SUB_CONFIGURATION_TO_DEFAULT";
    public static final String MODIFY_SUB_CONFIGURATION_TO_DEFAULT = "MODIFY_SUB_CONFIGURATION_TO_DEFAULT";
    public static final String DELETE_SUB_CONFIGURATION_TO_DEFAULT = "DELETE_SUB_CONFIGURATION_TO_DEFAULT";
    public static final String DELETE_ALL_CONFIGURATIONS = "DELETE_ALL_CONFIGURATIONS";
    public static final String MODIFY_SERVTEMPLATE_ATTEMPT = "MODIFY_SERVTEMPLATE_ATTEMPT";
    public static final String MODIFY_SERVTEMPLATE = "MODIFY_SERVTEMPLATE";
    public static final String ADD_SERVTEMPLATE_ATTEMPT = "ADD_SERVTEMPLATE_ATTEMPT";
    public static final String ADD_SERVTEMPLATE = "ADD_SERVTEMPLATE";
    public static final String REMOVE_SERVTEMPLATE_ATTEMPT = "REMOVE_SERVTEMPLATE_ATTEMPT";
    public static final String REMOVE_SERVTEMPLATE = "REMOVE_SERVTEMPLATE";
    public static final String ADD_NESTED_GROUPS_ATTEMPT = "ADD_NESTED_GROUPS_ATTEMPT";
    public static final String ADD_NESTED_GROUPS = "ADD_NESTED_GROUPS";
    public static final String ADD_USER_ATTEMPT = "ADD_USER_ATTEMPT";
    public static final String ADD_USER = "ADD_USER";
    public static final String CREATE_ENTITY_ATTEMPT = "CREATE_ENTITY_ATTEMPT";
    public static final String CREATE_ENTITY = "CREATE_ENTITY";
    public static final String CREATE_ROLE_ATTEMPT = "CREATE_ROLE_ATTEMPT";
    public static final String CREATE_ROLE = "CREATE_ROLE";
    public static final String CREATE_GROUP_CONTAINER_ATTEMPT = "CREATE_GROUP_CONTAINER_ATTEMPT";
    public static final String CREATE_GROUP_CONTAINER = "CREATE_GROUP_CONTAINER";
    public static final String CREATE_GROUP_ATTEMPT = "CREATE_GROUP_ATTEMPT";
    public static final String CREATE_GROUP = "CREATE_GROUP";
    public static final String CREATE_PC_ATTEMPT = "CREATE_PC_ATTEMPT";
    public static final String CREATE_PC = "CREATE_PC";
    public static final String CREATE_SERVTEMPLATE_ATTEMPT = "CREATE_SERVTEMPLATE_ATTEMPT";
    public static final String CREATE_SERVTEMPLATE = "CREATE_SERVTEMPLATE";
    public static final String CREATE_CONTAINER_ATTEMPT = "CREATE_CONTAINER_ATTEMPT";
    public static final String CREATE_CONTAINER = "CREATE_CONTAINER";
    public static final String CREATE_USER_ATTEMPT = "CREATE_USER_ATTEMPT";
    public static final String CREATE_USER = "CREATE_USER";
    public static final String DELETE_ENTITY_ATTEMPT = "DELETE_ENTITY_ATTEMPT";
    public static final String DELETE_ENTITY = "DELETE_ENTITY";
    public static final String DELETE_PC_ATTEMPT = "DELETE_PC_ATTEMPT";
    public static final String DELETE_PC = "DELETE_PC";
    public static final String DELETE_ROLE_ATTEMPT = "DELETE_ROLE_ATTEMPT";
    public static final String DELETE_ROLE = "DELETE_ROLE";
    public static final String DELETE_SERVTEMPLATE_ATTEMPT = "DELETE_SERVTEMPLATE_ATTEMPT";
    public static final String DELETE_SERVTEMPLATE = "DELETE_SERVTEMPLATE";
    public static final String DELETE_CONTAINER_ATTEMPT = "DELETE_CONTAINER_ATTEMPT";
    public static final String DELETE_CONTAINER = "DELETE_CONTAINER";
    public static final String MODIFY_ENTITY_ATTEMPT = "MODIFY_ENTITY_ATTEMPT";
    public static final String MODIFY_ENTITY = "MODIFY_ENTITY";
    public static final String MODIFY_PC_ATTEMPT = "MODIFY_PC_ATTEMPT";
    public static final String MODIFY_PC = "MODIFY_PC";
    public static final String MODIFY_SUBCONT_ATTEMPT = "MODIFY_SUBCONT_ATTEMPT";
    public static final String MODIFY_SUBCONT = "MODIFY_SUBCONT";
    public static final String REGISTER_SERVICE_ATTEMPT = "REGISTER_SERVICE_ATTEMPT";
    public static final String REGISTER_SERVICE = "REGISTER_SERVICE";
    public static final String UNREGISTER_SERVICE_ATTEMPT = "UNREGISTER_SERVICE_ATTEMPT";
    public static final String UNREGISTER_SERVICE = "UNREGISTER_SERVICE";
    public static final String MODIFY_GROUP_ATTEMPT = "MODIFY_GROUP_ATTEMPT";
    public static final String MODIFY_GROUP = "MODIFY_GROUP";
    public static final String REMOVE_NESTED_GROUP_FROM_GROUP_ATTEMPT = "REMOVE_NESTED_GROUP_FROM_GROUP_ATTEMPT";
    public static final String REMOVE_NESTED_GROUP_FROM_GROUP = "REMOVE_NESTED_GROUP_FROM_GROUP";
    public static final String DELETE_GROUP_ATTEMPT = "DELETE_GROUP_ATTEMPT";
    public static final String DELETE_GROUP = "DELETE_GROUP";
    public static final String ADD_MEMBER_IDENTITY_ATTEMPT = "ADD_MEMBER_IDENTITY_ATTEMPT";
    public static final String ADD_MEMBER_IDENTITY = "ADD_MEMBER_IDENTITY";
    public static final String ASSIGN_SERVICE_IDENTITY_ATTEMPT = "ASSIGN_SERVICE_IDENTITY_ATTEMPT";
    public static final String ASSIGN_SERVICE_IDENTITY = "ASSIGN_SERVICE_IDENTITY";
    public static final String CREATE_IDENTITIES_ATTEMPT = "CREATE_IDENTITIES_ATTEMPT";
    public static final String CREATE_IDENTITIES = "CREATE_IDENTITIES";
    public static final String CREATE_IDENTITY_ATTEMPT = "CREATE_IDENTITY_ATTEMPT";
    public static final String CREATE_IDENTITY = "CREATE_IDENTITY";
    public static final String DELETE_IDENTITY_ATTEMPT = "DELETE_IDENTITY_ATTEMPT";
    public static final String DELETE_IDENTITY = "DELETE_IDENTITY";
    public static final String MODIFY_SERVICE_IDENTITY_ATTEMPT = "MODIFY_SERVICE_IDENTITY_ATTEMPT";
    public static final String MODIFY_SERVICE_IDENTITY = "MODIFY_SERVICE_IDENTITY";
    public static final String REMOVE_MEMBER_IDENTITY_ATTEMPT = "REMOVE_MEMBER_IDENTITY_ATTEMPT";
    public static final String REMOVE_MEMBER_IDENTITY = "REMOVE_MEMBER_IDENTITY";
    public static final String SET_ATTRIBUTES_IDENTITY_ATTEMPT = "SET_ATTRIBUTES_IDENTITY_ATTEMPT";
    public static final String SET_ATTRIBUTES_IDENTITY = "SET_ATTRIBUTES_IDENTITY";
    public static final String UNASSIGN_SERVICE_IDENTITY_ATTEMPT = "UNASSIGN_SERVICE_IDENTITY_ATTEMPT";
    public static final String UNASSIGN_SERVICE_IDENTITY = "UNASSIGN_SERVICE_IDENTITY";
    public static final String CREATE_SUBORG_ATTEMPT = "CREATE_SUBORG_ATTEMPT";
    public static final String CREATE_SUBORG = "CREATE_SUBORG";
    public static final String DELETE_SUBORG_ATTEMPT = "DELETE_SUBORG_ATTEMPT";
    public static final String DELETE_SUBORG = "DELETE_SUBORG";
    public static final String MODIFY_ROLE_ATTEMPT = "MODIFY_ROLE_ATTEMPT";
    public static final String MODIFY_ROLE = "MODIFY_ROLE";
    public static final String MODIFY_SUBORG_ATTEMPT = "MODIFY_SUBORG_ATTEMPT";
    public static final String MODIFY_SUBORG = "MODIFY_SUBORG";
    public static final String DELETE_USER_ATTEMPT = "DELETE_USER_ATTEMPT";
    public static final String DELETE_USER = "DELETE_USER";
    public static final String MODIFY_USER_ATTEMPT = "MODIFY_USER_ATTEMPT";
    public static final String MODIFY_USER = "MODIFY_USER";
    public static final String ADD_ATTRVALS_REALM_ATTEMPT = "ADD_ATTRVALS_REALM_ATTEMPT";
    public static final String ADD_ATTRVALS_REALM = "ADD_ATTRVALS_REALM";
    public static final String ASSIGN_SERVICE_TO_REALM_ATTEMPT = "ASSIGN_SERVICE_TO_REALM_ATTEMPT";
    public static final String ASSIGN_SERVICE_TO_REALM = "ASSIGN_SERVICE_TO_REALM";
    public static final String ASSIGN_SERVICE_TO_REALM_NOTINLIST = "ASSIGN_SERVICE_TO_REALM_NOTINLIST";
    public static final String ASSIGN_SERVICE_TO_ORGCONFIG_ATTEMPT = "ASSIGN_SERVICE_TO_ORGCONFIG_ATTEMPT";
    public static final String ASSIGN_SERVICE_TO_ORGCONFIG = "ASSIGN_SERVICE_TO_ORGCONFIG";
    public static final String ASSIGN_SERVICE_TO_ORGCONFIG_NOTINLIST = "ASSIGN_SERVICE_TO_ORGCONFIG_NOTINLIST";
    public static final String CREATE_REALM_ATTEMPT = "CREATE_REALM_ATTEMPT";
    public static final String CREATE_REALM = "CREATE_REALM";
    public static final String DELETE_REALM_ATTEMPT = "DELETE_REALM_ATTEMPT";
    public static final String DELETE_REALM = "DELETE_REALM";
    public static final String MODIFY_SERVICE_REALM_ATTEMPT = "MODIFY_SERVICE_REALM_ATTEMPT";
    public static final String MODIFY_SERVICE_REALM = "MODIFY_SERVICE_REALM";
    public static final String MODIFY_SERVICE_ORGCONFIG_ATTEMPT = "MODIFY_SERVICE_ORGCONFIG_ATTEMPT";
    public static final String MODIFY_SERVICE_ORGCONFIG = "MODIFY_SERVICE_ORGCONFIG";
    public static final String MODIFY_SERVICE_NOTIN_ORGCONFIG_OR_REALM = "MODIFY_SERVICE_NOTIN_ORGCONFIG_OR_REALM";
    public static final String REMOVE_ATTRIBUTE_FROM_SERVICE_ATTEMPT = "REMOVE_ATTRIBUTE_FROM_SERVICE_ATTEMPT";
    public static final String REMOVE_ATTRIBUTE_FROM_SERVICE = "REMOVE_ATTRIBUTE_FROM_SERVICE";
    public static final String REMOVE_ATTRVALS_REALM_ATTEMPT = "REMOVE_ATTRVALS_REALM_ATTEMPT";
    public static final String REMOVE_ATTRVALS_REALM = "REMOVE_ATTRVALS_REALM";
    public static final String SET_ATTRS_REALM_ATTEMPT = "SET_ATTRS_REALM_ATTEMPT";
    public static final String SET_ATTRS_REALM = "SET_ATTRS_REALM";
    public static final String UNASSIGN_SERVICE_FROM_REALM_ATTEMPT = "UNASSIGN_SERVICE_FROM_REALM_ATTEMPT";
    public static final String UNASSIGN_SERVICE_FROM_REALM = "UNASSIGN_SERVICE_FROM_REALM";
    public static final String UNASSIGN_SERVICE_FROM_ORGCONFIG_ATTEMPT = "UNASSIGN_SERVICE_FROM_ORGCONFIG_ATTEMPT";
    public static final String UNASSIGN_SERVICE_FROM_ORGCONFIG = "UNASSIGN_SERVICE_FROM_ORGCONFIG";
    public static final String UNASSIGN_SERVICE_NOTIN_ORGCONFIG_OR_REALM = "UNASSIGN_SERVICE_NOTIN_ORGCONFIG_OR_REALM";
    public static final String REMOVE_USER_FROM_ROLE_ATTEMPT = "REMOVE_USER_FROM_ROLE_ATTEMPT";
    public static final String REMOVE_USER_FROM_ROLE = "REMOVE_USER_FROM_ROLE";
    public static final String REMOVE_USER_FROM_GROUP_ATTEMPT = "REMOVE_USER_FROM_GROUP_ATTEMPT";
    public static final String REMOVE_USER_FROM_GROUP = "REMOVE_USER_FROM_GROUP";
    public static final String STATUS_MSG36 = "STATUS_MSG36";

    private AdminUtils() {
    }

    static void setDebug(Debug debug) {
        AdminUtils.debug = debug;
    }

    static void setDebugStatus(int n) {
        debug.setDebug(n);
    }

    static void setLog(boolean bl) {
        logEnabled = bl;
    }

    static void setSSOToken(SSOToken sSOToken) {
        ssot = sSOToken;
    }

    static void enableVerbose(boolean bl) {
        verboseEnabled = bl;
        level = 1;
    }

    static void enableDebug(boolean bl) {
        debugEnabled = bl;
        level = 2;
    }

    public static void log(String string) {
        if (level == 1) {
            System.out.println(string);
        } else if (level == 2 && debug != null && debug.messageEnabled()) {
            debug.message(string);
        }
    }

    public static void logOperation(int n, String string) {
        AdminUtils.logOperation(n, string, ssot);
    }

    public static void logOperation(int n, String string, SSOToken sSOToken) {
        if (logEnabled) {
            LogRecord logRecord = new LogRecord(Level.INFO, string, sSOToken);
            try {
                logRecord.addLogInfo("HostName", sSOToken.getHostName());
                logRecord.addLogInfo("LoginID", sSOToken.getPrincipal().getName());
            }
            catch (SSOException sSOException) {
                debug.error("AdminUtils.logOperation", (Throwable)sSOException);
            }
            logRecord.addLogInfo("LoginIDSid", sSOToken.getTokenID().toString());
            switch (n) {
                case 0: {
                    logger = (Logger)Logger.getLogger(ACCESS_LOG);
                    logRecord.addLogInfo("ModuleName", ACCESS_LOG);
                    break;
                }
                case 1: {
                    logger = (Logger)Logger.getLogger(ERROR_LOG);
                    logRecord.addLogInfo("ModuleName", ERROR_LOG);
                    break;
                }
                default: {
                    logger = (Logger)Logger.getLogger(ACCESS_LOG);
                    logRecord.addLogInfo("ModuleName", ACCESS_LOG);
                }
            }
            logger.log(logRecord, sSOToken);
        }
    }

    public static void logOperation(int n, Level level, String string, String[] stringArray) {
        if (level == null) {
            level = Level.INFO;
        }
        if (logEnabled) {
            switch (n) {
                case 0: {
                    logger = (Logger)Logger.getLogger(ACCESS_LOG);
                    break;
                }
                case 1: {
                    logger = (Logger)Logger.getLogger(ERROR_LOG);
                    break;
                }
                default: {
                    logger = (Logger)Logger.getLogger(ACCESS_LOG);
                }
            }
            if (logger.isLoggable(level)) {
                try {
                    LogMessageProvider logMessageProvider = MessageProviderFactory.getProvider("Amadmin_CLI");
                    LogRecord logRecord = logMessageProvider.createLogRecord(string, stringArray, ssot);
                    if (logRecord != null) {
                        logger.log(logRecord, ssot);
                    }
                }
                catch (Exception exception) {
                    debug.error("Error getting log message provider: " + exception.getMessage());
                }
            }
        }
    }

    public static void log(String string, Throwable throwable) {
        if (level == 1) {
            System.err.println(string);
        } else if (level == 2 && debug != null && debugEnabled) {
            debug.error(string, throwable);
        }
    }

    public static boolean logEnabled() {
        return verboseEnabled || debugEnabled;
    }

    static void printAttributeNameValuesMap(PrintWriter printWriter, PrintUtils printUtils, Map map) {
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            printWriter.println("  " + k.toString());
            printUtils.printAVPairs((Map)map.get(k), 2);
        }
    }

    static void printAttributeNameValuesMap(PrintWriter printWriter, PrintUtils printUtils, SSOToken sSOToken, Map map, String string, SchemaType schemaType) {
        Set set = map.keySet();
        Map map2 = null;
        try {
            map2 = schemaType == null ? AdminUtils.getAttributeSchemas(string, sSOToken) : AdminUtils.getAttributeSchemas(string, schemaType, sSOToken);
        }
        catch (AdminException adminException) {
            debug.error("AdminUtils.printAttributeNameValuesMap", (Throwable)adminException);
            map2 = Collections.EMPTY_MAP;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            printWriter.println("  " + k.toString());
            Map map3 = AdminUtils.maskPassword((Map)map.get(k), map2);
            printUtils.printAVPairs(map3, 2);
        }
    }

    private static Map maskPassword(Map map, Map map2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(map.size() * 2);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            String string = (String)iterator.next();
            AttributeSchema attributeSchema = (AttributeSchema)map2.get(string.toLowerCase());
            boolean bl = false;
            if (attributeSchema != null) {
                object = attributeSchema.getSyntax();
                boolean bl2 = bl = ((AttributeSchema.Syntax)object).equals(AttributeSchema.Syntax.PASSWORD) || ((AttributeSchema.Syntax)object).equals(AttributeSchema.Syntax.ENCRYPTED_PASSWORD);
            }
            if (bl) {
                object = new HashSet(2);
                object.add("********");
                hashMap.put(string, object);
                continue;
            }
            hashMap.put(string, map.get(string));
        }
        return hashMap;
    }

    static boolean isChildOf(AMObject aMObject, String string) {
        return AdminUtils.isDescendantOf(aMObject, string, 1);
    }

    static boolean isDescendantOf(AMObject aMObject, String string) {
        return AdminUtils.isDescendantOf(aMObject, string, 2);
    }

    static boolean isDescendantOf(AMObject aMObject, String string, int n) {
        boolean bl = LDAPDN.equals((String)aMObject.getDN(), (String)string);
        if (!bl) {
            if (n == 1) {
                bl = LDAPDN.equals((String)aMObject.getParentDN(), (String)string);
            } else {
                DN dN = new DN(aMObject.getDN());
                bl = dN.isDescendantOf(new DN(string));
            }
        }
        return bl;
    }

    static boolean isDescendantOf(AMEntity aMEntity, String string, int n) {
        boolean bl = LDAPDN.equals((String)aMEntity.getDN(), (String)string);
        if (!bl) {
            if (n == 1) {
                bl = LDAPDN.equals((String)aMEntity.getParentDN(), (String)string);
            } else {
                DN dN = new DN(aMEntity.getDN());
                bl = dN.isDescendantOf(new DN(string));
            }
        }
        return bl;
    }

    static String getPeopleContainerDN(AMOrganization aMOrganization) throws AdminException {
        try {
            Set set = aMOrganization.getPeopleContainers(1);
            String string = null;
            if (set != null && !set.isEmpty()) {
                string = (String)set.iterator().next();
            }
            return string;
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }

    static String getPeopleContainerDN(AMOrganizationalUnit aMOrganizationalUnit) throws AdminException {
        try {
            Set set = aMOrganizationalUnit.getPeopleContainers(1);
            String string = null;
            if (set != null && !set.isEmpty()) {
                string = (String)set.iterator().next();
            }
            return string;
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }

    private static Map getAttributeSchemas(String string, SchemaType schemaType, SSOToken sSOToken) throws AdminException {
        Map map = Collections.EMPTY_MAP;
        try {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, sSOToken);
            map = AdminUtils.getAttributeSchemas(serviceSchemaManager, schemaType);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
        catch (SMSException sMSException) {
            throw new AdminException(sMSException);
        }
        return map;
    }

    private static Map getAttributeSchemas(ServiceSchemaManager serviceSchemaManager, SchemaType schemaType) throws SSOException, SMSException {
        HashMap<String, AttributeSchema> hashMap = Collections.EMPTY_MAP;
        ServiceSchema serviceSchema = serviceSchemaManager.getSchema(schemaType);
        Set set = serviceSchema.getAttributeSchemas();
        if (set != null && !set.isEmpty()) {
            hashMap = new HashMap<String, AttributeSchema>(set.size() * 2);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
                hashMap.put(attributeSchema.getName().toLowerCase(), attributeSchema);
            }
        }
        return hashMap;
    }

    private static Map getAttributeSchemas(String string, SSOToken sSOToken) throws AdminException {
        HashMap hashMap = new HashMap();
        try {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, sSOToken);
            Set set = serviceSchemaManager.getSchemaTypes();
            if (set != null && !set.isEmpty()) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    hashMap.putAll(AdminUtils.getAttributeSchemas(serviceSchemaManager, (SchemaType)iterator.next()));
                }
            }
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
        catch (SMSException sMSException) {
            throw new AdminException(sMSException);
        }
        return hashMap;
    }

    static {
        debug = null;
        logger = null;
        verboseEnabled = false;
        debugEnabled = false;
        logEnabled = true;
        ssot = null;
    }
}

