/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common.validation;

import com.sun.identity.common.validation.ValidationException;
import com.sun.identity.common.validation.ValidatorBase;

public class XSDurationValidator
extends ValidatorBase {
    private static XSDurationValidator instance = new XSDurationValidator();
    private static boolean debug = false;

    private XSDurationValidator() {
    }

    public static XSDurationValidator getInstance() {
        return instance;
    }

    protected void performValidation(String string) throws ValidationException {
        int n;
        if (string == null || string.trim().length() == 0 || string.trim().length() < 3) {
            throw new ValidationException("amValidation", "errorCode4");
        }
        if (string.charAt(0) != 'P') {
            throw new ValidationException("amValidation", "errorCode4");
        }
        String string2 = null;
        String string3 = null;
        if (string.indexOf(84) != -1) {
            if (string.charAt(string.length() - 1) == 'T') {
                throw new ValidationException("amValidation", "errorCode4");
            }
            n = string.indexOf("T");
            string2 = string.substring(n + 1, string.length());
            string3 = string.substring(1, n);
        } else {
            if (string.indexOf("H") != -1 || string.indexOf("S") != -1) {
                throw new ValidationException("amValidation", "errorCode4");
            }
            string3 = string.substring(1);
        }
        n = 0;
        this.processTimeStr(string2);
        this.processDateStr(string3);
    }

    private int getIntegerValue(String string, int n, int n2) throws ValidationException {
        int n3 = 0;
        String string2 = string.substring(n, n2);
        try {
            n3 = Integer.parseInt(string2);
            if (n3 < 0) {
                throw new ValidationException("amValidation", "errorCode4");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ValidationException("amValidation", "errorCode4");
        }
        return n3;
    }

    private double getDoubleValue(String string, int n, int n2) throws ValidationException {
        double d = 0.0;
        String string2 = string.substring(n, n2);
        try {
            d = Double.parseDouble(string2);
            if (d < 0.0) {
                throw new ValidationException("amValidation", "errorCode4");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ValidationException("amValidation", "errorCode4");
        }
        return d;
    }

    private void processTimeStr(String string) throws ValidationException {
        if (string != null) {
            int n;
            if (string.indexOf("Y") != -1 || string.indexOf("D") != -1) {
                throw new ValidationException("amValidation", "errorCode4");
            }
            int n2 = string.indexOf(72);
            int n3 = string.indexOf(77);
            int n4 = string.indexOf(83);
            if (n2 != -1 && (n3 != -1 && n3 < n2 || n4 != -1 && n4 < n2)) {
                throw new ValidationException("amValidation", "errorCode4");
            }
            if (n3 != -1 && n4 != -1 && n4 < n3) {
                throw new ValidationException("amValidation", "errorCode4");
            }
            int n5 = 0;
            if (n2 != -1) {
                n = this.getIntegerValue(string, n5, n2);
                n3 = string.indexOf(77, n2 + 1);
                n5 = n2 + 1;
            }
            if (n3 != -1) {
                n = this.getIntegerValue(string, n5, n3);
                n4 = string.indexOf(83, n3 + 1);
                n5 = n3 + 1;
            }
            if (n4 != -1) {
                if (string.charAt(n4 - 1) == '.') {
                    throw new ValidationException("amValidation", "errorCode4");
                }
                this.getDoubleValue(string, n5, n4);
            }
        }
    }

    private void processDateStr(String string) throws ValidationException {
        if (string != null) {
            if (string.indexOf("H") != 1 && string.indexOf("S") != -1) {
                throw new ValidationException("amValidation", "errorCode4");
            }
            int n = string.indexOf(89);
            int n2 = string.indexOf(77);
            int n3 = string.indexOf(68);
            if (n != -1 && (n2 != -1 && n2 < n || n3 != -1 && n3 < n)) {
                throw new ValidationException("amValidation", "errorCode4");
            }
            if (n2 != -1 && n3 != -1 && n3 < n2) {
                throw new ValidationException("amValidation", "errorCode4");
            }
            int n4 = 0;
            if (n != -1) {
                this.getIntegerValue(string, n4, n);
                n2 = string.indexOf(77, n + 1);
                n4 = n + 1;
            }
            if (n2 != -1) {
                this.getIntegerValue(string, n4, n2);
                n3 = string.indexOf(68, n2 + 1);
                n4 = n2 + 1;
            }
            if (n3 != -1) {
                this.getIntegerValue(string, n4, n3);
            }
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray[0] != null) {
            debug = new Boolean(stringArray[0]);
        }
        XSDurationValidator xSDurationValidator = XSDurationValidator.getInstance();
        try {
            xSDurationValidator.validate("P1Y2M4D");
            xSDurationValidator.validate("PT9H8M1.1S");
            xSDurationValidator.validate("PT9H");
            xSDurationValidator.validate("PT9M");
            xSDurationValidator.validate("PT9S");
            xSDurationValidator.validate("PT9H8M111S");
            xSDurationValidator.validate("P1Y2M4DT9H8M20S");
            xSDurationValidator.validate("P1Y2M4D");
            xSDurationValidator.validate("P1Y2MD");
            xSDurationValidator.validate("P1Y2M4DT");
            xSDurationValidator.validate("P1Y2M4DT1.S");
            xSDurationValidator.validate("1Y2M4DT9H8MS");
            xSDurationValidator.validate("P1Y2M4DT9H8M20S");
            xSDurationValidator.validate("P1Y2M4DT9H8MS");
        }
        catch (ValidationException validationException) {
            System.out.println(validationException.getMessage());
        }
        catch (Exception exception) {
            System.out.println("Error " + exception.getMessage());
        }
    }
}

