/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common.admin;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.security.Principal;
import java.util.Map;
import java.util.Set;

public class AdminInterfaceUtils
implements ServiceListener {
    private static boolean initialized;
    private static boolean addedListener;
    private static Debug debug;
    private static String defaultPC;
    private static String defaultGC;
    private static String defaultAC;
    private static String defaultPCCreateDuringOrgConfig;
    private static String defaultGCCreateDuringOrgConfig;
    private static String defaultORGADMIN;
    private static String defaultHELP_DESK_ADMIN;
    private static String defaultPOLICY_ADMIN;
    private static final String CONSOLE_SERVICE_NAME = "iplanetamadminconsoleservice";
    private static final String SERVICE_NAME = "dai";
    private static final String PC_ATTR_NAME = "iplanet-am-admin-console-default-pc";
    private static final String GC_ATTR_NAME = "iplanet-am-admin-console-default-gc";
    private static final String AC_ATTR_NAME = "iplanet-am-admin-console-default-ac";
    private static final String TEMPLATES = "templates";
    private static final String STRUCTURE_TEMPLATES = "StructureTemplates";
    private static final String ATTR_NAME = "name";
    private static final String PCCREATE_ATTR_NAME = "PeopleContainer";
    private static final String GCCREATE_ATTR_NAME = "GroupContainer";
    private static final String ORG_ADMIN_ATTR_NAME = "DPOrgAdminRole";
    private static final String HELP_DESK_ADMIN_ATTR_NAME = "DPOrgHelpDeskAdminRole";
    private static final String POLICY_ADMIN_ATTR_NAME = "DPOrgPolicyAdminRole";

    public static AMObject getAMObject(Debug debug, String string, AMStoreConnection aMStoreConnection) throws AMException, SSOException {
        AMOrganization aMOrganization = null;
        int n = aMStoreConnection.getAMObjectType(string);
        switch (n) {
            case 2: {
                aMOrganization = aMStoreConnection.getOrganization(string);
                break;
            }
            case 3: {
                aMOrganization = aMStoreConnection.getOrganizationalUnit(string);
                break;
            }
            case 9: 
            case 10: {
                aMOrganization = aMStoreConnection.getStaticGroup(string);
                break;
            }
            case 11: {
                aMOrganization = aMStoreConnection.getDynamicGroup(string);
                break;
            }
            case 12: {
                aMOrganization = aMStoreConnection.getAssignableDynamicGroup(string);
                break;
            }
            case 6: {
                aMOrganization = aMStoreConnection.getRole(string);
                break;
            }
            case 8: {
                aMOrganization = aMStoreConnection.getFilteredRole(string);
                break;
            }
            case 1: {
                aMOrganization = aMStoreConnection.getUser(string);
                break;
            }
            case 5: {
                aMOrganization = aMStoreConnection.getPeopleContainer(string);
                break;
            }
            case 4: {
                aMOrganization = aMStoreConnection.getGroupContainer(string);
                break;
            }
            default: {
                if (!debug.warningEnabled()) break;
                debug.warning("AdminInterfaceUtils.getAMObject: Cannot create AMObject for:" + string);
            }
        }
        return aMOrganization;
    }

    public static boolean inOrganizationalUnit(Debug debug, AMStoreConnection aMStoreConnection, AMObject aMObject) {
        boolean bl = false;
        String string = aMObject.getParentDN();
        try {
            while (string != null && !bl) {
                if (aMStoreConnection.getAMObjectType(string) == 3) {
                    bl = true;
                    continue;
                }
                AMObject aMObject2 = AdminInterfaceUtils.getAMObject(debug, string, aMStoreConnection);
                String string2 = string = aMObject2 != null ? aMObject2.getParentDN() : null;
            }
        }
        catch (SSOException sSOException) {
            debug.warning("AdminInterfaceUtils.inOrganizationalUnit", sSOException);
        }
        catch (AMException aMException) {
            debug.warning("AdminInterfaceUtils.inOrganizationalUnit", aMException);
        }
        return bl;
    }

    public static String getNamingAttribute(int n, Debug debug) {
        String string = "";
        try {
            string = AMStoreConnection.getNamingAttribute((int)n);
        }
        catch (AMException aMException) {
            debug.warning("couldn't get naming attribute");
        }
        return string;
    }

    public static String defaultPeopleContainerName() {
        AdminInterfaceUtils.initialize();
        return defaultPC;
    }

    public static String defaultGroupContainerName() {
        AdminInterfaceUtils.initialize();
        return defaultGC;
    }

    public static String defaultAgentContainerName() {
        AdminInterfaceUtils.initialize();
        return defaultAC;
    }

    public static String defaultPCCreateDuringOrgConfig() {
        AdminInterfaceUtils.initialize();
        return defaultPCCreateDuringOrgConfig;
    }

    public static String defaultGCCreateDuringOrgConfig() {
        AdminInterfaceUtils.initialize();
        return defaultGCCreateDuringOrgConfig;
    }

    public static String defaultOrgAdminRoleCreateDuringOrgConfig() {
        AdminInterfaceUtils.initialize();
        return defaultORGADMIN;
    }

    public static String defaultHelpDeskAdminRoleCreateDuringOrgConfig() {
        AdminInterfaceUtils.initialize();
        return defaultHELP_DESK_ADMIN;
    }

    public static String defaultPolicyAdminRoleCreateDuringOrgConfig() {
        AdminInterfaceUtils.initialize();
        return defaultPOLICY_ADMIN;
    }

    private static void initialize() {
        if (!initialized) {
            try {
                String string = (String)AccessController.doPrivileged(new AdminDNAction());
                String string2 = (String)AccessController.doPrivileged(new AdminPasswordAction());
                SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
                ServiceConfigManager serviceConfigManager = new ServiceConfigManager(SERVICE_NAME, sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string), string2));
                if (!addedListener) {
                    addedListener = true;
                    serviceConfigManager.addListener((ServiceListener)new AdminInterfaceUtils());
                }
                ServiceConfig serviceConfig = serviceConfigManager.getGlobalConfig(null);
                ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(TEMPLATES);
                ServiceConfig serviceConfig3 = serviceConfig2.getSubConfig(STRUCTURE_TEMPLATES);
                ServiceConfig serviceConfig4 = serviceConfig3.getSubConfig(GCCREATE_ATTR_NAME);
                ServiceConfig serviceConfig5 = serviceConfig3.getSubConfig(PCCREATE_ATTR_NAME);
                ServiceConfig serviceConfig6 = serviceConfig3.getSubConfig(ORG_ADMIN_ATTR_NAME);
                ServiceConfig serviceConfig7 = serviceConfig3.getSubConfig(HELP_DESK_ADMIN_ATTR_NAME);
                ServiceConfig serviceConfig8 = serviceConfig3.getSubConfig(POLICY_ADMIN_ATTR_NAME);
                defaultGCCreateDuringOrgConfig = AdminInterfaceUtils.getConfigAttributeValue(serviceConfig4, defaultGCCreateDuringOrgConfig);
                defaultPCCreateDuringOrgConfig = AdminInterfaceUtils.getConfigAttributeValue(serviceConfig5, defaultPCCreateDuringOrgConfig);
                defaultORGADMIN = AdminInterfaceUtils.getConfigAttributeValue(serviceConfig6, defaultORGADMIN);
                defaultHELP_DESK_ADMIN = AdminInterfaceUtils.getConfigAttributeValue(serviceConfig7, defaultHELP_DESK_ADMIN);
                defaultPOLICY_ADMIN = AdminInterfaceUtils.getConfigAttributeValue(serviceConfig8, defaultPOLICY_ADMIN);
                ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(CONSOLE_SERVICE_NAME, sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string), string2));
                if (!addedListener) {
                    addedListener = true;
                    serviceSchemaManager.addListener((ServiceListener)new AdminInterfaceUtils());
                }
                ServiceSchema serviceSchema = serviceSchemaManager.getGlobalSchema();
                defaultAC = AdminInterfaceUtils.getAttributeValue(serviceSchema, AC_ATTR_NAME, defaultAC);
                defaultGC = AdminInterfaceUtils.getAttributeValue(serviceSchema, GC_ATTR_NAME, defaultGC);
                defaultPC = AdminInterfaceUtils.getAttributeValue(serviceSchema, PC_ATTR_NAME, defaultPC);
            }
            catch (Exception exception) {
                debug.warning("AdminInterfaceUtils: Unable to get default People, Groups, Org Admin Role, Help Desk Admin Role, Policy Admin Role and Agents containers from SM", exception);
            }
            if (debug.messageEnabled()) {
                debug.message("AdminInterfaceUtils: Defaults container: " + defaultPC + ", " + defaultGC + ", " + defaultAC + ", " + defaultPCCreateDuringOrgConfig + ", " + defaultGCCreateDuringOrgConfig + ", " + defaultORGADMIN + ", " + defaultHELP_DESK_ADMIN + ", " + defaultPOLICY_ADMIN);
            }
            initialized = true;
        }
    }

    private static String getAttributeValue(ServiceSchema serviceSchema, String string, String string2) throws SSOException, SMSException {
        Set set;
        String string3 = string2;
        AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string);
        if (attributeSchema != null && (set = attributeSchema.getDefaultValues()) != null && !set.isEmpty()) {
            string3 = (String)set.iterator().next();
        }
        return string3;
    }

    private static String getConfigAttributeValue(ServiceConfig serviceConfig, String string) throws SSOException, SMSException {
        String string2 = string;
        Map map = serviceConfig.getAttributes();
        if (map != null) {
            Set set = (Set)map.get(ATTR_NAME);
            if (set == null || set.isEmpty()) {
                return null;
            }
            string2 = (String)set.iterator().next();
            int n = string2.indexOf("=");
            if (n >= 0) {
                string2 = string2.substring(n + 1);
                if (debug.messageEnabled()) {
                    debug.message("AdminInterfaceUtils: getConfigAttributeValue: " + string2);
                }
            }
        }
        return string2;
    }

    public void schemaChanged(String string, String string2) {
        if (string.toLowerCase().equals(SERVICE_NAME)) {
            initialized = false;
        }
    }

    public void globalConfigChanged(String string, String string2, String string3, String string4, int n) {
        if (string.toLowerCase().equals(SERVICE_NAME)) {
            initialized = false;
        }
    }

    public void organizationConfigChanged(String string, String string2, String string3, String string4, String string5, int n) {
        if (string.toLowerCase().equals(SERVICE_NAME)) {
            initialized = false;
        }
    }

    static {
        debug = Debug.getInstance("amConsole");
        defaultPC = "People";
        defaultGC = "Groups";
        defaultAC = "Agents";
        defaultPCCreateDuringOrgConfig = "People";
        defaultGCCreateDuringOrgConfig = "Groups";
        defaultORGADMIN = "Organization Admin Role";
        defaultHELP_DESK_ADMIN = "Organization Help Desk Admin Role";
        defaultPOLICY_ADMIN = "Organization Policy Admin Role";
    }
}

