/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.iplanet.am.util.SystemProperties;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FQDNUtils {
    private Map fqdnMap;
    private String defaultHostName;
    private Set validHostNames;

    public FQDNUtils() {
        this.fqdnMap = this.getFQDNMapFromAMConfig();
        this.defaultHostName = SystemProperties.get("com.iplanet.am.server.host");
        this.validHostNames = this.getLowerCaseValuesFromMap(this.fqdnMap);
        this.validHostNames.add(this.defaultHostName.toLowerCase());
    }

    public FQDNUtils(Map map, String string) {
        this.fqdnMap = map;
        this.defaultHostName = string;
        this.validHostNames = this.getLowerCaseValuesFromMap(map);
        this.validHostNames.add(string.toLowerCase());
    }

    private Map getFQDNMapFromAMConfig() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = "com.sun.identity.server.fqdnMap[";
        int n = string.length();
        Enumeration<?> enumeration = SystemProperties.getAll().propertyNames();
        while (enumeration.hasMoreElements()) {
            int n2;
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string) || (n2 = string2.indexOf(93, n + 1)) == -1) continue;
            String string3 = string2.substring(n, n2);
            if ((string3 = string3.trim()).length() <= 0) continue;
            hashMap.put(string3, SystemProperties.get(string2));
        }
        return hashMap;
    }

    private Set getLowerCaseValuesFromMap(Map map) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            hashSet.add(((String)iterator.next()).toLowerCase());
        }
        return hashSet;
    }

    public boolean isHostnameValid(String string) {
        return string != null && this.validHostNames.contains(string.toLowerCase());
    }

    public String getFullyQualifiedHostName(String string) {
        String string2 = null;
        if (!(this.isHostnameValid(string) || (string2 = (String)this.fqdnMap.get(string)) != null && string2.length() != 0)) {
            string2 = this.defaultHostName;
        }
        return string2;
    }
}

