/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateUtils {
    private static final String UTC_DATE_Z_FORMAT = "{0}-{1}-{2}T{3}:{4}:{5}Z";
    private static final String UTC_DATE_FORMAT = "{0}-{1}-{2}T{3}:{4}:{5}";
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");

    public static String dateToString(Date date) {
        return DateUtils.dateToString(date, UTC_DATE_FORMAT);
    }

    public static String toUTCDateFormat(Date date) {
        return DateUtils.dateToString(date, UTC_DATE_Z_FORMAT);
    }

    private static String dateToString(Date date, String string) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(UTC_TIME_ZONE);
        gregorianCalendar.setTime(date);
        Object[] objectArray = new String[]{DateUtils.formatInteger(gregorianCalendar.get(1), 4), DateUtils.formatInteger(gregorianCalendar.get(2) + 1, 2), DateUtils.formatInteger(gregorianCalendar.get(5), 2), DateUtils.formatInteger(gregorianCalendar.get(11), 2), DateUtils.formatInteger(gregorianCalendar.get(12), 2), DateUtils.formatInteger(gregorianCalendar.get(13), 2)};
        return MessageFormat.format(string, objectArray);
    }

    private static String formatInteger(int n, int n2) {
        String string = Integer.toString(n);
        int n3 = n2 - string.length();
        int n4 = 0;
        while (n4 < n3) {
            string = "0" + string;
            ++n4;
        }
        return string;
    }

    public static Date stringToDate(String string) throws ParseException {
        int n;
        int[] nArray = null;
        boolean bl = true;
        int n2 = string.indexOf(84);
        if (n2 == -1) {
            throw new ParseException("Invalid Date Format", 0);
        }
        int n3 = string.indexOf(45, n2);
        if (n3 == -1) {
            n3 = string.indexOf(43, n2);
            bl = false;
        }
        if (n3 != -1) {
            nArray = DateUtils.getDiffTime(string, n3);
            string = string.substring(0, n3);
        }
        if ((n = string.indexOf(46)) != -1) {
            string = string.substring(0, n);
        } else {
            char c = string.charAt(string.length() - 1);
            if (c == 'z' || c == 'Z') {
                string = string.substring(0, string.length() - 1);
            }
        }
        return DateUtils.createDate(string, nArray, bl);
    }

    private static int[] getDiffTime(String string, int n) throws ParseException {
        String string2 = string.substring(n + 1, string.length() - 1);
        int[] nArray = new int[2];
        int n2 = string2.indexOf(58);
        if (n2 == -1) {
            throw new ParseException("Invalid Date Format", 0);
        }
        try {
            nArray[0] = Integer.parseInt(string2.substring(0, n2));
            nArray[1] = Integer.parseInt(string2.substring(n2 + 1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Invalid Date Format", 0);
        }
        return nArray;
    }

    private static Date createDate(String string, int[] nArray, boolean bl) throws ParseException {
        try {
            int n = Integer.parseInt(string.substring(0, 4));
            if (string.charAt(4) != '-') {
                throw new ParseException("Invalid Date Format", 0);
            }
            int n2 = Integer.parseInt(string.substring(5, 7)) - 1;
            if (string.charAt(7) != '-') {
                throw new ParseException("Invalid Date Format", 0);
            }
            int n3 = Integer.parseInt(string.substring(8, 10));
            if (string.charAt(10) != 'T') {
                throw new ParseException("Invalid Date Format", 0);
            }
            int n4 = Integer.parseInt(string.substring(11, 13));
            if (string.charAt(13) != ':') {
                throw new ParseException("Invalid Date Format", 0);
            }
            int n5 = Integer.parseInt(string.substring(14, 16));
            int n6 = 0;
            if (string.length() > 17) {
                if (string.charAt(16) != ':') {
                    throw new ParseException("Invalid Date Format", 0);
                }
                n6 = Integer.parseInt(string.substring(17, 19));
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2, n3, n4, n5, n6);
            ((Calendar)gregorianCalendar).setTimeZone(UTC_TIME_ZONE);
            if (nArray != null) {
                int n7 = bl ? nArray[0] : -1 * nArray[0];
                int n8 = bl ? nArray[1] : -1 * nArray[1];
                gregorianCalendar.add(10, n7);
                gregorianCalendar.add(12, n8);
            }
            return gregorianCalendar.getTime();
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Invalid Date Format", 0);
        }
    }
}

