/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.iplanet.am.sdk.AMConstants;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMInvalidDNException;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMServiceUtils;
import com.iplanet.am.sdk.AMUserPasswordValidation;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import java.security.AccessController;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class AMUserPasswordValidationPlugin
extends AMUserPasswordValidation
implements AMConstants {
    static Debug debug = Debug.getInstance("amProfile_ldap");
    private static String SEPERATOR = "|";

    public void validateUserID(String string, Map map) throws AMException {
        Object[] objectArray;
        StringBuffer stringBuffer = new StringBuffer(10);
        SSOToken sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        String string2 = (String)map.get("organization_name");
        String string3 = this.getOrgUserInvalidChars(string2, sSOToken);
        if (string == null || string.equals("")) {
            debug.error("AMUserPasswordValidationPlugin.validateUserID() : Source string is null or empty" + string);
            throw new AMInvalidDNException(AMSDKBundle.getString((String)"157"), "157");
        }
        if (string3 == null || string3.length() == 0) {
            debug.error("AMUserPasswordValidationPlugin.validateUserID() : List of invalid characters is null or empty" + string3);
            throw new AMInvalidDNException(AMSDKBundle.getString((String)"157"), "157");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, SEPERATOR);
        while (stringTokenizer.hasMoreTokens()) {
            objectArray = stringTokenizer.nextToken();
            if (string.indexOf((String)objectArray) <= -1) continue;
            debug.error("AMUserPasswordValidationPlugin.validateUserID() : Detected invalid chars ...");
            debug.error("AMUserPasswordValidationPlugin.validateUserID() : User Name validation Failed:" + (String)objectArray);
            stringBuffer.append((String)objectArray).append(" ");
        }
        objectArray = new Object[]{string, stringBuffer.toString()};
        if (stringBuffer.length() != 0) {
            throw new AMException(AMSDKBundle.getString((String)"1002", (Object[])objectArray), "1002", objectArray);
        }
    }

    private String getOrgUserInvalidChars(String string, SSOToken sSOToken) {
        try {
            ServiceConfig serviceConfig = AMServiceUtils.getOrgConfig((SSOToken)sSOToken, (String)string, (String)"iPlanetAMAdminConsoleService");
            if (serviceConfig != null) {
                Map map = serviceConfig.getAttributes();
                Set set = (Set)map.get("iplanet-am-admin-console-invalid-chars");
                return set == null || set.isEmpty() ? null : (String)set.iterator().next();
            }
            return this.getGlobalUserInvalidChars(sSOToken);
        }
        catch (Exception exception) {
            return this.getGlobalUserInvalidChars(sSOToken);
        }
    }

    private String getGlobalUserInvalidChars(SSOToken sSOToken) {
        block4: {
            if (debug.messageEnabled()) {
                debug.message("AMUserPasswordValidationPlugin.getGlobalUserInvalidChars(): Organization config for service (iPlanetAMAdminConsoleService,iplanet-am-admin-console-invalid-chars) not found. Obtaining default service config values ..");
            }
            try {
                Map map = AMServiceUtils.getServiceConfig((SSOToken)sSOToken, (String)"iPlanetAMAdminConsoleService", (SchemaType)SchemaType.ORGANIZATION);
                if (map != null) {
                    Set set = (Set)map.get("iplanet-am-admin-console-invalid-chars");
                    return set == null || set.isEmpty() ? null : (String)set.iterator().next();
                }
            }
            catch (Exception exception) {
                if (!debug.warningEnabled()) break block4;
                debug.warning("AMUserPasswordValidationPlugin.getGlobalUserInvalidChars(): Unable to get UserID invalid characters", exception);
            }
        }
        return null;
    }
}

