/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.share;

import com.iplanet.am.util.XMLUtils;
import com.iplanet.dpro.session.share.SessionRequestParser;
import com.iplanet.services.util.Base64;
import java.io.UnsupportedEncodingException;

public class SessionRequest {
    private static final String sccsID = "$Id: SessionRequest.java,v 1.15 2005/06/24 16:54:58 vs125812 Exp $ $Date: 2005/06/24 16:54:58 $  Sun Microsystems, Inc.";
    public static final int GetSession = 0;
    public static final int GetValidSessions = 1;
    public static final int DestroySession = 2;
    public static final int Logout = 3;
    public static final int AddSessionListener = 4;
    public static final int AddSessionListenerOnAllSessions = 5;
    public static final int SetProperty = 6;
    public static final int GetSessionCount = 7;
    static final String QUOTE = "\"";
    static final String NL = "\n";
    static final String AMPERSAND = "&amp;";
    static final String LESSTHAN = "&lt;";
    static final String GREATERTHAN = "&gt;";
    static final String APOSTROPHE = "&apos;";
    static final String QUOTATION = "&quot;";
    private String requestVersion = "1.0";
    private String requestID = null;
    private boolean resetFlag;
    private int methodID;
    private String sessionID = null;
    private String requester = null;
    private String destroySessionID = null;
    private String notificationURL = null;
    private String propertyName = null;
    private String propertyValue = null;
    private String pattern = null;
    private String uuid = null;
    private static int requestCount = 0;

    public SessionRequest(int n, String string, boolean bl) {
        this.methodID = n;
        this.sessionID = string;
        this.resetFlag = bl;
        this.requestID = new Integer(requestCount++).toString();
    }

    SessionRequest() {
    }

    public static SessionRequest parseXML(String string) {
        SessionRequestParser sessionRequestParser = new SessionRequestParser(string);
        return sessionRequestParser.parseXML();
    }

    void setRequestVersion(String string) {
        this.requestVersion = string;
    }

    public String getRequestVersion() {
        return this.requestVersion;
    }

    void setRequestID(String string) {
        this.requestID = string;
    }

    public String getRequestID() {
        return this.requestID;
    }

    void setMethodID(int n) {
        this.methodID = n;
    }

    public int getMethodID() {
        return this.methodID;
    }

    void setSessionID(String string) {
        this.sessionID = string;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setRequester(String string) {
        this.requester = string;
    }

    public String getRequester() {
        return this.requester;
    }

    void setResetFlag(boolean bl) {
        this.resetFlag = bl;
    }

    public boolean getResetFlag() {
        return this.resetFlag;
    }

    public void setDestroySessionID(String string) {
        this.destroySessionID = string;
    }

    public String getDestroySessionID() {
        return this.destroySessionID;
    }

    public void setNotificationURL(String string) {
        this.notificationURL = string;
    }

    public String getNotificationURL() {
        return this.notificationURL;
    }

    public void setPropertyName(String string) {
        this.propertyName = string;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyValue(String string) {
        this.propertyValue = string;
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    public void setPattern(String string) {
        String string2 = string;
        if (string == null) {
            this.pattern = null;
            return;
        }
        string2 = this.replaceIllegalChar(string2, '&', AMPERSAND);
        string2 = this.replaceIllegalChar(string2, '\'', APOSTROPHE);
        string2 = this.replaceIllegalChar(string2, '\"', QUOTATION);
        string2 = this.replaceIllegalChar(string2, '<', LESSTHAN);
        this.pattern = string2 = this.replaceIllegalChar(string2, '>', GREATERTHAN);
    }

    public String getPattern() {
        String string = this.pattern;
        if (string == null) {
            return null;
        }
        string = this.replaceEntityRef(string, AMPERSAND, '&');
        string = this.replaceEntityRef(string, APOSTROPHE, '\'');
        string = this.replaceEntityRef(string, QUOTATION, '\"');
        string = this.replaceEntityRef(string, LESSTHAN, '<');
        string = this.replaceEntityRef(string, GREATERTHAN, '>');
        return string;
    }

    public void setUUID(String string) {
        this.uuid = string;
    }

    public String getUUID() {
        return this.uuid;
    }

    private String replaceIllegalChar(String string, char c, String string2) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(string.length() * 4);
        while (string != null && (n = string.indexOf(c)) != -1) {
            stringBuffer.append(string.substring(0, n));
            stringBuffer.append(string2);
            string = string.substring(n + 1);
        }
        if (string != null && string.length() > 0) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private String replaceEntityRef(String string, String string2, char c) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        while ((n = string.indexOf(string2)) != -1) {
            stringBuffer.append(string.substring(0, n));
            stringBuffer.append(c);
            string = string.substring(n + string2.length());
        }
        if (string != null && string.length() > 0) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String toXMLString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<SessionRequest vers=\"" + this.requestVersion + QUOTE + " reqid=" + QUOTE + this.requestID + QUOTE);
        if (this.requester != null) {
            try {
                String string = Base64.encode(this.requester.getBytes("UTF8"));
                stringBuffer.append(" requester=\"" + string + QUOTE);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalArgumentException(unsupportedEncodingException.getMessage());
            }
        }
        stringBuffer.append(">\n");
        switch (this.methodID) {
            case 0: {
                stringBuffer.append("<GetSession reset=");
                if (this.resetFlag) {
                    stringBuffer.append("\"true\">\n");
                } else {
                    stringBuffer.append("\"false\">\n");
                }
                stringBuffer.append("<SessionID>" + this.sessionID + "</SessionID>" + NL);
                stringBuffer.append("</GetSession>\n");
                break;
            }
            case 1: {
                stringBuffer.append("<GetValidSessions>\n");
                stringBuffer.append("<SessionID>" + this.sessionID + "</SessionID>" + NL);
                if (this.pattern != null) {
                    stringBuffer.append("<Pattern>" + this.pattern + "</Pattern>" + NL);
                }
                stringBuffer.append("</GetValidSessions>\n");
                break;
            }
            case 2: {
                if (this.destroySessionID == null) {
                    return null;
                }
                stringBuffer.append("<DestroySession>\n");
                stringBuffer.append("<SessionID>" + this.sessionID + "</SessionID>" + NL);
                stringBuffer.append("<DestroySessionID>" + this.destroySessionID + "</DestroySessionID>" + NL);
                stringBuffer.append("</DestroySession>\n");
                break;
            }
            case 3: {
                stringBuffer.append("<Logout>\n");
                stringBuffer.append("<SessionID>" + this.sessionID + "</SessionID>" + NL);
                stringBuffer.append("</Logout>\n");
                break;
            }
            case 4: {
                if (this.notificationURL == null) {
                    return null;
                }
                stringBuffer.append("<AddSessionListener>\n");
                stringBuffer.append("<SessionID>" + this.sessionID + "</SessionID>" + NL);
                stringBuffer.append("<URL>" + this.notificationURL + "</URL>" + NL);
                stringBuffer.append("</AddSessionListener>\n");
                break;
            }
            case 5: {
                if (this.notificationURL == null) {
                    return null;
                }
                stringBuffer.append("<AddSessionListenerOnAllSessions>\n");
                stringBuffer.append("<SessionID>" + this.sessionID + "</SessionID>" + NL);
                stringBuffer.append("<URL>" + this.notificationURL + "</URL>" + NL);
                stringBuffer.append("</AddSessionListenerOnAllSessions>\n");
                break;
            }
            case 6: {
                if (this.propertyName == null || this.propertyValue == null) {
                    return null;
                }
                stringBuffer.append("<SetProperty>\n");
                stringBuffer.append("<SessionID>" + this.sessionID + "</SessionID>" + NL);
                stringBuffer.append("<Property name=").append(QUOTE).append(XMLUtils.escapeSpecialCharacters(this.propertyName)).append(QUOTE).append(" value=").append(QUOTE).append(XMLUtils.escapeSpecialCharacters(this.propertyValue)).append(QUOTE).append(">").append("</Property>\n");
                stringBuffer.append("</SetProperty>\n");
                break;
            }
            case 7: {
                stringBuffer.append("<GetSessionCount>").append(NL);
                stringBuffer.append("<SessionID>").append(this.sessionID).append("</SessionID>").append(NL);
                stringBuffer.append("<UUID>").append(this.uuid).append("</UUID>").append(NL);
                stringBuffer.append("</GetSessionCount>").append(NL);
                break;
            }
            default: {
                return null;
            }
        }
        stringBuffer.append("</SessionRequest>");
        return stringBuffer.toString();
    }
}

