/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.service;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.AMURLEncDec;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.iplanet.am.util.SecureRandomManager;
import com.iplanet.am.util.Stats;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.ThreadPool;
import com.iplanet.am.util.ThreadPoolException;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.SessionNotificationHandler;
import com.iplanet.dpro.session.SessionTimedOutException;
import com.iplanet.dpro.session.TokenRestriction;
import com.iplanet.dpro.session.TokenRestrictionFactory;
import com.iplanet.dpro.session.service.AMSessionRepository;
import com.iplanet.dpro.session.service.ClusterStateService;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.dpro.session.service.PermutationGenerator;
import com.iplanet.dpro.session.service.SessionConfigListener;
import com.iplanet.dpro.session.service.SessionCount;
import com.iplanet.dpro.session.service.SessionMaxStats;
import com.iplanet.dpro.session.service.SessionMonitor;
import com.iplanet.dpro.session.service.SessionRepository;
import com.iplanet.dpro.session.share.SessionBundle;
import com.iplanet.dpro.session.share.SessionInfo;
import com.iplanet.dpro.session.share.SessionNotification;
import com.iplanet.security.x509.X500Name;
import com.iplanet.services.comm.server.PLLServer;
import com.iplanet.services.comm.share.Notification;
import com.iplanet.services.comm.share.NotificationSet;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.services.util.Base64;
import com.iplanet.services.util.Crypt;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.common.MapFactory;
import com.sun.identity.log.Logger;
import com.sun.identity.log.messageid.LogMessageProvider;
import com.sun.identity.log.messageid.MessageProviderFactory;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.identity.security.DecodeAction;
import com.sun.identity.security.EncodeAction;
import com.sun.identity.session.util.RestrictedTokenContext;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.Principal;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.servlet.http.HttpSession;

public class SessionService {
    private static final String sccsID = "@(#)SessionService.java       1.26  00/04/06 04/06/00  Sun Microsystems, Inc.";
    private static String LOG_PROVIDER;
    private static ThreadPool threadPool;
    static SSOTokenManager ssoManager;
    public static Debug sessionDebug;
    public static int maxSessions;
    private static int numberOfActiveSessions;
    private static String dsameAdminDN;
    private static String dsameAdminPassword;
    public static Stats stats;
    private static SessionMaxStats maxSessionStats;
    private static Logger logger;
    private static Logger errorLogger;
    private static final String amSSOErrorLogFile = "amSSO.error";
    private static LogMessageProvider logProvider;
    private static boolean logStatus;
    public static final String SHANDLE_SCHEME_PREFIX = "shandle:";
    private static final String amSessionService = "iPlanetAMSessionService";
    private static final String httpSessionTrackingCookieName;
    private static final String sunAppServerLBRoutingCookieName;
    private static final String httpSessionPropertyName = "DSAMEInternalSession";
    private static final String httpSessionOwnerListPropertyName = "DSAMEInternalSession.ownerList";
    private static final String amSSOLogFile = "amSSO.access";
    private static boolean isEnableHostLookUp;
    private static final int DEFAULT_POOL_SIZE = 10;
    private static final int DEFAULT_THRESHOLD = 100;
    protected static final String securityCookieName = "DSAMESecurityCookie";
    private static final String webContainer;
    private static boolean isWeblogicFlag;
    private static boolean isSunAppServerFlag;
    protected static final String defaultApplicationMaxCachingTime;
    protected static final long applicationMaxCachingTime;
    private static final String SESSION_CONSTRAINT = "iplanet-am-session-enable-session-constraint";
    private static final String MAX_WAIT_TIME_FOR_CONSTARINT = "iplanet-am-session-constraint-max-wait-time";
    private static final String BYPASS_CONSTRAINT_ON_TOPLEVEL_ADMINS = "iplanet-am-session-enable-session-constraint-bypass-topleveladmin";
    private static final String CONSTARINT_RESULTING_BEHAVIOR = "iplanet-am-session-constraint-resulting-behavior";
    private static final String DESTROY_OLD_SESSION = "DESTROY_OLD_SESSION";
    private static final String DENY_ACCESS = "DENY_ACCESS";
    private static final String SESSION_STORE_USERNAME = "iplanet-am-session-store-username";
    private static final String SESSION_STORE_PASSWORD = "iplanet-am-session-store-password";
    private static final String CLUSTER_SERVER_LIST = "iplanet-am-session-cluster-serverlist";
    private static final String CONNECT_MAX_WAIT_TIME = "iplanet-am-session-store-cpl-max-wait-time";
    private static final String JDBC_DRIVER_CLASS = "iplanet-am-session-JDBC-driver-Impl-classname";
    private static final String JDBC_URL = "iplanet-am-session-jdbc-url";
    private static final String MIN_POOL_SIZE = "iplanet-am-session-min-pool-size";
    private static final String MAX_POOL_SIZE = "iplanet-am-session-max-pool-size";
    static String sessionStoreUserName;
    static String sessionStorePassword;
    static HashMap clusterMemberMap;
    static int connectionMaxWaitTime;
    static String jdbcDriverClass;
    static String jdbcURL;
    static int minPoolSize;
    static int maxPoolSize;
    static int maxWaitTimeForConstraint;
    private static boolean isPropertyNotificationEnabled;
    protected static Set notificationProperties;
    private static SSOToken sessionServiceToken;
    private static SSOToken adminToken;
    private static boolean returnAppSession;
    public static final String SESSION_SERVICE = "session";
    private SecureRandom secureRandom = null;
    private Map sessionTable = null;
    private Map sessionHandleTable = MapFactory.getMap();
    private Map restrictedTokenMap = Collections.synchronizedMap(new HashMap());
    private String sessionServer;
    private String sessionServerPort;
    private String sessionServerProtocol;
    private String sessionServerID;
    private static SessionService sessionService;
    public static String deploymentURI;
    private static boolean isSessionFailoverEnabled;
    private static boolean isSiteEnabled;
    private static boolean isSessionConstraintEnabled;
    private static boolean bypassConstratintForToplevelAdmin;
    private static int constraintResultingBehavior;
    private String thisSessionServer;
    private String thisSessionServerPortAsString;
    private int thisSessionServerPort;
    private String thisSessionServerProtocol;
    private String thisSessionServerID;
    private String thisSessionServerURL;
    private URL thisSessionServiceURL;
    private static boolean useRemoteSaveMethod;
    private static boolean useInternalRequestRouting;
    private InternalSession authSession = null;
    private Vector sessionEventURLs = new Vector();
    private URL sessionServiceID = null;
    private ClusterStateService clusterStateService = null;
    private static AMSessionRepository sessionRepository;
    static /* synthetic */ Class class$com$iplanet$dpro$session$service$SessionService;

    public static SessionService getSessionService() {
        if (WebtopNaming.isServerMode()) {
            Class clazz = class$com$iplanet$dpro$session$service$SessionService == null ? (class$com$iplanet$dpro$session$service$SessionService = SessionService.class$("com.iplanet.dpro.session.service.SessionService")) : class$com$iplanet$dpro$session$service$SessionService;
            synchronized (clazz) {
                if (sessionService == null) {
                    sessionService = new SessionService();
                }
            }
        }
        return sessionService;
    }

    public static String getHttpSessionTrackingCookieName() {
        return httpSessionTrackingCookieName;
    }

    public Session getAuthenticationSession(String string, HttpSession httpSession) {
        try {
            if (this.authSession == null) {
                this.authSession = this.getServiceSession(string, httpSession);
            }
            return this.authSession != null ? Session.getSession(this.authSession.getID()) : null;
        }
        catch (Exception exception) {
            sessionDebug.error("Error creating service session", exception);
            return null;
        }
    }

    public String getRestrictedTokenId(String string, TokenRestriction tokenRestriction) throws SessionException {
        String string2;
        SessionID sessionID = new SessionID(string);
        if (SessionService.getUseInternalRequestRouting() && !this.isLocalServer(string2 = this.getCurrentHostServer(sessionID))) {
            if (!sessionService.checkServerUp(string2)) {
                string2 = this.getCurrentHostServer(sessionID);
            }
            if (!this.isLocalServer(string2)) {
                String string3 = this.getRestrictedTokenIdRemotely(Session.getSessionServiceURL(string2), sessionID, tokenRestriction);
                if (string3 == null) {
                    throw new SessionException(SessionBundle.getString("invalidSessionID") + string);
                }
                return string3;
            }
        }
        return this.doGetRestrictedTokenId(sessionID, tokenRestriction);
    }

    String doGetRestrictedTokenId(SessionID sessionID, TokenRestriction tokenRestriction) throws SessionException {
        InternalSession internalSession = (InternalSession)this.sessionTable.get(sessionID);
        if (internalSession == null && (internalSession = sessionService.recoverSession(sessionID)) == null) {
            throw new SessionException(SessionBundle.getString("invalidSessionID") + sessionID);
        }
        this.checkSession(internalSession, sessionID);
        SessionID sessionID2 = internalSession.getRestrictedTokenForRestriction(tokenRestriction);
        if (sessionID2 == null) {
            sessionID2 = new SessionID(SessionID.makeRelatedSessionID(this.generateEncryptedID(), internalSession.getID()));
            internalSession.addRestrictedToken(sessionID2, tokenRestriction);
            this.restrictedTokenMap.put(sessionID2, internalSession.getID());
        }
        return sessionID2.toString();
    }

    private InternalSession getServiceSession(String string, HttpSession httpSession) {
        try {
            InternalSession internalSession = null;
            internalSession = this.newInternalSession(string, httpSession, false);
            internalSession.setType(1);
            String string2 = (String)AccessController.doPrivileged(new AdminDNAction());
            internalSession.setClientID(string2);
            internalSession.setClientDomain(string);
            internalSession.setExpire(false);
            internalSession.setState(1);
            SessionService.incrementActiveSessions();
            return internalSession;
        }
        catch (Exception exception) {
            sessionDebug.error("Error creating service session", exception);
            return null;
        }
    }

    public InternalSession newInternalSession(String string, HttpSession httpSession) {
        try {
            return this.newInternalSession(string, httpSession, true);
        }
        catch (SessionException sessionException) {
            sessionDebug.error("Error creating new session", sessionException);
            return null;
        }
    }

    private InternalSession newInternalSession(String string, HttpSession httpSession, boolean bl) throws SessionException {
        if (isSessionFailoverEnabled && !SessionService.getUseInternalRequestRouting() && httpSession == null && bl) {
            return this.createSession(string);
        }
        InternalSession internalSession = null;
        SessionID sessionID = null;
        sessionID = this.generateSessionId(string, httpSession);
        String string2 = SHANDLE_SCHEME_PREFIX + SessionID.makeRelatedSessionID(this.generateEncryptedID(), sessionID);
        internalSession = new InternalSession(sessionID);
        internalSession.setSessionHandle(string2);
        internalSession.setHttpSession(httpSession);
        this.sessionTable.put(sessionID, internalSession);
        this.sessionHandleTable.put(string2, internalSession);
        internalSession.setCreationTime();
        internalSession.setLatestAccessTime();
        String string3 = Long.toHexString(this.secureRandom.nextLong()) + (isSiteEnabled ? this.thisSessionServerID : this.sessionServerID);
        internalSession.putProperty("AMCtxId", string3);
        return internalSession;
    }

    private String generateEncryptedID() {
        String string = Long.toHexString(this.secureRandom.nextLong());
        return (String)AccessController.doPrivileged(new EncodeAction(string + "@" + this.sessionServerID, Crypt.getHardcodedKeyEncryptor()));
    }

    private SessionID generateSessionId(String string, HttpSession httpSession) throws SessionException {
        HashMap<String, String> hashMap;
        String string2;
        String string3;
        ExtendedSessionID extendedSessionID;
        String string4 = null;
        do {
            string2 = this.generateEncryptedID();
            hashMap = new HashMap<String, String>();
            hashMap.put("SI", this.sessionServerID);
            if (!isSiteEnabled) continue;
            hashMap.put("S1", this.thisSessionServerID);
            if (!isSessionFailoverEnabled) continue;
            hashMap.put("SK", String.valueOf(this.secureRandom.nextInt()));
        } while (this.sessionTable.get(extendedSessionID = new ExtendedSessionID(string3 = SessionID.makeSessionID(string2, hashMap, string4), isSiteEnabled ? this.thisSessionServerID : this.sessionServerID, string)) != null || this.sessionHandleTable.get(extendedSessionID) != null);
        return extendedSessionID;
    }

    private static String extractHttpSessionId(HttpSession httpSession) {
        int n;
        String string = httpSession.getId();
        if (isWeblogicFlag && (n = string.lastIndexOf(33)) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    InternalSession removeInternalSession(SessionID sessionID) {
        boolean bl = true;
        if (sessionID == null) {
            return null;
        }
        InternalSession internalSession = (InternalSession)this.sessionTable.remove(sessionID);
        if (internalSession != null) {
            this.removeSessionHandle(internalSession);
            this.removeRestrictedTokens(internalSession);
            bl = internalSession.getIsISstored();
        }
        if (internalSession != null && internalSession.getState() == 1) {
            SessionService.decrementActiveSessions();
            SessionCount.decrementSessionCount(internalSession);
        }
        if (this.isSessionFailoverEnabled() && bl) {
            if (SessionService.getUseInternalRequestRouting()) {
                try {
                    this.getRepository().delete(sessionID);
                }
                catch (Exception exception) {
                    sessionDebug.error("SessionService : failed deleting session ", exception);
                }
            } else {
                this.invalidateHttpSession(sessionID);
            }
        }
        return internalSession;
    }

    void deleteFromRepository(SessionID sessionID) {
        if (this.isSessionFailoverEnabled()) {
            try {
                this.getRepository().delete(sessionID);
            }
            catch (Exception exception) {
                sessionDebug.error("SessionService : failed deleting session ", exception);
            }
        }
    }

    private void removeRestrictedTokens(InternalSession internalSession) {
        if (internalSession == null) {
            return;
        }
        Object[] objectArray = internalSession.getRestrictedTokens();
        int n = 0;
        while (n < objectArray.length) {
            this.restrictedTokenMap.remove(objectArray[n]);
            ++n;
        }
    }

    private void removeSessionHandle(InternalSession internalSession) {
        if (internalSession == null) {
            return;
        }
        String string = internalSession.getSessionHandle();
        if (string != null) {
            this.sessionHandleTable.remove(string);
        }
    }

    public boolean isSessionFailoverEnabled() {
        return isSessionFailoverEnabled;
    }

    public boolean isSessionPresent(SessionID sessionID) {
        return this.sessionTable.get(sessionID) != null || this.restrictedTokenMap.get(sessionID) != null;
    }

    public boolean checkSessionLocal(SessionID sessionID) throws SessionException {
        if (this.isSessionPresent(sessionID)) {
            return true;
        }
        if (this.isSessionFailoverEnabled()) {
            String string = this.getCurrentHostServer(sessionID);
            if (this.isLocalServer(string)) {
                if (this.recoverSession(sessionID) == null) {
                    throw new SessionException(SessionBundle.getString("sessionNotObtained"));
                }
                return true;
            }
        } else {
            return this.isLocalSessionService(Session.getSessionServiceURL(sessionID));
        }
        return false;
    }

    public boolean isLocalSessionService(URL uRL) {
        URL uRL2 = isSiteEnabled ? this.thisSessionServiceURL : this.sessionServiceID;
        return uRL2 != null && uRL2.getProtocol().equalsIgnoreCase(uRL.getProtocol()) && uRL2.getHost().equalsIgnoreCase(uRL.getHost()) && uRL2.getPort() == uRL.getPort();
    }

    public boolean isLocalServer(String string) {
        if (isSiteEnabled) {
            return this.thisSessionServerID.equals(string);
        }
        return this.sessionServerID.equals(string);
    }

    public boolean isLocalSite(SessionID sessionID) {
        String string = sessionID.getSessionServerID();
        return this.sessionServerID.equals(string);
    }

    public String getLocalServerID() {
        if (isSiteEnabled) {
            return this.thisSessionServerID;
        }
        return this.sessionServerID;
    }

    public InternalSession getInternalSession(SessionID sessionID) {
        if (sessionID == null) {
            return null;
        }
        if (sessionID.toString().startsWith(SHANDLE_SCHEME_PREFIX)) {
            return null;
        }
        InternalSession internalSession = (InternalSession)this.sessionTable.get(sessionID);
        return internalSession;
    }

    public InternalSession getInternalSessionByHandle(String string) {
        return (InternalSession)this.sessionHandleTable.get(string);
    }

    private InternalSession resolveToken(SessionID sessionID) throws SessionException {
        InternalSession internalSession = (InternalSession)this.sessionTable.get(sessionID);
        if (internalSession == null) {
            internalSession = this.resolveRestrictedToken(sessionID, true);
        }
        if (internalSession == null) {
            throw new SessionException(SessionBundle.getString("invalidSessionID") + sessionID.toString());
        }
        return internalSession;
    }

    private InternalSession resolveRestrictedToken(SessionID sessionID, boolean bl) throws SessionException {
        SessionID sessionID2 = (SessionID)this.restrictedTokenMap.get(sessionID);
        if (sessionID2 == null) {
            return null;
        }
        InternalSession internalSession = (InternalSession)this.sessionTable.get(sessionID2);
        if (internalSession == null) {
            this.restrictedTokenMap.remove(sessionID);
            return null;
        }
        if (bl) {
            try {
                TokenRestriction tokenRestriction = internalSession.getRestrictionForToken(sessionID);
                if (tokenRestriction != null && !tokenRestriction.isSatisfied(RestrictedTokenContext.getCurrent())) {
                    throw new SessionException(SessionBundle.rbName, "restrictionViolation", null);
                }
            }
            catch (SessionException sessionException) {
                throw sessionException;
            }
            catch (Exception exception) {
                throw new SessionException(exception);
            }
        }
        return internalSession;
    }

    private Vector getValidInternalSessions() {
        Vector<InternalSession> vector = new Vector<InternalSession>();
        Map map = this.sessionTable;
        synchronized (map) {
            Enumeration enumeration = MapFactory.elements(this.sessionTable);
            while (enumeration.hasMoreElements()) {
                InternalSession internalSession = (InternalSession)enumeration.nextElement();
                if (internalSession.getState() != 1 || !internalSession.willExpire() && !returnAppSession) continue;
                vector.addElement(internalSession);
            }
        }
        return vector;
    }

    private Vector getValidInternalSessions(String string, int[] nArray) throws SessionException {
        Vector<InternalSession> vector = new Vector<InternalSession>();
        if (string == null) {
            string = "*";
        }
        try {
            long l = System.currentTimeMillis();
            string = string.toLowerCase();
            Vector vector2 = this.getValidInternalSessions();
            Enumeration enumeration = vector2.elements();
            String string2 = AMStoreConnection.getUserNamingAttribute();
            boolean bl = string.equals("*");
            while (enumeration.hasMoreElements()) {
                InternalSession internalSession = (InternalSession)enumeration.nextElement();
                if (!bl) {
                    String string3;
                    String string4 = string3 = internalSession.willExpire() ? new X500Name(internalSession.getClientID()).getAttributeValue(string2) : internalSession.getClientID();
                    if (string3 == null || !SessionService.matchFilter(string3 = string3.toLowerCase(), string)) continue;
                }
                if (vector.size() == SessionConfigListener.getMaxsize()) {
                    nArray[0] = 1;
                } else {
                    vector.addElement(internalSession);
                    if (System.currentTimeMillis() - l < SessionConfigListener.getTimeout()) continue;
                    nArray[0] = 2;
                }
                break;
            }
        }
        catch (Exception exception) {
            sessionDebug.error("SessionService : Unable to get Session Information ", exception);
            throw new SessionException(exception);
        }
        return vector;
    }

    public void destroyInternalSession(SessionID sessionID) {
        InternalSession internalSession = this.removeInternalSession(sessionID);
        internalSession.setIsISStored(false);
        if (internalSession != null && internalSession.getState() != 0) {
            this.logEvent(internalSession, 5);
            internalSession.setState(3);
            this.sendEvent(internalSession, 5);
        }
    }

    public void logoutInternalSession(SessionID sessionID) {
        InternalSession internalSession = this.removeInternalSession(sessionID);
        internalSession.setIsISStored(false);
        if (internalSession != null && internalSession.getState() != 0) {
            this.logEvent(internalSession, 3);
            internalSession.setState(3);
            this.sendEvent(internalSession, 3);
        }
    }

    public static synchronized void decrementActiveSessions() {
        --numberOfActiveSessions;
    }

    public static synchronized void incrementActiveSessions() {
        ++numberOfActiveSessions;
    }

    public static synchronized int getActiveSessions() {
        return numberOfActiveSessions;
    }

    private void addInternalSessionListener(InternalSession internalSession, String string, SessionID sessionID) {
        if (internalSession != null) {
            if (!sessionID.equals(internalSession.getID()) && internalSession.getRestrictionForToken(sessionID) == null) {
                throw new IllegalArgumentException("Session id mismatch");
            }
            Map map = internalSession.getSessionEventURLs();
            map.put(string, sessionID);
            internalSession.updateForFailover();
        }
    }

    private void addListenerOnAllInternalSessions(String string) {
        if (!this.sessionEventURLs.contains(string)) {
            this.sessionEventURLs.addElement(string);
        }
    }

    public SessionInfo getSessionInfo(SessionID sessionID, boolean bl) throws SessionException {
        InternalSession internalSession = this.resolveToken(sessionID);
        this.checkSession(internalSession, sessionID);
        SessionInfo sessionInfo = this.makeSessionInfo(internalSession, sessionID);
        if (bl) {
            internalSession.setLatestAccessTime();
        }
        return sessionInfo;
    }

    private SessionInfo makeSessionInfo(InternalSession internalSession, SessionID sessionID) throws SessionException {
        SessionInfo sessionInfo = internalSession.toSessionInfo();
        TokenRestriction tokenRestriction = internalSession.getRestrictionForToken(sessionID);
        if (tokenRestriction != null) {
            try {
                sessionInfo.properties.put("TokenRestriction", TokenRestrictionFactory.marshal(tokenRestriction));
            }
            catch (Exception exception) {
                throw new SessionException(exception);
            }
        } else if (!sessionID.equals(internalSession.getID())) {
            throw new IllegalArgumentException("Session id mismatch");
        }
        sessionInfo.sid = sessionID.toString();
        return sessionInfo;
    }

    private void checkSession(InternalSession internalSession, SessionID sessionID) throws SessionException {
        if (!sessionID.equals(internalSession.getID()) && internalSession.getRestrictionForToken(sessionID) == null) {
            throw new IllegalArgumentException("Session id mismatch");
        }
        if (internalSession.getState() != 1) {
            if (internalSession.getTimeLeftBeforePurge() > 0L) {
                throw new SessionTimedOutException(SessionBundle.getString("sessionTimedOut") + " " + sessionID);
            }
            throw new SessionException(SessionBundle.getString("invalidSessionState") + " " + sessionID);
        }
    }

    public Vector getValidSessions(Session session) throws SessionException {
        int[] nArray = new int[]{0};
        return this.getValidSessions(session, null, nArray);
    }

    public Vector getValidSessions(Session session, String string, int[] nArray) throws SessionException {
        if (session.getState(false) != 1) {
            throw new SessionException(SessionBundle.getString("invalidSessionState") + session.getID().toString());
        }
        try {
            AMUser aMUser = this.getUser(session);
            Set set = aMUser.getAttribute("iplanet-am-session-get-valid-sessions");
            Vector vector = sessionService.getValidInternalSessions(string, nArray);
            int n = vector.size();
            Vector<SessionInfo> vector2 = new Vector<SessionInfo>(n);
            boolean bl = this.hasTopLevelAdminRole(session);
            int n2 = 0;
            while (n2 < n) {
                InternalSession internalSession = (InternalSession)vector.elementAt(n2);
                if (bl || set.contains(internalSession.getClientDomain())) {
                    SessionInfo sessionInfo = internalSession.toSessionInfo();
                    sessionInfo.sid = internalSession.getSessionHandle();
                    vector2.add(sessionInfo);
                }
                ++n2;
            }
            return vector2;
        }
        catch (Exception exception) {
            throw new SessionException(exception);
        }
    }

    public void destroySession(Session session, SessionID sessionID) throws SessionException {
        if (sessionID == null) {
            return;
        }
        if (session.getState(false) != 1) {
            throw new SessionException(SessionBundle.getString("invalidSessionState") + sessionID.toString());
        }
        InternalSession internalSession = sessionService.getInternalSession(sessionID);
        if (internalSession == null) {
            internalSession = sessionService.getInternalSessionByHandle(sessionID.toString());
        }
        if (internalSession != null) {
            sessionID = internalSession.getID();
            try {
                if (session.getID().equals(sessionID) || this.hasTopLevelAdminRole(session)) {
                    sessionService.destroyInternalSession(sessionID);
                    return;
                }
                AMUser aMUser = this.getUser(session);
                Set set = aMUser.getAttribute("iplanet-am-session-destroy-sessions");
                if (!set.contains(session.getClientDomain())) {
                    throw new SessionException(SessionBundle.rbName, "noPrivilege", null);
                }
                sessionService.destroyInternalSession(sessionID);
            }
            catch (Exception exception) {
                throw new SessionException(exception);
            }
        }
    }

    public void logout(SessionID sessionID) throws SessionException {
        InternalSession internalSession = this.locateSession(sessionID);
        this.logoutInternalSession(sessionID);
    }

    public void addSessionListener(SessionID sessionID, String string) throws SessionException {
        InternalSession internalSession = this.resolveToken(sessionID);
        if (internalSession.getState() == 0) {
            throw new SessionException(SessionBundle.getString("invalidSessionState") + sessionID.toString());
        }
        this.addInternalSessionListener(internalSession, string, sessionID);
    }

    public void addSessionListenerOnAllSessions(Session session, String string) throws SessionException {
        if (session.getState(false) != 1) {
            throw new SessionException(SessionBundle.getString("invalidSessionState") + session.getID().toString());
        }
        if (session.getClientID().equals(dsameAdminDN)) {
            this.addListenerOnAllInternalSessions(string);
            return;
        }
        try {
            AMUser aMUser = this.getUser(session);
            String string2 = aMUser.getStringAttribute("iplanet-am-session-add-session-listener-on-all-sessions");
            if (string2.equals("false")) {
                throw new SessionException(SessionBundle.rbName, "noPrivilege", null);
            }
            this.addListenerOnAllInternalSessions(string);
        }
        catch (Exception exception) {
            throw new SessionException(exception);
        }
    }

    public void setProperty(SessionID sessionID, String string, String string2) throws SessionException {
        this.locateSession(sessionID).putProperty(string, string2);
    }

    protected InternalSession locateSession(SessionID sessionID) throws SessionException {
        InternalSession internalSession = this.getInternalSession(sessionID);
        if (internalSession == null) {
            throw new SessionException(SessionBundle.getString("invalidSessionID") + sessionID.toString());
        }
        return internalSession;
    }

    public void setExternalProperty(SessionID sessionID, String string, String string2) throws SessionException {
        this.locateSession(sessionID).putExternalProperty(string, string2);
    }

    public void sendEvent(InternalSession internalSession, int n) {
        sessionDebug.message("Running sendEvent, type = " + n);
        try {
            if (this.sessionEventURLs.size() != 0 || internalSession.hasEventURLs()) {
                threadPool.run(new SessionNotificationSender(this, internalSession, n));
            }
        }
        catch (ThreadPoolException threadPoolException) {
            sessionDebug.error("Sending Notification Error: ", threadPoolException);
        }
    }

    public void logEvent(InternalSession internalSession, int n) {
        switch (n) {
            case 0: {
                this.logIt(internalSession, "SESSION_CREATED");
                break;
            }
            case 1: {
                this.logIt(internalSession, "SESSION_IDLE_TIMED_OUT");
                break;
            }
            case 2: {
                this.logIt(internalSession, "SESSION_MAX_TIMEOUT");
                break;
            }
            case 3: {
                this.logIt(internalSession, "SESSION_LOGOUT");
                break;
            }
            case 4: {
                this.logIt(internalSession, "SESSION_REACTIVATION");
                break;
            }
            case 5: {
                this.logIt(internalSession, "SESSION_DESTROYED");
                break;
            }
            case 6: {
                this.logIt(internalSession, "SESSION_PROPERTY_CHANGED");
                break;
            }
            case 7: {
                this.logIt(internalSession, "SESSION_QUOTA_EXHAUSTED");
                break;
            }
            default: {
                this.logIt(internalSession, "SESSION_UNKNOWN_EVENT");
            }
        }
    }

    private LogMessageProvider getLogMessageProvider() throws Exception {
        if (logProvider == null) {
            logProvider = MessageProviderFactory.getProvider((String)LOG_PROVIDER);
        }
        return logProvider;
    }

    public void logIt(InternalSession internalSession, String string) {
        if (!logStatus) {
            return;
        }
        try {
            String[] stringArray;
            String string2 = internalSession.getID().toString();
            String string3 = internalSession.getClientID();
            String string4 = null;
            string4 = string3 == null || string3.length() < 1 ? "N/A" : ((stringArray = new StringTokenizer(string3, ",")).hasMoreTokens() ? stringArray.nextToken() : string3);
            stringArray = new String[]{string4};
            com.sun.identity.log.LogRecord logRecord = this.getLogMessageProvider().createLogRecord(string, stringArray, null);
            logRecord.addLogInfo("LoginIDSid", (Object)string2);
            String string5 = internalSession.getProperty("AMCtxId");
            String string6 = internalSession.getClientDomain();
            String string7 = internalSession.getProperty("Host");
            String string8 = internalSession.getProperty("HostName");
            logRecord.addLogInfo("ContextID", (Object)string5);
            logRecord.addLogInfo("LoginID", (Object)string3);
            logRecord.addLogInfo("LogLevel", (Object)logRecord.getLevel().toString());
            logRecord.addLogInfo("Domain", (Object)string6);
            logRecord.addLogInfo("IPAddr", (Object)string7);
            logRecord.addLogInfo("HostName", (Object)string8);
            this.getLogger().log((LogRecord)logRecord, (Object)this.getSessionServiceToken());
        }
        catch (Exception exception) {
            sessionDebug.error("SessionService.logIt(): Cannot write to the session log file: ", exception);
        }
    }

    public void logSystemMessage(String string, Level level) {
        if (!logStatus) {
            return;
        }
        if (errorLogger == null) {
            errorLogger = (Logger)Logger.getLogger((String)amSSOErrorLogFile);
        }
        try {
            String[] stringArray = new String[]{string};
            com.sun.identity.log.LogRecord logRecord = this.getLogMessageProvider().createLogRecord(string, stringArray, null);
            SSOToken sSOToken = this.getSessionServiceToken();
            logRecord.addLogInfo("LoginIDSid", (Object)sSOToken.getTokenID().toString());
            logRecord.addLogInfo("LoginID", (Object)sSOToken.getPrincipal().getName());
            errorLogger.log((LogRecord)logRecord, (Object)sSOToken);
        }
        catch (Exception exception) {
            sessionDebug.error("SessionService.logSystemMessage(): Cannot write to the session error log file: ", exception);
        }
    }

    private SSOTokenManager getSSOTokenManager() throws SSOException {
        if (ssoManager == null) {
            ssoManager = SSOTokenManager.getInstance();
        }
        return ssoManager;
    }

    SSOToken getSessionServiceToken() throws Exception {
        if (sessionServiceToken == null) {
            InternalSession internalSession = this.getServiceSession("SessionService-" + this.sessionServer, null);
            this.setProperty(internalSession.getID(), "Principal", internalSession.getClientID());
            sessionServiceToken = this.getSSOTokenManager().createSSOToken(internalSession.getID().toString());
        }
        return sessionServiceToken;
    }

    private SSOToken getAdminToken() throws SSOException {
        if (adminToken == null) {
            adminToken = this.getSSOTokenManager().createSSOToken((Principal)new AuthPrincipal(dsameAdminDN), dsameAdminPassword);
            return adminToken;
        }
        return adminToken;
    }

    private Logger getLogger() {
        if (logger == null) {
            logger = (Logger)Logger.getLogger((String)amSSOLogFile);
        }
        return logger;
    }

    private SessionService() {
        try {
            dsameAdminDN = (String)AccessController.doPrivileged(new AdminDNAction());
            dsameAdminPassword = (String)AccessController.doPrivileged(new AdminPasswordAction());
            this.sessionServerProtocol = SystemProperties.get("com.iplanet.am.server.protocol");
            this.sessionServer = SystemProperties.get("com.iplanet.am.server.host");
            this.sessionServerPort = SystemProperties.get("com.iplanet.am.server.port");
            this.sessionServerID = WebtopNaming.getServerID(this.sessionServerProtocol, this.sessionServer, this.sessionServerPort);
            isSiteEnabled = WebtopNaming.isSiteEnabled(this.sessionServerProtocol, this.sessionServer, this.sessionServerPort);
            if (isSiteEnabled) {
                this.sessionServerID = WebtopNaming.getSiteID(this.sessionServerProtocol, this.sessionServer, this.sessionServerPort);
                this.sessionServiceID = new URL(WebtopNaming.getServerFromID(this.sessionServerID));
                this.sessionServerProtocol = this.sessionServiceID.getProtocol();
                this.sessionServer = this.sessionServiceID.getHost();
                this.sessionServerPort = Integer.toString(this.sessionServiceID.getPort());
            } else {
                this.sessionServiceID = new URL(WebtopNaming.getServerFromID(this.sessionServerID));
            }
            this.secureRandom = SecureRandomManager.getSecureRandom();
            this.sessionTable = MapFactory.getMap();
            if (stats.isEnabled()) {
                maxSessionStats = new SessionMaxStats(this.sessionTable);
                stats.addStatsListener(maxSessionStats);
            }
            this.postInit();
            if (isSiteEnabled) {
                this.thisSessionServerProtocol = SystemProperties.get("com.iplanet.am.server.protocol");
                this.thisSessionServer = SystemProperties.get("com.iplanet.am.server.host");
                this.thisSessionServerPortAsString = SystemProperties.get("com.iplanet.am.server.port");
                if (this.thisSessionServerProtocol == null || this.thisSessionServerPortAsString == null || this.thisSessionServer == null) {
                    throw new SessionException(SessionBundle.rbName, "propertyMustBeSet", null);
                }
                this.thisSessionServerPort = Integer.parseInt(this.thisSessionServerPortAsString);
                this.thisSessionServerID = WebtopNaming.getServerID(this.thisSessionServerProtocol, this.thisSessionServer, this.thisSessionServerPortAsString);
                this.thisSessionServerURL = this.thisSessionServerProtocol + "://" + this.thisSessionServer + ":" + this.thisSessionServerPortAsString;
                this.thisSessionServiceURL = Session.getSessionServiceURL(this.thisSessionServerProtocol, this.thisSessionServer, this.thisSessionServerPortAsString);
                if (isSessionFailoverEnabled) {
                    int n = 1000;
                    try {
                        n = Integer.parseInt(SystemProperties.get("com.iplanet.am.session.failover.cluster.stateCheck.timeout", String.valueOf(1000)));
                    }
                    catch (Exception exception) {
                        sessionDebug.error("Invalid value for com.iplanet.am.session.failover.cluster.stateCheck.timeout, using default");
                    }
                    long l = 1000L;
                    try {
                        l = Integer.parseInt(SystemProperties.get("com.iplanet.am.session.failover.cluster.stateCheck.period", String.valueOf(1000L)));
                    }
                    catch (Exception exception) {
                        sessionDebug.error("Invalid value for com.iplanet.am.session.failover.cluster.stateCheck.period, using default");
                    }
                    this.clusterStateService = new ClusterStateService(this.thisSessionServerID, n, l, clusterMemberMap);
                    this.getRepository();
                }
            }
            SessionMonitor sessionMonitor = new SessionMonitor(this, this.sessionTable);
            sessionMonitor.setName("amSessionMonitor");
            sessionMonitor.start();
        }
        catch (Exception exception) {
            sessionDebug.error("SessionService.SessionService(): Initialization Failed", exception);
        }
    }

    public String getCurrentHostServer(SessionID sessionID) throws SessionException {
        if (!this.isSessionFailoverEnabled()) {
            return sessionID.getSessionServerID();
        }
        if (SessionService.getUseInternalRequestRouting()) {
            String string = this.locateCurrentHostServer(sessionID);
            if (!this.isLocalServer(string)) {
                this.handleReleaseSession(sessionID);
            }
            return string;
        }
        return sessionID.getSessionServerID();
    }

    private String locateCurrentHostServer(SessionID sessionID) throws SessionException {
        String string = sessionID.getExtension("S1");
        String string2 = sessionID.getSessionServerID();
        if (!string2.equals(this.sessionServerID)) {
            return string2;
        }
        if (this.clusterStateService.isUp(string)) {
            return string;
        }
        int n = this.clusterStateService.getServerSelectionListSize();
        PermutationGenerator permutationGenerator = new PermutationGenerator(sessionID.getExtension("SK").hashCode(), n);
        String string3 = null;
        int n2 = 0;
        while (n2 < n) {
            string3 = this.clusterStateService.getServerSelection(permutationGenerator.itemAt(n2));
            if (this.clusterStateService.isUp(string3)) break;
            ++n2;
        }
        return string3;
    }

    public static boolean getUseInternalRequestRouting() {
        if (isSessionFailoverEnabled) {
            return useInternalRequestRouting;
        }
        return false;
    }

    public static boolean isSessionConstraintEnabled() {
        return isSessionConstraintEnabled;
    }

    public static boolean bypassConstratintForToplevelAdmin() {
        return bypassConstratintForToplevelAdmin;
    }

    public static int getConstraintResultingBehavior() {
        return constraintResultingBehavior;
    }

    protected AMSessionRepository getRepository() {
        if (!SessionService.getUseInternalRequestRouting()) {
            return null;
        }
        if (sessionRepository == null) {
            try {
                sessionRepository = SessionRepository.getInstance();
            }
            catch (Exception exception) {
                sessionDebug.error("Failed to initialize session repository", exception);
            }
        }
        return sessionRepository;
    }

    public boolean checkServerUp(String string) {
        return this.clusterStateService.checkServerUp(string);
    }

    private void postInit() {
        try {
            Object object;
            String string;
            String string2;
            String string3;
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(amSessionService, this.getAdminToken());
            ServiceSchema serviceSchema = serviceSchemaManager.getGlobalSchema();
            Map map = serviceSchema.getAttributeDefaults();
            String string4 = Misc.getMapAttr(map, "iplanet-am-session-property-change-notification", "OFF");
            if (string4.equalsIgnoreCase("ON")) {
                isPropertyNotificationEnabled = true;
                notificationProperties = (Set)map.get("iplanet-am-session-notification-property-list");
            }
            if ((string3 = Misc.getMapAttr(map, SESSION_CONSTRAINT, "OFF")).equalsIgnoreCase("ON")) {
                isSessionConstraintEnabled = true;
            }
            if (sessionDebug.messageEnabled()) {
                sessionDebug.message("isSessionConstraintEnabled=" + isSessionConstraintEnabled);
            }
            if ((string2 = Misc.getMapAttr(map, BYPASS_CONSTRAINT_ON_TOPLEVEL_ADMINS, "NO")).equalsIgnoreCase("YES")) {
                bypassConstratintForToplevelAdmin = true;
            }
            if (sessionDebug.messageEnabled()) {
                sessionDebug.message("bypassConstratintForToplevelAdmin=" + bypassConstratintForToplevelAdmin);
            }
            if ((string = Misc.getMapAttr(map, CONSTARINT_RESULTING_BEHAVIOR, DESTROY_OLD_SESSION)).equalsIgnoreCase(DESTROY_OLD_SESSION)) {
                constraintResultingBehavior = 1;
            } else if (string.equalsIgnoreCase(DENY_ACCESS)) {
                constraintResultingBehavior = 2;
            }
            if (sessionDebug.messageEnabled()) {
                sessionDebug.message("Resulting behavior if session quota exhausted:" + string);
            }
            maxWaitTimeForConstraint = Integer.parseInt(Misc.getMapAttr(map, MAX_WAIT_TIME_FOR_CONSTARINT, "6000"));
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager(amSessionService, this.getAdminToken());
            ServiceConfig serviceConfig = serviceConfigManager.getGlobalConfig(null);
            ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(this.sessionServiceID.toString());
            if (serviceConfig2 != null) {
                isSessionFailoverEnabled = true;
                object = serviceConfig2.getAttributes();
                sessionStoreUserName = Misc.getMapAttr((Map)object, SESSION_STORE_USERNAME, "amsvrusr");
                sessionStorePassword = Misc.getMapAttr((Map)object, SESSION_STORE_PASSWORD, "password");
                Set set = WebtopNaming.getSiteNodes(this.sessionServerID);
                this.initClusterMemberMap(set);
                connectionMaxWaitTime = Integer.parseInt(Misc.getMapAttr((Map)object, CONNECT_MAX_WAIT_TIME, "5000"));
                jdbcDriverClass = Misc.getMapAttr((Map)object, JDBC_DRIVER_CLASS, "");
                jdbcURL = Misc.getMapAttr((Map)object, JDBC_URL, "");
                minPoolSize = Integer.parseInt(Misc.getMapAttr((Map)object, MIN_POOL_SIZE, "8"));
                maxPoolSize = Integer.parseInt(Misc.getMapAttr((Map)object, MAX_POOL_SIZE, "32"));
                if (sessionDebug.messageEnabled()) {
                    sessionDebug.message("UserName=" + sessionStoreUserName + " : " + "clusterServerList=" + this.getClusterServerList() + ": " + "connectionMaxWaitTime=" + connectionMaxWaitTime + " :" + "jdbcDriverClass=" + jdbcDriverClass + " : " + "jdcbURL=" + jdbcURL + " : " + "minPoolSize=" + minPoolSize + " : " + "maxPoolSize=" + maxPoolSize);
                }
            }
            if (sessionDebug.messageEnabled()) {
                sessionDebug.message("Session Failover Enabled = " + isSessionFailoverEnabled);
            }
            object = new SessionConfigListener(serviceSchemaManager);
            serviceSchemaManager.addListener((ServiceListener)object);
            ((SessionConfigListener)object).schemaChanged(amSessionService, null);
        }
        catch (Exception exception) {
            sessionDebug.error("SessionService.postInit():+Unable to get Session Schema Information", exception);
        }
    }

    private void initClusterMemberMap(String string) throws Exception {
        if (string != null && string.length() != 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                String string3 = WebtopNaming.getServerFromID(string2);
                clusterMemberMap.put(string2, string3);
            }
        } else {
            throw new IllegalArgumentException("Fatal misconfiguration error: missing value for com.iplanet.am.session.failover.cluster.serverList");
        }
    }

    private void initClusterMemberMap(Set set) throws Exception {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = WebtopNaming.getServerFromID(string);
            clusterMemberMap.put(string, string2);
        }
    }

    private String getClusterServerList() {
        StringBuffer stringBuffer = new StringBuffer();
        Set set = clusterMemberMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append(string).append(" ");
        }
        return stringBuffer.toString();
    }

    private AMUser getUser(Session session) throws SessionException, SSOException, AMException {
        Object var2_2 = null;
        SSOToken sSOToken = this.getSSOTokenManager().createSSOToken(session.getID().toString());
        AMStoreConnection aMStoreConnection = new AMStoreConnection(sSOToken);
        return aMStoreConnection.getUser(session.getClientID());
    }

    private boolean hasTopLevelAdminRole(Session session) throws SessionException, SSOException, AMException {
        SSOToken sSOToken = this.getSSOTokenManager().createSSOToken(session.getID().toString());
        return this.hasTopLevelAdminRole(sSOToken, session.getClientID());
    }

    protected boolean hasTopLevelAdminRole(String string) {
        boolean bl = false;
        try {
            bl = this.hasTopLevelAdminRole(this.getAdminToken(), string);
        }
        catch (Exception exception) {
            sessionDebug.error("Error occurs when checking whether the login user has the top level admin role.", exception);
        }
        return bl;
    }

    private boolean hasTopLevelAdminRole(SSOToken sSOToken, String string) throws SessionException, SSOException, AMException {
        AMStoreConnection aMStoreConnection = new AMStoreConnection(sSOToken);
        AMUser aMUser = aMStoreConnection.getUser(string);
        AMRole aMRole = null;
        Set set = aMUser.getRoleDNs();
        boolean bl = false;
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext() && !bl) {
                String string2 = (String)iterator.next();
                try {
                    int n = aMStoreConnection.getAMObjectType(string2);
                    if (n != 6 && n != 8 || !aMStoreConnection.isValidEntry(string2)) continue;
                    aMRole = aMStoreConnection.getRole(string2);
                    bl = aMRole.getRoleType() == 1;
                }
                catch (AMException aMException) {
                    if (!sessionDebug.messageEnabled()) continue;
                    sessionDebug.message("SessionService.hasTopLevelAdminRole, role DN=" + string2, aMException);
                }
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InternalSession createSession(String string) {
        InternalSession internalSession;
        DataInputStream dataInputStream;
        block10: {
            InternalSession internalSession2;
            block9: {
                dataInputStream = null;
                try {
                    try {
                        Object object;
                        String string2 = "?op=create";
                        if (string != null) {
                            string2 = string2 + "&domain=" + AMURLEncDec.encode(string);
                        }
                        String string3 = null;
                        URL uRL = null;
                        if (isSunAppServerFlag && !SessionService.getUseInternalRequestRouting()) {
                            object = InetAddress.getByName(this.thisSessionServer);
                            string3 = sunAppServerLBRoutingCookieName + "=" + ((InetAddress)object).getHostAddress() + ":" + this.thisSessionServerPort;
                            if (this.thisSessionServerProtocol.equalsIgnoreCase("https")) {
                                string3 = string3 + "https:";
                            }
                            uRL = new URL(this.sessionServerProtocol, this.sessionServer, Integer.parseInt(this.sessionServerPort), deploymentURI + "/GetHttpSession" + string2);
                        } else {
                            uRL = new URL(this.thisSessionServerProtocol, this.thisSessionServer, this.thisSessionServerPort, deploymentURI + "/GetHttpSession" + string2);
                        }
                        object = this.invokeRemote(uRL, null, string3);
                        dataInputStream = new DataInputStream(((URLConnection)object).getInputStream());
                        if (((HttpURLConnection)object).getResponseCode() != 200) {
                            internalSession2 = null;
                            Object var10_10 = null;
                            break block9;
                        }
                        SessionID sessionID = new SessionID(dataInputStream.readUTF());
                        internalSession = (InternalSession)this.sessionTable.get(sessionID);
                        break block10;
                    }
                    catch (Exception exception) {
                        sessionDebug.error("Failed to retrieve new session", exception);
                        Object var10_12 = null;
                        SessionService.closeStream(dataInputStream);
                        return null;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    SessionService.closeStream(dataInputStream);
                    throw throwable;
                }
            }
            SessionService.closeStream(dataInputStream);
            return internalSession2;
        }
        Object var10_11 = null;
        SessionService.closeStream(dataInputStream);
        return internalSession;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean invalidateHttpSession(SessionID sessionID) {
        boolean bl;
        if (!isSessionFailoverEnabled) return true;
        if (sessionID.getTail() == null) {
            return true;
        }
        DataInputStream dataInputStream = null;
        URL uRL = null;
        try {
            try {
                String string = "?op=invalidate";
                uRL = new URL(this.thisSessionServerProtocol, this.thisSessionServer, this.thisSessionServerPort, deploymentURI + "/GetHttpSession" + string);
                HttpURLConnection httpURLConnection = this.invokeRemote(uRL, sessionID, null);
                dataInputStream = new DataInputStream(httpURLConnection.getInputStream());
                bl = httpURLConnection.getResponseCode() == 200;
                Object var8_10 = null;
            }
            catch (ConnectException connectException) {
                if (sessionDebug.messageEnabled()) {
                    sessionDebug.message("invalidateHttpSesion: failed to connect to  " + uRL);
                }
                boolean bl2 = true;
                Object var8_11 = null;
                SessionService.closeStream(dataInputStream);
                return bl2;
            }
            catch (Exception exception) {
                sessionDebug.error("Failed to invalidate session", exception);
                Object var8_12 = null;
                SessionService.closeStream(dataInputStream);
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            SessionService.closeStream(dataInputStream);
            throw throwable;
        }
        SessionService.closeStream(dataInputStream);
        return bl;
    }

    static void closeStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                sessionDebug.error("Unable to close input", iOException);
            }
        }
    }

    static void closeStream(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                sessionDebug.error("Unable to close output", iOException);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean releaseSession(URL uRL, SessionID sessionID) {
        boolean bl;
        if (sessionDebug.messageEnabled()) {
            sessionDebug.message("Attempting to release InternalSession " + sessionID + " from server instance: " + uRL);
        }
        DataInputStream dataInputStream = null;
        URL uRL2 = null;
        try {
            try {
                String string = "?op=release";
                uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), deploymentURI + "/GetHttpSession" + string);
                HttpURLConnection httpURLConnection = this.invokeRemote(uRL2, sessionID, null);
                dataInputStream = new DataInputStream(httpURLConnection.getInputStream());
                bl = httpURLConnection.getResponseCode() == 200;
                Object var9_11 = null;
            }
            catch (ConnectException connectException) {
                if (sessionDebug.messageEnabled()) {
                    sessionDebug.message("releaseSession: failed to connect to  " + uRL2);
                }
                boolean bl2 = true;
                Object var9_12 = null;
                SessionService.closeStream(dataInputStream);
                return bl2;
            }
            catch (Exception exception) {
                sessionDebug.error("Failed to release session", exception);
                Object var9_13 = null;
                SessionService.closeStream(dataInputStream);
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            SessionService.closeStream(dataInputStream);
            throw throwable;
        }
        SessionService.closeStream(dataInputStream);
        return bl;
    }

    int handleReleaseSession(SessionID sessionID) {
        if (!isSessionFailoverEnabled) {
            return 501;
        }
        Session.markNonLocal(sessionID);
        InternalSession internalSession = (InternalSession)this.sessionTable.remove(sessionID);
        this.removeSessionHandle(internalSession);
        this.removeRestrictedTokens(internalSession);
        if (internalSession == null && sessionDebug.messageEnabled()) {
            sessionDebug.message("releaseSession: session not found  " + sessionID);
        }
        return 200;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    InternalSession recoverSession(SessionID sessionID) {
        if (!isSessionFailoverEnabled) {
            return null;
        }
        if (SessionService.getUseInternalRequestRouting()) {
            InternalSession internalSession2 = null;
            try {
                internalSession2 = this.getRepository().retrieve(sessionID);
                this.updateSessionMaps(internalSession2);
                return internalSession2;
            }
            catch (Exception exception) {
                sessionDebug.error("Failed to retrieve new session", exception);
            }
            return internalSession2;
        }
        if (sessionDebug.messageEnabled()) {
            sessionDebug.message("Recovering InternalSession from HttpSession: " + sessionID);
        }
        DataInputStream dataInputStream = null;
        InternalSession internalSession = null;
        try {
            block9: {
                try {
                    String string = "?op=recover";
                    URL uRL = new URL(this.thisSessionServerProtocol, this.thisSessionServer, this.thisSessionServerPort, deploymentURI + "/GetHttpSession" + string);
                    HttpURLConnection httpURLConnection = this.invokeRemote(uRL, sessionID, null);
                    dataInputStream = new DataInputStream(httpURLConnection.getInputStream());
                    internalSession = (InternalSession)this.sessionTable.get(sessionID);
                    if (internalSession != null) break block9;
                    internalSession = this.resolveRestrictedToken(sessionID, false);
                }
                catch (Exception exception) {
                    sessionDebug.error("Failed to retrieve new session", exception);
                    Object var8_11 = null;
                    SessionService.closeStream(dataInputStream);
                    return internalSession;
                }
            }
            Object var8_10 = null;
            SessionService.closeStream(dataInputStream);
            return internalSession;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            SessionService.closeStream(dataInputStream);
            throw throwable;
        }
    }

    InternalSession retrieveSession(SessionID sessionID, HttpSession httpSession) {
        if (isSessionFailoverEnabled && httpSession != null) {
            String string = (String)httpSession.getAttribute(httpSessionPropertyName);
            if (string == null) {
                sessionDebug.message("GISFHS-No InternalSession in HttpSession");
                return null;
            }
            InternalSession internalSession = SessionService.decrypt(string);
            if (internalSession == null || internalSession.getRestrictionForToken(sessionID) == null && !internalSession.getID().equals(sessionID)) {
                return null;
            }
            HashSet<URL> hashSet = (HashSet<URL>)httpSession.getAttribute(httpSessionOwnerListPropertyName);
            if (hashSet == null) {
                hashSet = new HashSet<URL>();
                httpSession.setAttribute(httpSessionOwnerListPropertyName, hashSet);
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                URL uRL = (URL)iterator.next();
                if (this.isLocalSessionService(uRL) || this.releaseSession(uRL, internalSession.getID())) continue;
                return null;
            }
            hashSet.add(this.thisSessionServiceURL);
            httpSession.setAttribute(httpSessionOwnerListPropertyName, hashSet);
            internalSession.setHttpSession(httpSession);
            this.updateSessionMaps(internalSession);
            return internalSession;
        }
        return null;
    }

    private void updateSessionMaps(InternalSession internalSession) {
        if (internalSession == null) {
            return;
        }
        if (this.checkIfShouldDestroy(internalSession)) {
            return;
        }
        this.sessionTable.put(internalSession.getID(), internalSession);
        String string = internalSession.getSessionHandle();
        if (string != null) {
            this.sessionHandleTable.put(string, internalSession);
        }
        Object[] objectArray = internalSession.getRestrictedTokens();
        int n = 0;
        while (n < objectArray.length) {
            this.restrictedTokenMap.put(objectArray[n], internalSession.getID());
            ++n;
        }
    }

    boolean checkIfShouldDestroy(InternalSession internalSession) {
        boolean bl = false;
        try {
            bl = internalSession.shouldDestroy();
        }
        catch (Exception exception) {
            sessionDebug.error("Exception in session shouldDestroy() : ", exception);
            bl = true;
        }
        if (bl) {
            try {
                sessionService.removeInternalSession(internalSession.getID());
            }
            catch (Exception exception) {
                sessionDebug.error("Exception while removing session : ", exception);
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean saveSession(SessionID sessionID) {
        boolean bl;
        if (!isSessionFailoverEnabled) {
            return false;
        }
        if (sessionDebug.messageEnabled()) {
            sessionDebug.message("Saving internal session using remote method " + sessionID);
        }
        InputStream inputStream = null;
        try {
            try {
                String string = "?op=save";
                URL uRL = new URL(this.thisSessionServerProtocol, this.thisSessionServer, this.thisSessionServerPort, deploymentURI + "/GetHttpSession" + string);
                HttpURLConnection httpURLConnection = this.invokeRemote(uRL, sessionID, null);
                inputStream = httpURLConnection.getInputStream();
                bl = httpURLConnection.getResponseCode() == 200;
                Object var8_8 = null;
            }
            catch (Exception exception) {
                sessionDebug.error("Failed to save session", exception);
                Object var8_9 = null;
                SessionService.closeStream(inputStream);
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            SessionService.closeStream(inputStream);
            throw throwable;
        }
        SessionService.closeStream(inputStream);
        return bl;
    }

    int handleSaveSession(SessionID sessionID, HttpSession httpSession) {
        if (!isSessionFailoverEnabled) {
            return 501;
        }
        InternalSession internalSession = (InternalSession)this.sessionTable.get(sessionID);
        if (internalSession == null) {
            sessionDebug.error("handleSaveSession: session not found " + sessionID);
            return 404;
        }
        if (!internalSession.getID().getTail().equals(SessionService.extractHttpSessionId(httpSession))) {
            sessionDebug.error("handleSaveSession: http session id does not match sid " + sessionID);
            return 500;
        }
        this.doSaveSession(internalSession, httpSession);
        return 200;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getRestrictedTokenIdRemotely(URL uRL, SessionID sessionID, TokenRestriction tokenRestriction) {
        String string;
        DataOutputStream dataOutputStream;
        DataInputStream dataInputStream;
        block6: {
            String string2;
            block5: {
                dataInputStream = null;
                dataOutputStream = null;
                try {
                    try {
                        String string3 = "?op=get_restricted_token";
                        URL uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), deploymentURI + "/GetHttpSession" + string3);
                        HttpURLConnection httpURLConnection = this.invokeRemote(uRL2, sessionID, null);
                        httpURLConnection.setRequestMethod("POST");
                        httpURLConnection.setDoOutput(true);
                        httpURLConnection.setRequestProperty("Content-Type", "application/octet-stream");
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
                        dataOutputStream2.writeUTF(TokenRestrictionFactory.marshal(tokenRestriction));
                        dataOutputStream2.flush();
                        dataOutputStream2.close();
                        byte[] byArray = byteArrayOutputStream.toByteArray();
                        httpURLConnection.setRequestProperty("Content-Length", Integer.toString(byArray.length));
                        dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
                        dataOutputStream.write(byArray);
                        dataOutputStream.close();
                        dataOutputStream = null;
                        dataInputStream = new DataInputStream(httpURLConnection.getInputStream());
                        if (httpURLConnection.getResponseCode() != 200) {
                            string2 = null;
                            Object var14_15 = null;
                            break block5;
                        }
                        string = dataInputStream.readUTF();
                        break block6;
                    }
                    catch (Exception exception) {
                        sessionDebug.error("Failed to create restricted token remotely", exception);
                        Object var14_17 = null;
                        SessionService.closeStream(dataInputStream);
                        SessionService.closeStream(dataOutputStream);
                        return null;
                    }
                }
                catch (Throwable throwable) {
                    Object var14_18 = null;
                    SessionService.closeStream(dataInputStream);
                    SessionService.closeStream(dataOutputStream);
                    throw throwable;
                }
            }
            SessionService.closeStream(dataInputStream);
            SessionService.closeStream(dataOutputStream);
            return string2;
        }
        Object var14_16 = null;
        SessionService.closeStream(dataInputStream);
        SessionService.closeStream(dataOutputStream);
        return string;
    }

    String handleGetRestrictedTokenIdRemotely(SessionID sessionID, TokenRestriction tokenRestriction) {
        try {
            return this.doGetRestrictedTokenId(sessionID, tokenRestriction);
        }
        catch (Exception exception) {
            sessionDebug.error("Failed to create restricted token remotely", exception);
            return null;
        }
    }

    void saveForFailover(InternalSession internalSession) {
        if (!isSessionFailoverEnabled) {
            return;
        }
        if (SessionService.getUseInternalRequestRouting()) {
            if (!internalSession.willExpire()) {
                return;
            }
            try {
                this.getRepository().save(internalSession);
            }
            catch (Exception exception) {
                sessionDebug.error("SessionService.saveForFailover: exception encountered", exception);
            }
        } else if (useRemoteSaveMethod) {
            this.saveSession(internalSession.getID());
        } else {
            HttpSession httpSession = internalSession.getHttpSession();
            if (httpSession != null) {
                this.doSaveSession(internalSession, httpSession);
            }
        }
    }

    private void doSaveSession(InternalSession internalSession, HttpSession httpSession) {
        try {
            httpSession.setAttribute(httpSessionPropertyName, (Object)SessionService.encrypt(internalSession));
        }
        catch (Exception exception) {
            sessionDebug.error("SessionService.doSaveSession: exception encountered", exception);
        }
    }

    private HttpURLConnection invokeRemote(URL uRL, SessionID sessionID, String string) throws Exception {
        if (!isSessionFailoverEnabled) {
            return null;
        }
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            String string2 = (String)AccessController.doPrivileged(new EncodeAction(this.thisSessionServerURL + "@" + System.currentTimeMillis()));
            String string3 = "DSAMESecurityCookie=" + string2;
            if (string != null) {
                string3 = string3 + ";" + string;
            }
            if (sessionID != null) {
                string3 = string3 + ";" + Session.getCookieName() + "=" + sessionID;
                String string4 = sessionID.getTail();
                if (string4 != null) {
                    string3 = string3 + ";" + SessionService.getHttpSessionTrackingCookieName() + "=" + string4;
                }
            }
            httpURLConnection.setRequestProperty("Cookie", string3);
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setDoInput(true);
        }
        catch (Exception exception) {
            sessionDebug.message("Failed contacting " + uRL, exception);
            throw exception;
        }
        return httpURLConnection;
    }

    public static String encrypt(Object object) {
        String string;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            String string2 = Base64.encode(byteArrayOutputStream.toByteArray());
            string = (String)AccessController.doPrivileged(new EncodeAction(string2, Crypt.getHardcodedKeyEncryptor()));
        }
        catch (Exception exception) {
            sessionDebug.message("Error in encrypting the Internal Session object");
            return null;
        }
        return string;
    }

    public static InternalSession decrypt(String string) {
        if (string == null) {
            return null;
        }
        byte[] byArray = null;
        Object object = null;
        try {
            String string2 = (String)AccessController.doPrivileged(new DecodeAction(string, Crypt.getHardcodedKeyEncryptor()));
            byArray = Base64.decode(string2);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        catch (Exception exception) {
            sessionDebug.message("Error in decrypting the Internal Session object" + exception.getMessage());
            return null;
        }
        if (object == null) {
            return null;
        }
        return (InternalSession)object;
    }

    public static String encodeID(String string) {
        if (string == null) {
            return null;
        }
        int n = 0;
        char[] cArray = string.toCharArray();
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == '%') {
                ++n;
            }
            ++n2;
        }
        int n3 = cArray.length + n * 2;
        char[] cArray2 = new char[n3];
        int n4 = 0;
        int n5 = 0;
        while (n4 < cArray.length) {
            switch (cArray[n4]) {
                case '%': {
                    cArray2[n5] = 37;
                    cArray2[n5 + 1] = 50;
                    cArray2[n5 + 2] = 53;
                    n5 += 3;
                    break;
                }
                default: {
                    cArray2[n5] = cArray[n4];
                    ++n5;
                }
            }
            ++n4;
        }
        return String.valueOf(cArray2);
    }

    protected static void debugIS(String string, Object object) {
        block6: {
            InternalSession internalSession = null;
            if (object == null) {
                sessionDebug.message("InternalSession Attribute is NULL in -->" + string);
                return;
            }
            internalSession = (InternalSession)object;
            if (internalSession != null) {
                try {
                    sessionDebug.message(string + " --Value of sessionID-->" + internalSession.getID());
                    sessionDebug.message(string + " --Value of clientDomain-->" + internalSession.getClientDomain());
                    sessionDebug.message(string + " --Value of maxSessionTime-->" + internalSession.getMaxSessionTime());
                    sessionDebug.message(string + " --Value of sessionState-->" + internalSession.getState());
                    sessionDebug.message(string + " --Value of idleTime-->" + internalSession.getIdleTime());
                    if (internalSession.getProperty("Name") != null) {
                        sessionDebug.message(string + " --Value of property Name is -->" + internalSession.getProperty("Name"));
                        break block6;
                    }
                    sessionDebug.message(string + "  --Value of property Name is NULL");
                }
                catch (Exception exception) {
                    sessionDebug.message("ERROR in debugIS" + exception.getMessage());
                }
            } else {
                sessionDebug.message("InternalSession is NULL in -->" + string);
            }
        }
    }

    public static boolean matchFilter(String string, String string2) {
        if (string2.equals("*") || string2.equals(string)) {
            return true;
        }
        int n = string2.length();
        int n2 = string2.indexOf("*");
        if (n2 >= 0) {
            String string3 = string2.substring(0, n2);
            if (!string.startsWith(string3, 0)) {
                return false;
            }
            int n3 = string3.length() + 1;
            int n4 = 0;
            if (n2 > 0) {
                n4 = n3;
            }
            String string4 = string2.substring(n3, n);
            while ((n2 = string2.indexOf("*", n3)) != -1) {
                string3 = string2.substring(n3, n2);
                if (string.indexOf(string3, n4) == -1) {
                    return false;
                }
                n3 = n2 + 1;
                n4 = n4 + string3.length() + 1;
                string4 = string2.substring(n3, n);
            }
            if (string.endsWith(string4)) {
                return true;
            }
        }
        return false;
    }

    public static int getConnectionMaxWaitTime() {
        return connectionMaxWaitTime;
    }

    public static int getMaxWaitTimeForConstraint() {
        return maxWaitTimeForConstraint;
    }

    public static String getJdbcDriverClass() {
        return jdbcDriverClass;
    }

    public static String getJdbcURL() {
        return jdbcURL;
    }

    public static int getMaxPoolSize() {
        return maxPoolSize;
    }

    public static int getMinPoolSize() {
        return minPoolSize;
    }

    public static String getSessionStoreUserName() {
        return sessionStoreUserName;
    }

    public static String getSessionStorePassword() {
        return sessionStorePassword;
    }

    public boolean isSiteEnabled() {
        return isSiteEnabled;
    }

    public static boolean isPropertyNotificationEnabled() {
        return isPropertyNotificationEnabled;
    }

    protected static void setPropertyNotificationEnabled(boolean bl) {
        isPropertyNotificationEnabled = bl;
    }

    public static boolean isSendPropertyNotification(String string) {
        if (!isPropertyNotificationEnabled) {
            return false;
        }
        return notificationProperties.contains(string);
    }

    protected static Set getNotificationProperties() {
        return notificationProperties;
    }

    protected static void setNotificationProperties(Set set) {
        notificationProperties = set;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        int n;
        int n2;
        LOG_PROVIDER = "Session";
        threadPool = null;
        ssoManager = null;
        sessionDebug = null;
        maxSessions = 10000;
        numberOfActiveSessions = 0;
        dsameAdminDN = null;
        dsameAdminPassword = null;
        logger = null;
        errorLogger = null;
        logProvider = null;
        logStatus = false;
        httpSessionTrackingCookieName = SystemProperties.get("com.iplanet.am.session.failover.httpSessionTrackingCookieName", "JSESSIONID");
        sunAppServerLBRoutingCookieName = SystemProperties.get("com.iplanet.am.session.failover.sunAppServerLBRoutingCookieName", "JROUTE");
        isEnableHostLookUp = Boolean.valueOf(SystemProperties.get("com.sun.am.session.enableHostLookUp"));
        webContainer = SystemProperties.get("com.sun.identity.webcontainer");
        isWeblogicFlag = false;
        isSunAppServerFlag = false;
        defaultApplicationMaxCachingTime = String.valueOf(0x222222222222222L);
        applicationMaxCachingTime = Long.valueOf(SystemProperties.get("com.sun.identity.session.application.maxCacheTime", defaultApplicationMaxCachingTime));
        sessionStoreUserName = null;
        sessionStorePassword = null;
        clusterMemberMap = new HashMap();
        connectionMaxWaitTime = 5000;
        jdbcDriverClass = null;
        jdbcURL = null;
        minPoolSize = 8;
        maxPoolSize = 32;
        maxWaitTimeForConstraint = 6000;
        isPropertyNotificationEnabled = false;
        sessionServiceToken = null;
        adminToken = null;
        sessionDebug = Debug.getInstance("amSession");
        stats = Stats.getInstance("amMasterSessionTableStats");
        try {
            n2 = Integer.parseInt(SystemProperties.get("com.iplanet.am.notification.threadpool.size"));
        }
        catch (Exception exception) {
            n2 = 10;
        }
        try {
            n = Integer.parseInt(SystemProperties.get("com.iplanet.am.notification.threadpool.threshold"));
        }
        catch (Exception exception) {
            n = 100;
        }
        threadPool = new ThreadPool("amSession", n2, n, true, sessionDebug);
        try {
            maxSessions = Integer.parseInt(SystemProperties.get("com.iplanet.am.session.maxSessions"));
        }
        catch (Exception exception) {
            maxSessions = 10000;
        }
        String string = null;
        string = SystemProperties.get("com.iplanet.am.logstatus");
        if (string == null) {
            string = "INACTIVE";
        }
        if (string.equalsIgnoreCase("ACTIVE")) {
            logStatus = true;
        }
        if (webContainer.startsWith("BEA")) {
            isWeblogicFlag = true;
        }
        if (webContainer.startsWith("IAS")) {
            isSunAppServerFlag = true;
        }
        returnAppSession = Boolean.valueOf(SystemProperties.get("com.sun.identity.session.returnAppSession", "false"));
        sessionService = null;
        deploymentURI = SystemProperties.get("com.iplanet.am.services.deploymentDescriptor");
        isSessionFailoverEnabled = false;
        isSiteEnabled = false;
        isSessionConstraintEnabled = false;
        bypassConstratintForToplevelAdmin = false;
        constraintResultingBehavior = 1;
        useRemoteSaveMethod = Boolean.valueOf(SystemProperties.get("com.iplanet.am.session.failover.useRemoteSaveMethod"));
        useInternalRequestRouting = Boolean.valueOf(SystemProperties.get("com.iplanet.am.session.failover.useInternalRequestRouting", "true"));
        sessionRepository = null;
    }

    public static class ExtendedSessionID
    extends SessionID {
        ExtendedSessionID(String string, String string2, String string3) {
            super(string);
            this.setServerID(string2);
            this.sessionDomain = string3;
        }
    }

    class SessionNotificationSender
    implements Runnable {
        private SessionService sessionService;
        private InternalSession session;
        private int eventType;

        SessionNotificationSender(SessionService sessionService2, InternalSession internalSession, int n) {
            this.sessionService = sessionService2;
            this.session = internalSession;
            this.eventType = n;
        }

        public void run() {
            Map map = this.session.getSessionEventURLs();
            if (this.sessionService.sessionEventURLs.size() != 0 || map.size() != 0) {
                Object object;
                Object object2;
                Enumeration enumeration = this.sessionService.sessionEventURLs.elements();
                SessionNotification sessionNotification = new SessionNotification(this.session.toSessionInfo(), this.eventType, System.currentTimeMillis());
                Notification notification = null;
                NotificationSet notificationSet = null;
                while (enumeration.hasMoreElements()) {
                    object2 = (String)enumeration.nextElement();
                    try {
                        object = new URL((String)object2);
                        if (this.sessionService.isLocalSessionService((URL)object)) {
                            SessionNotificationHandler.handler.processNotification(sessionNotification);
                            continue;
                        }
                        if (notification == null || notificationSet == null) {
                            notification = new Notification(sessionNotification.toXMLString());
                            notificationSet = new NotificationSet(SessionService.SESSION_SERVICE);
                            notificationSet.addNotification(notification);
                        }
                        PLLServer.send((URL)object, notificationSet);
                    }
                    catch (Exception exception) {
                        sessionDebug.error("Global notification to " + (String)object2, exception);
                    }
                }
                object2 = map;
                synchronized (object2) {
                    object = map.entrySet().iterator();
                    while (object.hasNext()) {
                        Map.Entry entry = (Map.Entry)object.next();
                        String string = (String)entry.getKey();
                        if (this.sessionService.sessionEventURLs.contains(string)) continue;
                        try {
                            SessionID sessionID = (SessionID)entry.getValue();
                            SessionInfo sessionInfo = SessionService.this.makeSessionInfo(this.session, sessionID);
                            SessionNotification sessionNotification2 = new SessionNotification(sessionInfo, this.eventType, System.currentTimeMillis());
                            Notification notification2 = null;
                            NotificationSet notificationSet2 = null;
                            URL uRL = new URL(string);
                            if (this.sessionService.isLocalSessionService(uRL)) {
                                SessionNotificationHandler.handler.processNotification(sessionNotification2);
                                continue;
                            }
                            notification2 = new Notification(sessionNotification2.toXMLString());
                            notificationSet2 = new NotificationSet(SessionService.SESSION_SERVICE);
                            notificationSet2.addNotification(notification2);
                            PLLServer.send((URL)uRL, (NotificationSet)notificationSet2);
                        }
                        catch (Exception exception) {
                            sessionDebug.error("Individual notification to " + string, exception);
                        }
                    }
                }
            }
        }
    }
}

