/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.service;

import com.iplanet.am.util.Debug;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.service.AMSessionRepository;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.dpro.session.share.SessionRequest;
import com.iplanet.dpro.session.share.SessionResponse;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.session.util.RestrictedTokenContext;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SessionCount {
    private static Map uuidSessionMap = Collections.synchronizedMap(new HashMap());
    static final int SINGLE_SERVER_MODE = 1;
    static final int MULTI_SERVER_MODE = 2;
    static final int SFO_MODE = 3;
    private static int deploymentMode = 0;
    private static Debug debug = SessionService.sessionDebug;
    private static SSOTokenManager ssoManager = null;
    private static SSOToken adminToken = null;

    static int getDeploymentMode() {
        return deploymentMode;
    }

    static SessionService getSS() {
        SessionService sessionService = SessionService.getSessionService();
        if (sessionService == null) {
            debug.error("SessionConstraint:  Failed to get the session service instance");
        }
        return sessionService;
    }

    public static Map getAllSessionsByUUID(String string) throws Exception {
        Map map = null;
        switch (deploymentMode) {
            case 1: {
                map = SessionCount.getSessionsFromLocalServer(string);
                break;
            }
            case 2: {
                map = SessionCount.getSessionsFromPeerServers(string);
                break;
            }
            case 3: {
                map = SessionCount.getSessionsFromRepository(string);
                break;
            }
        }
        return map;
    }

    static Map getSessionsFromLocalServer(String string) {
        Set set = (Set)uuidSessionMap.get(string);
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        if (set != null) {
            Set set2 = set;
            synchronized (set2) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    SessionID sessionID = (SessionID)iterator.next();
                    InternalSession internalSession = SessionCount.getSS().getInternalSession(sessionID);
                    hashMap.put(sessionID.toString(), new Long(internalSession.getExpirationTime()));
                }
            }
        }
        return hashMap;
    }

    private static Map getSessionsFromPeerServers(String string) {
        Map map = SessionCount.getSessionsFromLocalServer(string);
        String string2 = SessionCount.getSS().getLocalServerID();
        Set set = null;
        try {
            set = WebtopNaming.getSiteNodes(string2);
        }
        catch (Exception exception) {
            debug.error("Failed to get the serverIDs from WebtopNaming.", exception);
            return map;
        }
        int n = set.size();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (string3.equals(string2)) continue;
            try {
                URL uRL = Session.getSessionServiceURL(string3);
                SessionRequest sessionRequest = new SessionRequest(7, SessionCount.getAdminToken().getTokenID().toString(), false);
                sessionRequest.setUUID(string);
                SessionResponse sessionResponse = SessionCount.getSessionResponse(uRL, sessionRequest);
                map.putAll(sessionResponse.getSessionsForGivenUUID());
            }
            catch (SessionException sessionException) {
                if (!debug.messageEnabled()) continue;
                debug.message("SessionConstraint: peer AM server is down...");
            }
        }
        return map;
    }

    private static Map getSessionsFromRepository(String string) throws Exception {
        AMSessionRepository aMSessionRepository = SessionService.getSessionService().getRepository();
        Map map = null;
        try {
            map = aMSessionRepository.getSessionsByUUID(string);
        }
        catch (Exception exception) {
            debug.error("Session repository is not available therefore no new user session will be created.", exception);
            throw exception;
        }
        return map;
    }

    static void incrementSessionCount(InternalSession internalSession) {
        if (deploymentMode == 1) {
            Set<SessionID> set = (Set<SessionID>)uuidSessionMap.get(internalSession.getUUID());
            if (set != null) {
                set.add(internalSession.getID());
            } else {
                set = Collections.synchronizedSet(new HashSet());
                set.add(internalSession.getID());
                uuidSessionMap.put(internalSession.getUUID(), set);
            }
        }
    }

    static void decrementSessionCount(InternalSession internalSession) {
        Set set;
        String string = internalSession.getUUID();
        SessionID sessionID = internalSession.getID();
        if (deploymentMode == 1 && (set = (Set)uuidSessionMap.get(string)) != null) {
            set.remove(sessionID);
            if (set.isEmpty()) {
                uuidSessionMap.remove(string);
            }
        }
    }

    private static SessionResponse getSessionResponse(URL uRL, SessionRequest sessionRequest) throws SessionException {
        try {
            SessionResponse sessionResponse;
            Object object = RestrictedTokenContext.getCurrent();
            if (object != null) {
                sessionRequest.setRequester(RestrictedTokenContext.marshal(object));
            }
            if ((sessionResponse = Session.sendPLLRequest(uRL, sessionRequest)).getException() != null) {
                throw new SessionException(sessionResponse.getException());
            }
            return sessionResponse;
        }
        catch (SessionException sessionException) {
            throw sessionException;
        }
        catch (Exception exception) {
            throw new SessionException(exception);
        }
    }

    static SSOToken getAdminToken() {
        if (adminToken == null) {
            try {
                adminToken = SessionCount.getSS().getSessionServiceToken();
            }
            catch (Exception exception) {
                debug.error("Failed to get the admin token for Session constraint checking.", exception);
            }
        }
        return adminToken;
    }

    static {
        try {
            ssoManager = SSOTokenManager.getInstance();
        }
        catch (Exception exception) {
            debug.error("SessionConstraint: Failied to get the SSOTokenManager instance.");
        }
        deploymentMode = SessionCount.getSS().isSiteEnabled() ? (SessionCount.getSS().isSessionFailoverEnabled() ? 3 : 2) : 1;
    }
}

