/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.jmqdb;

import com.sun.messaging.ConnectionFactory;
import com.sun.messaging.TopicConnectionFactory;
import java.util.Hashtable;
import java.util.Random;
import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class PersistSession
implements MessageListener {
    public static final String READ = "READ";
    public static final String WRITE = "WRITE";
    public static final String DELETE = "DELETE";
    public static final String DELETEBYDATE = "DELETEBYDATE";
    public static final String SHUTDOWN = "SHUTDOWN";
    public static final String NOT_FOUND = "notfound";
    public static final String OP_STATUS = "opstatus";
    public static final String GET_SESSION_COUNT = "GET_SESSION_COUNT";
    public static final String DBREQUEST = "AM_DBREQUEST";
    public static final String DBRESPONSE = "AM_DRESPONSE";
    public static final String ID = "ID";
    public static int TIMEOUT = 1000;
    public static final String SESSIONID = "SessionId";
    public static final String EXPIRYDATE = "ExpiryDate";
    public static final String DATA = "Data";
    private String _id;
    javax.jms.TopicConnectionFactory tFactory = null;
    TopicConnection tConn = null;
    TopicSession tSession = null;
    Topic reqTopic = null;
    Topic resTopic = null;
    TopicPublisher reqPub = null;
    TopicSubscriber resSub = null;
    Hashtable processedMsgs = new Hashtable();
    Random rdmGen = new Random();
    private int MAX_RESPONSE_QUEUES = 1;
    int msgcount = 0;
    private String serverList = null;
    private String userName = null;
    private String password = null;
    private int readTimeOut = 5000;
    private int readTimeOutForConstraint = 6000;

    public PersistSession(String string) throws Exception {
        this._id = string;
        this.tFactory = new TopicConnectionFactory();
        this.tConn = this.tFactory.createTopicConnection();
        int n = 3;
        this.tSession = this.tConn.createTopicSession(false, n);
        this.reqTopic = this.tSession.createTopic(DBREQUEST);
        this.resTopic = this.tSession.createTopic(DBRESPONSE);
        this.reqPub = this.tSession.createPublisher(this.reqTopic);
        String string2 = "ID = '" + this._id + "'";
        this.resSub = this.tSession.createSubscriber(this.resTopic, string2, true);
        this.resSub.setMessageListener((MessageListener)this);
        this.tConn.start();
    }

    public PersistSession(String string, String string2, String string3, String string4, int n, int n2) throws Exception {
        this._id = string;
        this.tFactory = new TopicConnectionFactory();
        this.serverList = string2;
        this.userName = string3;
        this.password = string4;
        this.readTimeOut = n;
        this.readTimeOutForConstraint = n2;
        this.sunSpecificConfig(this.tFactory);
        this.tConn = this.tFactory.createTopicConnection();
        int n3 = 3;
        this.tSession = this.tConn.createTopicSession(false, n3);
        this.reqTopic = this.tSession.createTopic(DBREQUEST);
        this.resTopic = this.tSession.createTopic(DBRESPONSE);
        this.reqPub = this.tSession.createPublisher(this.reqTopic);
        this.reqPub.setDeliveryMode(1);
        String string5 = "ID = '" + this._id + "'";
        this.resSub = this.tSession.createSubscriber(this.resTopic, string5, true);
        this.resSub.setMessageListener((MessageListener)this);
        this.tConn.start();
    }

    public Object read(Object object) throws Exception {
        BytesMessage bytesMessage = (BytesMessage)object;
        bytesMessage.setStringProperty(ID, this._id);
        bytesMessage.setStringProperty("op", READ);
        Long l = new Long(this.rdmGen.nextLong());
        this.processedMsgs.put(l, l);
        bytesMessage.writeLong(l.longValue());
        Long l2 = l;
        synchronized (l2) {
            this.reqPub.publish((Message)bytesMessage);
            l.wait(this.readTimeOut);
        }
        Message message = (Message)this.processedMsgs.remove(l);
        String string = this.getStringProperty(message, OP_STATUS);
        if (string != null && string.equals(NOT_FOUND)) {
            throw new Exception("Session not found in repository");
        }
        return message;
    }

    public void delete(Object object) throws Exception {
        BytesMessage bytesMessage = (BytesMessage)object;
        bytesMessage.setStringProperty(ID, this._id);
        bytesMessage.setStringProperty("op", DELETE);
        this.reqPub.publish((Message)bytesMessage);
    }

    public void delete_bydate(Object object) throws Exception {
        BytesMessage bytesMessage = (BytesMessage)object;
        bytesMessage.setStringProperty(ID, this._id);
        bytesMessage.setStringProperty("op", DELETEBYDATE);
        this.reqPub.publish((Message)bytesMessage);
    }

    public void shutdown(Object object) throws Exception {
        BytesMessage bytesMessage = (BytesMessage)object;
        bytesMessage.setStringProperty(ID, this._id);
        bytesMessage.setStringProperty("op", SHUTDOWN);
        this.reqPub.publish((Message)bytesMessage);
    }

    public void write(Object object) throws Exception {
        Message message = (Message)object;
        message.setStringProperty(ID, this._id);
        message.setStringProperty("op", WRITE);
        this.reqPub.publish(message);
    }

    public Object getSessionsByUUID(Object object) throws Exception {
        BytesMessage bytesMessage = (BytesMessage)object;
        bytesMessage.setStringProperty(ID, this._id);
        bytesMessage.setStringProperty("op", GET_SESSION_COUNT);
        Long l = new Long(this.rdmGen.nextLong());
        this.processedMsgs.put(l, l);
        bytesMessage.writeLong(l.longValue());
        Long l2 = l;
        synchronized (l2) {
            this.reqPub.publish((Message)bytesMessage);
            l.wait(this.readTimeOutForConstraint);
        }
        Object v = this.processedMsgs.remove(l);
        if (v instanceof Long) {
            return null;
        }
        Message message = (Message)v;
        return message;
    }

    public Object createMessage() throws Exception {
        return this.tSession.createBytesMessage();
    }

    public String getStringProperty(Object object, String string) throws Exception {
        BytesMessage bytesMessage = (BytesMessage)object;
        return bytesMessage.getStringProperty(string);
    }

    public void setStringProperty(Object object, String string, String string2) throws Exception {
        Message message = (Message)object;
        message.setStringProperty(string, string2);
    }

    public void setString(Object object, String string, String string2) throws Exception {
        BytesMessage bytesMessage = (BytesMessage)object;
        bytesMessage.writeLong((long)string2.length());
        bytesMessage.writeBytes(string2.getBytes());
    }

    public void setBytes(Object object, String string, byte[] byArray) throws Exception {
        BytesMessage bytesMessage = (BytesMessage)object;
        bytesMessage.writeLong((long)byArray.length);
        bytesMessage.writeBytes(byArray);
    }

    public void setLong(Object object, String string, long l) throws Exception {
        BytesMessage bytesMessage = (BytesMessage)object;
        bytesMessage.writeLong(l);
    }

    public void setInt(Object object, String string, int n) throws Exception {
        BytesMessage bytesMessage = (BytesMessage)object;
        bytesMessage.writeInt(n);
    }

    public void setBoolean(Object object, String string, boolean bl) throws Exception {
        BytesMessage bytesMessage = (BytesMessage)object;
        bytesMessage.writeBoolean(bl);
    }

    public String getString(Object object, String string) throws Exception {
        BytesMessage bytesMessage = (BytesMessage)object;
        int n = bytesMessage.readInt();
        byte[] byArray = new byte[n];
        bytesMessage.readBytes(byArray);
        return new String(byArray);
    }

    public byte[] getBytes(Object object, String string) throws Exception {
        BytesMessage bytesMessage = (BytesMessage)object;
        long l = bytesMessage.readLong();
        byte[] byArray = new byte[(int)l];
        bytesMessage.readBytes(byArray);
        return byArray;
    }

    public long getLong(Object object, String string) throws Exception {
        BytesMessage bytesMessage = (BytesMessage)object;
        return bytesMessage.readLong();
    }

    public int getInt(Object object, String string) throws Exception {
        BytesMessage bytesMessage = (BytesMessage)object;
        return bytesMessage.readInt();
    }

    public boolean getBoolean(Object object, String string) throws Exception {
        BytesMessage bytesMessage = (BytesMessage)object;
        return bytesMessage.readBoolean();
    }

    public void onMessage(Message message) {
        block5: {
            try {
                BytesMessage bytesMessage = (BytesMessage)message;
                long l = bytesMessage.readLong();
                Long l2 = new Long(l);
                Object v = this.processedMsgs.get(l2);
                if (v == null) break block5;
                this.processedMsgs.put(v, message);
                Object v2 = v;
                synchronized (v2) {
                    v.notify();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void sunSpecificConfig(javax.jms.TopicConnectionFactory topicConnectionFactory) throws Exception {
        ConnectionFactory connectionFactory = (ConnectionFactory)topicConnectionFactory;
        connectionFactory.setProperty("imqAddressList", this.serverList);
        connectionFactory.setProperty("imqAddressListBehavior", "RANDOM");
        connectionFactory.setProperty("imqReconnectEnabled", "true");
        connectionFactory.setProperty("imqConnectionFlowLimitEnabled", "true");
        connectionFactory.setProperty("imqDefaultUsername", this.userName);
        connectionFactory.setProperty("imqDefaultPassword", this.password);
    }
}

