/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.jmqdb;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.jmqdb.PersistSession;
import com.iplanet.dpro.session.service.AMSessionRepository;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.dpro.session.share.SessionBundle;
import com.iplanet.services.naming.WebtopNaming;
import com.sun.identity.session.util.SessionUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.jms.IllegalStateException;

public class JMQSessionRepository
implements AMSessionRepository,
Runnable {
    public static final String READ = "READ";
    public static final String WRITE = "WRITE";
    public static final String DELETE = "DELETE";
    public static final String DELETEBYDATE = "DELETEBYDATE";
    public static final String DBREQUEST = "AM_DBREQUEST";
    public static final String DBRESPONSE = "AM_DRESPONSE";
    public static final String ID = "ID";
    public static final String SESSIONID = "SessionId";
    public static final String EXPIRYDATE = "ExpiryDate";
    public static final String DATA = "Data";
    public static final String MASTER_SID = "MASTER_SID";
    public static final String UUID = "UUID";
    public static final String COUNT = "COUNT";
    public static final String SESSIONSTATE = "SESSIONSTATE";
    public static final String VERSION = "Version";
    String serverId;
    private int MAX_RESPONSE_QUEUES = 1;
    private static JMQSessionRepository sessionRepository = null;
    private static boolean isDatabaseUp = true;
    private static long gracePeriod = 300L;
    private static final String CLEANUP_GRACE_PERIOD = "com.sun.identity.session.repository.cleanupGracePeriod";
    private static final String BRIEF_DB_ERROR_MSG = "Session failover service is not functional due to DB unavailability.";
    private static final String DB_ERROR_MSG = "Session database is not available at this moment.Please check with the system administrator for appropriate actions";
    private static final String LOG_MSG_DB_BACK_ONLINE = "SESSION_DATABASE_BACK_ONLINE";
    private static final String LOG_MSG_DB_UNAVAILABLE = "SESSION_DATABASE_UNAVAILABLE";
    private static boolean lastLoggedDBStatusIsUp = true;
    private static long cleanUpPeriod = 300000L;
    private static long cleanUpValue = 0L;
    public static final String CLEANUP_RUN_PERIOD = "com.sun.identity.session.repository.cleanupRunPeriod";
    private static long healthCheckPeriod = 60000L;
    public static final String HEALTH_CHECK_RUN_PERIOD = "com.sun.identity.session.repository.healthCheckRunPeriod";
    private static long runPeriod = 60000L;
    private Thread checker;
    static Debug debug = SessionService.sessionDebug;
    PersistSession pSession = null;

    public JMQSessionRepository() throws Exception {
        String string = SystemProperties.get("com.iplanet.am.server.protocol");
        String string2 = SystemProperties.get("com.iplanet.am.server.host");
        String string3 = SystemProperties.get("com.iplanet.am.server.port");
        if (string == null || string3 == null || string2 == null) {
            throw new SessionException(SessionBundle.rbName, "propertyMustBeSet", null);
        }
        this.serverId = WebtopNaming.getServerID(string, string2, string3);
        this.initPersistSession();
        this.checker = new Thread(this);
        this.checker.setName("JDBCSessionRepositoryChecker");
        this.checker.setDaemon(true);
        this.checker.start();
    }

    private void initPersistSession() {
        block2: {
            try {
                this.pSession = new PersistSession(this.serverId, SessionService.getJdbcURL(), SessionService.getSessionStoreUserName(), SessionService.getSessionStorePassword(), SessionService.getConnectionMaxWaitTime(), SessionService.getMaxWaitTimeForConstraint());
                isDatabaseUp = true;
            }
            catch (Exception exception) {
                isDatabaseUp = false;
                debug.error(BRIEF_DB_ERROR_MSG);
                if (!debug.messageEnabled()) break block2;
                debug.message(DB_ERROR_MSG, exception);
            }
        }
    }

    public InternalSession retrieve(SessionID sessionID) throws Exception {
        if (!isDatabaseUp) {
            return null;
        }
        try {
            String string = SessionUtils.getEncryptedStorageKey(sessionID);
            Object object = this.pSession.createMessage();
            this.pSession.setString(object, SESSIONID, string);
            object = this.pSession.read(object);
            byte[] byArray = this.pSession.getBytes(object, DATA);
            InternalSession internalSession = (InternalSession)SessionUtils.decode(byArray);
            return internalSession;
        }
        catch (IllegalStateException illegalStateException) {
            isDatabaseUp = false;
            this.logDBStatus();
            debug.error(BRIEF_DB_ERROR_MSG, illegalStateException);
            if (debug.messageEnabled()) {
                debug.message(DB_ERROR_MSG, illegalStateException);
            }
            return null;
        }
        catch (Exception exception) {
            debug.message("JMQSessionRepository.retrieve(): failed retrieving session", exception);
            return null;
        }
    }

    public void delete(SessionID sessionID) throws Exception {
        if (!isDatabaseUp) {
            return;
        }
        try {
            String string = SessionUtils.getEncryptedStorageKey(sessionID);
            Object object = this.pSession.createMessage();
            this.pSession.setString(object, SESSIONID, string);
            this.pSession.delete(object);
        }
        catch (IllegalStateException illegalStateException) {
            isDatabaseUp = false;
            this.logDBStatus();
            debug.error(BRIEF_DB_ERROR_MSG, illegalStateException);
            if (debug.messageEnabled()) {
                debug.message(DB_ERROR_MSG, illegalStateException);
            }
        }
        catch (Exception exception) {
            debug.error("JMQSessionRepository.delete(): failed deleting session", exception);
        }
    }

    public void deleteExpired() throws Exception {
        if (!isDatabaseUp) {
            return;
        }
        try {
            long l = System.currentTimeMillis() / 1000L;
            Object object = this.pSession.createMessage();
            this.pSession.setLong(object, EXPIRYDATE, l);
            this.pSession.delete_bydate(object);
        }
        catch (IllegalStateException illegalStateException) {
            isDatabaseUp = false;
            this.logDBStatus();
            debug.error(BRIEF_DB_ERROR_MSG, illegalStateException);
            if (debug.messageEnabled()) {
                debug.message(DB_ERROR_MSG, illegalStateException);
            }
        }
        catch (Exception exception) {
            debug.error("JMQSessionRepository.deleteExpired(): failed deleting Expired Sessions", exception);
        }
    }

    public void save(InternalSession internalSession) throws Exception {
        if (!isDatabaseUp) {
            return;
        }
        try {
            SessionID sessionID = internalSession.getID();
            String string = SessionUtils.getEncryptedStorageKey(sessionID);
            byte[] byArray = SessionUtils.encode(internalSession);
            long l = internalSession.getExpirationTime() + gracePeriod;
            String string2 = internalSession.getUUID();
            Object object = this.pSession.createMessage();
            this.pSession.setString(object, SESSIONID, string);
            this.pSession.setLong(object, EXPIRYDATE, l);
            this.pSession.setString(object, UUID, string2);
            this.pSession.setString(object, MASTER_SID, sessionID.toString());
            this.pSession.setInt(object, SESSIONSTATE, internalSession.getState());
            this.pSession.setBytes(object, DATA, byArray);
            this.pSession.write(object);
        }
        catch (IllegalStateException illegalStateException) {
            isDatabaseUp = false;
            this.logDBStatus();
            debug.error(BRIEF_DB_ERROR_MSG, illegalStateException);
            if (debug.messageEnabled()) {
                debug.message(DB_ERROR_MSG, illegalStateException);
            }
        }
        catch (Exception exception) {
            debug.error("JMQSessionRepository.save(): failed to save Session", exception);
        }
    }

    public Map getSessionsByUUID(String string) throws Exception {
        if (!isDatabaseUp) {
            throw new SessionException("Session repository is not available.");
        }
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        int n = 0;
        try {
            Object object = this.pSession.createMessage();
            this.pSession.setString(object, UUID, string);
            object = this.pSession.getSessionsByUUID(object);
            if (object != null) {
                n = this.pSession.getInt(object, COUNT);
                int n2 = 0;
                while (n2 < n) {
                    String string2 = this.pSession.getString(object, COUNT);
                    Long l = new Long(this.pSession.getLong(object, COUNT));
                    hashMap.put(string2, l);
                    ++n2;
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            isDatabaseUp = false;
            this.logDBStatus();
            debug.error(BRIEF_DB_ERROR_MSG, illegalStateException);
            if (debug.messageEnabled()) {
                debug.message(DB_ERROR_MSG, illegalStateException);
            }
            throw new SessionException(illegalStateException);
        }
        catch (Exception exception) {
            throw new SessionException(exception);
        }
        return hashMap;
    }

    private void logDBStatus() {
        SessionService sessionService = SessionService.getSessionService();
        if (!isDatabaseUp && lastLoggedDBStatusIsUp) {
            sessionService.logSystemMessage(LOG_MSG_DB_UNAVAILABLE, Level.WARNING);
            lastLoggedDBStatusIsUp = false;
        }
        if (isDatabaseUp && !lastLoggedDBStatusIsUp) {
            sessionService.logSystemMessage(LOG_MSG_DB_BACK_ONLINE, Level.INFO);
            lastLoggedDBStatusIsUp = true;
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    long l;
                    long l2 = System.currentTimeMillis() + runPeriod;
                    if (debug.messageEnabled()) {
                        debug.message("Cleaning expired session records");
                    }
                    if (cleanUpValue <= 0L) {
                        this.deleteExpired();
                        cleanUpValue = cleanUpPeriod;
                    }
                    cleanUpValue -= runPeriod;
                    if (!isDatabaseUp) {
                        this.initPersistSession();
                        this.logDBStatus();
                    }
                    if ((l = l2 - System.currentTimeMillis()) <= 0L) continue;
                    Thread.sleep(l);
                }
            }
            catch (Exception exception) {
                debug.error("JMQSessionRepository.run(): Exception in thread", exception);
                continue;
            }
            break;
        }
    }

    static {
        try {
            gracePeriod = Integer.parseInt(SystemProperties.get(CLEANUP_GRACE_PERIOD, String.valueOf(gracePeriod)));
        }
        catch (Exception exception) {
            debug.error("Invalid value for com.sun.identity.session.repository.cleanupGracePeriod, using default");
        }
        try {
            cleanUpPeriod = Integer.parseInt(SystemProperties.get(CLEANUP_RUN_PERIOD, String.valueOf(cleanUpPeriod)));
        }
        catch (Exception exception) {
            debug.error("Invalid value for com.sun.identity.session.repository.cleanupRunPeriod, using default");
        }
        try {
            healthCheckPeriod = Integer.parseInt(SystemProperties.get(HEALTH_CHECK_RUN_PERIOD, String.valueOf(healthCheckPeriod)));
        }
        catch (Exception exception) {
            debug.error("Invalid value for com.sun.identity.session.repository.healthCheckRunPeriod, using default");
        }
        runPeriod = cleanUpPeriod <= healthCheckPeriod ? cleanUpPeriod : healthCheckPeriod;
        cleanUpValue = cleanUpPeriod;
    }
}

