/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.jdbc;

import com.iplanet.dpro.session.jdbc.JDBCConnectionImpl;
import com.iplanet.dpro.session.service.SessionService;
import javax.sql.ConnectionPoolDataSource;

public class OracleConnectionImpl
extends JDBCConnectionImpl {
    ConnectionPoolDataSource ds = null;
    static final String ORCL_POOL_CLASS_NAME = "oracle.jdbc.pool.OracleConnectionPoolDataSource";
    static final String ERROR_MSG_CLASS_NOT_FOUND = "Please check oracle driver file is in the classpath";
    static final String ERROR_MSG_INIT_ERROR = "Error while initializing OracleConnectionPoolDataSource";

    public void init(String string, String string2, String string3) {
        try {
            this.ds = (ConnectionPoolDataSource)Class.forName(ORCL_POOL_CLASS_NAME).newInstance();
            if (SessionService.sessionDebug.messageEnabled()) {
                SessionService.sessionDebug.message("username is :" + string2);
                SessionService.sessionDebug.message("URL is :" + string);
            }
            OracleConnectionImpl.invokeSetMethodCaseInsensitive(this.ds, "url", string);
            OracleConnectionImpl.invokeSetMethodCaseInsensitive(this.ds, "user", string2);
            OracleConnectionImpl.invokeSetMethodCaseInsensitive(this.ds, "password", string3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            SessionService.sessionDebug.error(ERROR_MSG_CLASS_NOT_FOUND, classNotFoundException);
        }
        catch (Exception exception) {
            SessionService.sessionDebug.error(ERROR_MSG_INIT_ERROR, exception);
        }
    }

    public ConnectionPoolDataSource getConnectionPoolDataSource() {
        return this.ds;
    }
}

