/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.ThreadPoolException;
import java.util.ArrayList;

public class ThreadPool {
    private int poolSize;
    private int threshold;
    private String poolName;
    private Debug debug;
    private ArrayList taskList = new ArrayList();

    public ThreadPool(String string, int n, int n2, boolean bl, Debug debug) {
        this.debug = debug;
        this.poolSize = n;
        this.threshold = n2;
        this.poolName = string;
        if (debug.messageEnabled()) {
            debug.message("Initiating login thread pool size = " + n + "\nThreshold = " + n2);
        }
        int n3 = 0;
        while (n3 < n) {
            WorkerThread workerThread = new WorkerThread(string + "[" + n3 + "]");
            workerThread.setDaemon(bl);
            workerThread.start();
            ++n3;
        }
    }

    public final void run(Runnable runnable) throws ThreadPoolException {
        ArrayList arrayList = this.taskList;
        synchronized (arrayList) {
            if (this.taskList.size() >= this.threshold) {
                throw new ThreadPoolException(this.poolName + " thread pool's task queue is full.");
            }
            this.taskList.add(runnable);
            this.taskList.notify();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Runnable getTask() {
        ArrayList arrayList = this.taskList;
        synchronized (arrayList) {
            while (this.taskList.isEmpty()) {
                try {
                    this.taskList.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return (Runnable)this.taskList.remove(0);
        }
    }

    private class WorkerThread
    extends Thread {
        public WorkerThread(String string) {
            this.setName(string);
        }

        public void run() {
            while (true) {
                Runnable runnable = ThreadPool.this.getTask();
                try {
                    runnable.run();
                    continue;
                }
                catch (Exception exception) {
                    ThreadPool.this.debug.error("Running task " + runnable, exception);
                    continue;
                }
                break;
            }
        }
    }
}

