/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class Cache
extends Dictionary
implements Map,
Serializable {
    private static final int DEFAULT_CACHE_SIZE = 10000;
    private transient Entry[] table;
    private transient int maxSize;
    private transient LRUList lruTracker;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient int modCount = 0;
    private static final long serialVersionUID = 1421746759512286392L;
    private transient Set keySet = null;
    private transient Set entrySet = null;
    private transient Collection values = null;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;

    public Cache(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
        this.maxSize = n;
        this.lruTracker = new LRUList();
    }

    public Cache(int n) {
        this(n, 0.75f);
        this.maxSize = n;
        this.lruTracker = new LRUList();
    }

    public Cache() {
        this(10000, 0.75f);
        this.maxSize = 10000;
        this.lruTracker = new LRUList();
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized Enumeration keys() {
        return new Enumerator(0, false);
    }

    public synchronized Enumeration elements() {
        return new Enumerator(1, false);
    }

    public synchronized boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (n-- > 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                if (entry.value.equals(object)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object object) {
        return this.contains(object);
    }

    public synchronized boolean containsKey(Object object) {
        Entry[] entryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(object)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public synchronized Object get(Object object) {
        Entry[] entryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(object)) {
                this.lruTracker.replaceLast(entry);
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    protected void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        ++this.modCount;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public synchronized Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(object)) {
                Object object3 = entry.value;
                entry.value = object2;
                this.lruTracker.replaceLast(entry);
                return object3;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold && this.count != this.maxSize) {
            ++this.modCount;
            this.rehash();
            entryArray = this.table;
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        Entry entry2 = null;
        if (this.count == this.maxSize) {
            entry2 = this.lruTracker.getFirst();
            this.adjustEntry(entry2.key);
            this.lruTracker.replaceLast(entry2);
            entry2.changeValues(n, object, object2, entryArray[n2]);
        } else {
            ++this.modCount;
            ++this.count;
            entry2 = new Entry(n, object, object2, entryArray[n2]);
            this.lruTracker.addLast(entry2);
        }
        entryArray[n2] = entry2;
        return null;
    }

    protected void adjustEntry(Object object) {
        Entry[] entryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(object)) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n2] = entry.next;
                }
            }
            entry2 = entry;
            entry = entry.next;
        }
    }

    public synchronized Object remove(Object object) {
        Entry[] entryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(object)) {
                ++this.modCount;
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n2] = entry.next;
                }
                --this.count;
                Object object2 = entry.value;
                entry.value = null;
                this.lruTracker.remove(entry);
                return object2;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public synchronized void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public synchronized void clear() {
        Entry[] entryArray = this.table;
        ++this.modCount;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.lruTracker = null;
        this.count = 0;
    }

    public synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.entrySet().iterator();
        stringBuffer.append("{");
        int n2 = 0;
        while (n2 <= n) {
            Entry entry = (Entry)iterator.next();
            stringBuffer.append(entry.key + "=" + entry.value);
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public synchronized String audit() {
        String string = "";
        int n = this.lruTracker.length();
        if (n != this.count) {
            string = "LRU list length (" + n + ") != count (" + this.count + ")";
        }
        return string;
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new SynchronizedSet(new KeySet(), (Object)this);
        }
        return this.keySet;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new SynchronizedSet(new EntrySet(), (Object)this);
        }
        return this.entrySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new SynchronizedCollection(new ValueCollection(), this);
        }
        return this.values;
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (map.size() != this.size()) {
            return false;
        }
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            Object object2 = entry.getKey();
            Object object3 = entry.getValue();
            if (!(object3 == null ? map.get(object2) != null || !map.containsKey(object2) : !object3.equals(map.get(object2)))) continue;
            return false;
        }
        return true;
    }

    public synchronized int hashCode() {
        int n = 0;
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            n += iterator.next().hashCode();
        }
        return n;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.count);
        int n = this.table.length - 1;
        while (n >= 0) {
            Entry entry = this.table[n];
            while (entry != null) {
                objectOutputStream.writeObject(entry.key);
                objectOutputStream.writeObject(entry.value);
                entry = entry.next;
            }
            --n;
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        int n3 = (int)((float)n2 * this.loadFactor) + n2 / 20 + 3;
        if (n3 > n2 && (n3 & 1) == 0) {
            --n3;
        }
        if (n > 0 && n3 > n) {
            n3 = n;
        }
        this.table = new Entry[n3];
        this.count = 0;
        while (n2 > 0) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
            --n2;
        }
    }

    static class SynchronizedSet
    extends SynchronizedCollection
    implements Set {
        SynchronizedSet(Set set) {
            super(set);
        }

        SynchronizedSet(Set set, Object object) {
            super(set, object);
        }

        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                boolean bl = this.c.equals(object);
                return bl;
            }
        }

        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                int n = this.c.hashCode();
                return n;
            }
        }
    }

    static class SynchronizedCollection
    implements Collection,
    Serializable {
        private static final long serialVersionUID = 3053995032091335093L;
        Collection c;
        Object mutex;

        SynchronizedCollection(Collection collection) {
            if (collection == null) {
                throw new NullPointerException();
            }
            this.c = collection;
            this.mutex = this;
        }

        SynchronizedCollection(Collection collection, Object object) {
            this.c = collection;
            this.mutex = object;
        }

        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                int n = this.c.size();
                return n;
            }
        }

        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                boolean bl = this.c.isEmpty();
                return bl;
            }
        }

        public boolean contains(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                boolean bl = this.c.contains(object);
                return bl;
            }
        }

        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                Object[] objectArray = this.c.toArray();
                return objectArray;
            }
        }

        public Object[] toArray(Object[] objectArray) {
            Object object = this.mutex;
            synchronized (object) {
                Object[] objectArray2 = this.c.toArray(objectArray);
                return objectArray2;
            }
        }

        public Iterator iterator() {
            return this.c.iterator();
        }

        public boolean add(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                boolean bl = this.c.add(object);
                return bl;
            }
        }

        public boolean remove(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                boolean bl = this.c.remove(object);
                return bl;
            }
        }

        public boolean containsAll(Collection collection) {
            Object object = this.mutex;
            synchronized (object) {
                boolean bl = this.c.containsAll(collection);
                return bl;
            }
        }

        public boolean addAll(Collection collection) {
            Object object = this.mutex;
            synchronized (object) {
                boolean bl = this.c.addAll(collection);
                return bl;
            }
        }

        public boolean removeAll(Collection collection) {
            Object object = this.mutex;
            synchronized (object) {
                boolean bl = this.c.removeAll(collection);
                return bl;
            }
        }

        public boolean retainAll(Collection collection) {
            Object object = this.mutex;
            synchronized (object) {
                boolean bl = this.c.retainAll(collection);
                return bl;
            }
        }

        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.c.clear();
            }
        }

        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                String string = this.c.toString();
                return string;
            }
        }
    }

    private class Enumerator
    implements Enumeration,
    Iterator {
        Entry[] table;
        int index;
        Entry entry;
        Entry lastReturned;
        int type;
        boolean iterator;
        private int expectedModCount;

        Enumerator(int n, boolean bl) {
            this.table = Cache.this.table;
            this.index = this.table.length;
            this.entry = null;
            this.lastReturned = null;
            this.expectedModCount = Cache.this.modCount;
            this.type = n;
            this.iterator = bl;
        }

        public boolean hasMoreElements() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            return this.entry != null;
        }

        public Object nextElement() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            if (this.entry != null) {
                Entry entry = this.lastReturned = this.entry;
                this.entry = entry.next;
                return this.type == 0 ? entry.key : (this.type == 1 ? entry.value : entry);
            }
            throw new NoSuchElementException("Cache Enumerator");
        }

        public boolean hasNext() {
            return this.hasMoreElements();
        }

        public Object next() {
            if (Cache.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.nextElement();
        }

        public void remove() {
            if (!this.iterator) {
                throw new UnsupportedOperationException();
            }
            if (this.lastReturned == null) {
                throw new IllegalStateException("Cache Enumerator");
            }
            if (Cache.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Cache cache = Cache.this;
            synchronized (cache) {
                Entry[] entryArray = Cache.this.table;
                int n = (this.lastReturned.hash & Integer.MAX_VALUE) % entryArray.length;
                Entry entry = entryArray[n];
                Entry entry2 = null;
                while (entry != null) {
                    if (entry == this.lastReturned) {
                        Cache.this.modCount++;
                        ++this.expectedModCount;
                        if (entry2 == null) {
                            entryArray[n] = entry.next;
                        } else {
                            entry2.next = entry.next;
                        }
                        Cache.this.count--;
                        this.lastReturned = null;
                        return;
                    }
                    entry2 = entry;
                    entry = entry.next;
                }
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class Entry
    implements Map.Entry {
        int hash;
        Object key;
        Object value;
        Entry next;
        Entry lruNext;
        Entry lruPrev;

        protected Entry(int n, Object object, Object object2, Entry entry) {
            this.hash = n;
            this.key = object;
            this.value = object2;
            this.next = entry;
            this.lruNext = null;
            this.lruPrev = null;
        }

        protected synchronized Object clone() {
            return new Entry(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        protected void changeValues(int n, Object object, Object object2, Entry entry) {
            this.hash = n;
            this.key = object;
            this.value = object2;
            this.next = entry;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            boolean bl;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            if (this.key == null) {
                if (entry.getKey() != null) return false;
                bl = true;
            } else {
                bl = this.key.equals(entry.getKey());
            }
            if (!bl) return false;
            if (this.value == null) {
                if (entry.getValue() != null) return false;
                return true;
            }
            boolean bl2 = this.value.equals(entry.getValue());
            if (!bl2) return false;
            return true;
        }

        public int hashCode() {
            return this.hash ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key.toString() + "=" + this.value.toString();
        }
    }

    private class LRUList {
        Entry header = new Entry(0, null, null, null);

        protected LRUList() {
        }

        protected LRUList(Entry entry) {
            this.header = entry;
        }

        protected void addLast(Entry entry) {
            if (this.header.lruNext == null) {
                this.header.lruNext = this.header.lruPrev = entry;
                entry.lruNext = entry.lruPrev = this.header;
            } else {
                this.header.lruPrev.lruNext = entry;
                entry.lruNext = this.header;
                entry.lruPrev = this.header.lruPrev;
                this.header.lruPrev = entry;
            }
        }

        protected void remove(Entry entry) {
            if (entry == null) {
                return;
            }
            entry.lruPrev.lruNext = entry.lruNext;
            entry.lruNext.lruPrev = entry.lruPrev;
            entry.lruPrev = null;
            entry.lruNext = null;
        }

        protected Entry getFirst() {
            return this.header.lruNext;
        }

        protected Entry getLast() {
            return this.header.lruPrev;
        }

        protected Entry removeFirst() {
            Entry entry = this.header.lruNext;
            this.remove(entry);
            return entry;
        }

        protected void replaceLast(Entry entry) {
            this.remove(entry);
            this.addLast(entry);
        }

        protected int length() {
            int n = 0;
            Entry entry = this.header.lruNext;
            while (entry != this.header) {
                ++n;
                entry = entry.lruNext;
            }
            return n;
        }
    }

    private class ValueCollection
    extends AbstractCollection {
        private ValueCollection() {
        }

        public Iterator iterator() {
            return new Enumerator(1, true);
        }

        public int size() {
            return Cache.this.count;
        }

        public boolean contains(Object object) {
            return Cache.this.containsValue(object);
        }

        public void clear() {
            Cache.this.clear();
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return new Enumerator(2, true);
        }

        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            Entry[] entryArray = Cache.this.table;
            int n = k.hashCode();
            int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry2 = entryArray[n2];
            while (entry2 != null) {
                if (entry2.hash == n && entry2.equals(entry)) {
                    return true;
                }
                entry2 = entry2.next;
            }
            return false;
        }

        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            Entry[] entryArray = Cache.this.table;
            int n = k.hashCode();
            int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry2 = entryArray[n2];
            Entry entry3 = null;
            while (entry2 != null) {
                if (entry2.hash == n && entry2.equals(entry)) {
                    Cache.this.modCount++;
                    if (entry3 != null) {
                        entry3.next = entry2.next;
                    } else {
                        entryArray[n2] = entry2.next;
                    }
                    Cache.this.count--;
                    entry2.value = null;
                    return true;
                }
                entry3 = entry2;
                entry2 = entry2.next;
            }
            return false;
        }

        public int size() {
            return Cache.this.count;
        }

        public void clear() {
            Cache.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public Iterator iterator() {
            return new Enumerator(0, true);
        }

        public int size() {
            return Cache.this.count;
        }

        public boolean contains(Object object) {
            return Cache.this.containsKey(object);
        }

        public boolean remove(Object object) {
            return Cache.this.remove(object) != null;
        }

        public void clear() {
            Cache.this.clear();
        }
    }
}

