/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import com.iplanet.am.util.Debug;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class AMResourceBundleCache {
    private static AMResourceBundleCache instance;
    private HashMap mapBundles = new HashMap(30);
    private Debug debug = Debug.getInstance("amSDK");

    private AMResourceBundleCache() {
    }

    public static AMResourceBundleCache getInstance() {
        if (instance == null) {
            instance = new AMResourceBundleCache();
        }
        return instance;
    }

    public ResourceBundle getResBundle(String string, Locale locale) {
        ResourceBundle resourceBundle = null;
        HashMap<Locale, ResourceBundle> hashMap = (HashMap<Locale, ResourceBundle>)this.mapBundles.get(string);
        if (hashMap != null) {
            resourceBundle = (ResourceBundle)hashMap.get(locale);
        }
        if (resourceBundle == null) {
            try {
                resourceBundle = ResourceBundle.getBundle(string, locale);
            }
            catch (MissingResourceException missingResourceException) {
                this.debug.error("AMResourceBundleCache.getResBundle", missingResourceException);
            }
            HashMap hashMap2 = this.mapBundles;
            synchronized (hashMap2) {
                if (hashMap == null) {
                    hashMap = new HashMap<Locale, ResourceBundle>(5);
                    this.mapBundles.put(string, hashMap);
                }
                hashMap.put(locale, resourceBundle);
            }
        }
        return resourceBundle;
    }

    public void clear() {
        HashMap hashMap = this.mapBundles;
        synchronized (hashMap) {
            this.mapBundles.clear();
        }
    }
}

