#!/usr/bin/perl

# Copyright (c) 2003 Sun Microsystems, Inc. All rights reserved
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.

# moduleProgress.pl - module progress bar
# $Id: moduleProgress.pl,v 1.12 2004/11/09 23:48:55 ms152511 Exp $

use CGI qw(:standard);
use lib '/scs/lib/perl5';
use BDi18n;
use Task;

BDi18n::setDomain('base-mgmt-moduleMgr');
my $server_addr = url( {-base => 1} );
$server_addr    =~ s|^http://([^:]+)|https://$1|;
my $tomcat_url  = $server_addr . ':8443/sdui/mainmenu/index.jsp?mainUrl=/sdui/adminModules.do?method=view';

my $taskId = param('taskId') || 0;
my $task = $taskId?Task::getTask($taskId):0;

# i18n messages
my $title    = BDi18n::getMsg('progressDialogTitle');
my $taskName = BDi18n::getMsg($task->{'name'});
my $taskMsg  = $task->{'message'};
my $waitMsg  = BDi18n::getMsg('pleaseWaitMsg');

print header() . "<html><head><title>$title</title>\n";
if (!$task)
{
  print '</head><body>No task.</body></html>' . "\n";
  exit 0;
}
if ($task->{'status'} eq 'R')
{
  print "<meta http-equiv='REFRESH' content='1;URL=/cgi-bin/moduleProgress.pl?taskId=" . $taskId . "&notFirst=1'>\n";
}
print "</head>\n";

my $isNotFirstLoad = param('notFirst') || 0;
if (!$isNotFirstLoad)
{
  print <<EOD;
    <script language="JavaScript" type="text/javascript">
      <!-- Hide script from older browsers
      self.parent.location=document.location + "&notFirst=1";
      // end hiding contents -->
    </script>
<body></body></html>
EOD
 exit 0;
}

print "<body>\n";
#print $task->{'name'} . ' : ';
my $pct;
if (!$task->{'total_items'})
{
  #print '0%';
  $pct = '0';
}
else
{
  #print int($task->{'items_done'} / $task->{'total_items'} * 100) . '%';
  $pct =  int($task->{'items_done'} / $task->{'total_items'} * 100);
}
# The progress bar image width is up to 200 pixels
my $pctEmptyImgWidth = 100 - $pct;


if ($task->{'status'} ne 'R')
{
  print <<EOD;
    <script language="JavaScript" type="text/javascript">
      <!-- Hide script from older browsers
      self.parent.location='$tomcat_url';
      // end hiding contents -->
    </script>
<body></body></html>
EOD
 exit 0;
}

print <<EOD;

<html>
<head>
  <title>Sun Control Station</title>
  
  
  <link rel="StyleSheet" href="/sdui/sdui.css" type="text/css">
</head>

<body background-color="#F7FAFF">



<center><table border='0' cellspacing='0' cellpadding='0'>
	<tr>
	<td align='right' valign='bottom'><img src='/sdui/images/FrameTopLeftCorner.gif' width='10' height='11' alt='' border='0'></td>
	<td background='/sdui/images/FrameTop.gif'><img src='/sdui/images/FrameTopLeft.gif' width='10' height='11' alt='' border='0'></td>
	<td align='right' background='/sdui/images/FrameTop.gif'><img src='/sdui/images/FrameTopRight.gif' width='10' height='11' alt='' border='0'></td>
	<td><img src='/sdui/images/FrameTopRightCorner.gif' width='10' height='11' alt='' border='0'></td>
	</Tr>

	<tr>
	<td align='right' valign='top' background='/sdui/images/FrameLeft.gif'>
		<img src='/sdui/images/FrameLeftTop.gif' width='10' height='10' alt='' border='0'></td>
		<td colspan='2'><table border='0' bgcolor='#C9E0FD' cellspacing='0' cellpadding='0' width='100%'>
<tr><td width='10'><img src='/sdui/images/empty.gif' width='10'></td><td><div class='Sheet-Title'>Task Progress</div></td></tr><tr><td><img src='/sdui/images/empty.gif' height='4'></td><td></td></tr></table>
	</td><td align='left' valign='top' background='/sdui/images/FrameRight.gif'>
	<img src='/sdui/images/FrameRightTop.gif' width='10' height='10' alt='' border='0'></td></tr>

<tr>
<!-- left border -->
<td align='right' valign='top' background='/sdui/images/FrameLeft.gif'></td>

<!-- center content, label and progress Image -->
<td colspan=2>
<table border='0' bgcolor='#F7FAFF' cellspacing='0' cellpadding='0'>
  <tr>
	<td align='right' width=27>  </td>
	<td width='100'><br><div class='File-Name'>$taskName</div><br></td>
	<td><br><div class='File-Size'>
		<table bgcolor='#F7FAFF' cellpadding=0 cellspacing=0 bgcolor='#F7FAFF' >
		  <tr>
		    <td><img src='/sdui/images/Nav-Progress-Empty-Left.gif'></td>
		    <td>
		      <table bgcolor='#F7FAFF' cellpadding=0 cellspacing=0 border="0" width="200" height="16">
		        <tr>
                          <td NOWRAP background='/sdui/images/Nav-Progress.gif' width="$pct%" ></td>
                          <td NOWRAP background='/sdui/images/Nav-Progress-EmptyPiece.gif' width="$pctEmptyImgWidth%"></td>
                        </tr>
                      </table>
                    </td>
                    <td><img src='/sdui/images/Nav-Progress-Empty-Right.gif'></td>
                    <td> &nbsp; &nbsp;$pct%</td>
                  </tr>
                </table></div><br>
        </td>
	<td align='right' width=27>  </td>
  </tr>
</table>
</td>

<!-- right border -->
<td align='left' valign='top' background='/sdui/images/FrameRight.gif'></td>
</tr>

<tr>
<!-- left border -->
<td align='right' valign='top' background='/sdui/images/FrameLeft.gif'></td>

<!-- center content, label and progress Image -->

<td colspan=2 width=400>
<table border='0' width="100%" bgcolor='#F7FAFF' cellspacing='0' cellpadding='0'>
  <tr>
	<td align='right' width=27>  </td>
	<td><br><div class='File-Name'>&nbsp;$taskMsg</div><br></td>
	<td align='right' width=1>  </td>
	<td align='right' width=27>  </td>
  </tr>

</table>
</td>

<!-- right border -->
<td align='left' valign='top' background='/sdui/images/FrameRight.gif'></td>
</tr>



			<tr><td align='right' valign='top'><img src='/sdui/images/FrameBottomLeftCorner.gif' width='10' height='17' alt='' border='0'></td>
			<td valign='top' background='/sdui/images/FrameBottom.gif'><img src='/sdui/images/FrameBottomLeft.gif' width='10' height='17' alt='' border='0'></td>
			<td align='right' valign='top' background='/sdui/images/FrameBottom.gif'><img src='/sdui/images/FrameBottomRight.gif' width='10' height='17' alt='' border='0'></td>
			<td align='left' valign='top'><img src='/sdui/images/FrameBottomRightCorner.gif' width='10' height='17' alt='' border='0'></td>

</tr>
</table></center>


<table align="center" border="0" width=350 cellspacing='0' cellpadding='4'>
  <tr>
    <td>
      <br><div class='Bold-Text'>$waitMsg<br></div>
    </td>
  </tr>
</table>

</body>
</html>
EOD

print "\n<br></body></html>\n";
