#!/bin/sh

# Copyright (c) 2003 Sun Microsystems, Inc. All rights reserved
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.


#
# Control Module file packager
# $Id: mkModulePkg.sh,v 1.4 2003/09/15 08:35:07 pp122837 Exp $
#

if [ -z "$1" ]; then
  echo "Usage: $0 <name>" # [svr4 pkg version]"
  exit 0
fi

#if [ ! -d /fargo/pacifica/svr4pkgs ]; then
#  echo "Please mount fargo first..."
#  exit 0
#fi

echo '**************************************'
echo '** Creating Control Module ***********'
echo '**************************************'

NAME=$1
echo "Name is "$NAME

if [ -n "$2" ]; then
  SVR4VER=$2
fi

if [ ! -r module-config.xml ]; then
  echo "No module-config.xml found in the current directory."
  exit 0
fi

if [ ! -r struts-config-$NAME.xml ]; then
  echo "No struts-config-$NAME.xml found in the current directory."
  exit 0
fi

if [ ! -r menu-config-$NAME.xml ]; then
  echo "No menu-config-$NAME.xml found in the current directory."
  exit 0
fi

VERSION=`grep "<version " module-config.xml | awk  -F\" {'print $2'}`

if [ -z "$VERSION" ]; then
  echo "Can't find version in module-config.xml"
  exit 0
fi

echo 'Version is '$VERSION

if [ ! -x scripts ]; then
  echo "No scripts dir found, creating blank one"
  mkdir scripts
fi

MAPP_TMP="/tmp/"$NAME
rm -rf $MAPP_TMP
echo 'Using '$MAPP_TMP' directory to build mapp package'
mkdir -p $MAPP_TMP/mgmtStation
echo 'Copying module-config.xml over ...'
cp module-config.xml $MAPP_TMP
echo 'Copying struts-config-'$NAME'.xml over ...'
cp struts-config-$NAME.xml $MAPP_TMP
echo 'Copying menu-config-'$NAME'.xml over ...'
cp menu-config-$NAME.xml $MAPP_TMP
echo 'Copying server side RPMs ...'
cp work/rpmbuild/RPMS/noarch/*.rpm $MAPP_TMP/mgmtStation 2>/dev/null
echo 'Copying install and uninstall scripts ...'
cp -R scripts $MAPP_TMP
X=`ls client/ 2>/dev/null | grep -v CVS | grep -v '\.'`
if [ -z "$X" ]; then
  echo 'No client side packages.'
else
  for i in $X
  do
    if [ -x client/$i/rpms ]; then
      echo "Moving RPMs for "$i" ..."
      mv client/$i/rpms/*.rpm $MAPP_TMP
    else
      if [ -z "$SVR4VER" ]; then
        echo "ERROR: no svr4 pkg version specified"
        exit 0;
      fi
      echo "Copying SVR4 packages for "$i $SVR4VER " ..."
      cp /fargo/pacifica/svr4pkgs/"$NAME"-solaris-scripts-"$SVR4VER".pkg $MAPP_TMP
    fi
  done
fi

cd $MAPP_TMP
echo "Tar'ing it all up ..."
tar zcvf $NAME'-'$VERSION'.mapp' *
cd -
mv $MAPP_TMP/*.mapp .

echo 'All done, the control module is '$NAME'-'$VERSION'.mapp'
