#!/usr/bin/perl -w

# Copyright (c) 2003 Sun Microsystems, Inc. All rights reserved
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.


#
# $Id: agentMgr.pl,v 1.5 2004/08/05 00:02:38 ms152511 Exp $
#

use strict;
use lib '/scs/lib/perl5';

use AgentMgr;
use Appliance;
use BDUtil;
use BDi18n;
use Progress;

Progress::initProgress(\@ARGV);
BDi18n::setDomain('base-mgmt-import');

sub printUsage
{
  print<<EOF;

Usage: $0 [debug] < install | remove > -a <all | <host id 1> [ ... ]>> -m <all | <module id 1 [ ... ]>>

Use moduleMgr.pl instead to perform operations for single modules at a time.

EOF

  exit 0;
}

if (defined($ARGV[0]) && ($ARGV[0] eq 'debug'))
{
  BDUtil::setDebug();
  BDUtil::printDebug('Enabled');
  shift @ARGV;
}

printUsage() if (!defined($ARGV[1]));
my $mode = shift @ARGV;
printUsage() if (($mode ne 'install') && ($mode ne 'remove'));

BDUtil::openLog('agentMgr');

my $applianceList = [];
my $moduleList = [];
my $curList = 0;

foreach my $arg (@ARGV)
{
  if ($arg eq '-a')
  {
    $curList = $applianceList;
  }
  elsif ($arg eq '-m')
  {
    $curList = $moduleList;
  }
  elsif (!$curList)
  {
    printUsage();
  }
  elsif (($arg eq 'all') || ($arg =~ /^[0-9]*$/))
  {
    push (@{$curList}, $arg);
  }
  else
  {
    printUsage();
  }
}

printUsage() if (!defined($applianceList->[0]) || !defined($moduleList->[0]));

if ($applianceList->[0] eq 'all')
{
  $applianceList = Appliance::getAppliances('M');
}

if ($moduleList->[0] eq 'all')
{
  $moduleList = 0;
}

if (!$applianceList || !defined($applianceList->[0]))
{
  Progress::progressComplete('No managed appliances to work on');
  BDUtil::info('No appliances to work on');
  BDUtil::closeLog();
  exit 0;
}

my $numAppliances = (@{$applianceList} + 0);

my $rc;
if ($mode eq 'install')
{
  Progress::setProcessName('Install module components on appliances');
  Progress::setWorkItems(($numAppliances * AgentMgr::getWorkPerAppliance($moduleList)) + 1);
  $rc = AgentMgr::installMode($applianceList, 1, 0, $moduleList);
}
else
{
  Progress::setProcessName('Uninstall module components from appliances');
  Progress::setWorkItems($numAppliances + 2);
  $rc = AgentMgr::removeMode($applianceList, 0, $moduleList);
}

Progress::advanceProgress();

if ($rc < 0)
{
  Progress::progressFailed('Error');
}
elsif ($rc)
{
  Progress::progressWarned('Successful, but there was an error for one or more appliances');
}
else
{
  Progress::progressComplete('Successful for all appliances');
}

BDUtil::closeLog();
