package AgentMgr;

# Copyright (c) 2003 Sun Microsystems, Inc. All rights reserved
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.


#
# $Id: AgentMgr.pm,v 1.5 2004/10/06 22:32:46 ms152511 Exp $
#

#--------------------------------------------------------------------
#
# This is agentMgr.pl's replacement for use by import.  Call
# installMode() for when appliances are added, and removeMode()
# for when appliances are removed.  In both cases the sole argument
# is a reference to a list of appliance ID's to process.
#
#--------------------------------------------------------------------

use strict;
use ImportWork;
use Progress;
use Appliance;
use MAPP;

#
#
#
sub getWorkPerAppliance
{
    my $mappList = shift || 0;

    my ($numMAPPs, $numInitScripts) = MAPP::getNumMAPPs($mappList);

    my $workUnitsPerAppliance = 0;
    ++$workUnitsPerAppliance if ($numMAPPs); # Push / install MAPP pkgs
    $workUnitsPerAppliance += $numInitScripts; # Init scripts

    return $workUnitsPerAppliance;
}


#
#
#
sub installMode
{
    my ($idList, $installMAPPs, $setStatus, $moduleList) = @_;
    return 0 if (!(@{$idList}+0));
    $setStatus = 1 if (!defined($setStatus));
    $moduleList = 0 if (!defined($moduleList));

    my $retCode = 0;

    my ($rc, $applianceList, $mappList, $workUnits) =
        ImportWork::getInstallWork(MAPP::getApplianceBuilds($idList),
                                   $moduleList);
    return -1 if ($rc);
    my $numInitScripts = @{$mappList}+0;
    my $baseSchedules = MAPP::getApplianceSchedules('');
    my ($appliance, $mapp);

    if (!$workUnits && $setStatus) {
        return 0;
    }

  
    BDUtil::info('Setting appliance install stati to not installed');
    my (%pkgDone, $pkg);
    foreach $appliance (@{$applianceList}) {
        %pkgDone = ();
        foreach $pkg (@{$appliance->{'pkgs'}}) {
            if (!exists($pkgDone{$pkg->{'mapp_client_rpm_id'}})) {
                return BDUtil::dbError(-1)
                    if (!MAPP::addInstalledApplication($pkg->{'mapp_client_rpm_id'},
                                                       $appliance->{'appliance_id'},
                                                       'F', ''));
                $pkgDone{$pkg->{'mapp_client_rpm_id'}} = 1;
            }
        }
    }

    if ($installMAPPs) {
        my @successfulAppliances = ();
        Progress::setMessage(BDi18n::getMsg('installingMAPPComponents'));
        foreach $appliance (@{$applianceList}) {
            $rc = ImportWork::installPkgsOnAppliance($appliance, $appliance->{'pkgs'});
            return -1 if ($rc < 0);
            if ($rc) {
                $retCode = 1;
                Progress::advanceProgress(1 + $numInitScripts);
            } else {
                push(@successfulAppliances, $appliance);
                foreach $mapp (@{$mappList}) {
                    if ($mapp->{'schedules'}) {
                        BDUtil::info('Adding appliance id = ' . $appliance->{'appliance_id'}
                                     . ' to ' . $mapp->{'mapp_name'} . ' schedules');
                        return -1
                            if (MAPP::addApplianceToSchedules(
                                                              $appliance->{'appliance_id'}, $mapp->{'schedules'}));
                    }
                }
                if ($baseSchedules) {
                    BDUtil::info('Adding appliance id = ' . $appliance->{'appliance_id'}
                                 . ' to base station schedules');
                    return -1
                        if (MAPP::addApplianceToSchedules(
                                                          $appliance->{'appliance_id'}, $baseSchedules));
                }
                Progress::advanceProgress(1);
            }
        }

        # init scripts will advance the progress bar 1 unit
        # per appliance.
        foreach $mapp (@{$mappList}) {
            $mapp->{'appliances'} = \@successfulAppliances;
        }
        $rc = ImportWork::runScripts($mappList, 'init');
        return -1 if ($rc);
    }

    return $retCode;
}

#
#
#
sub removeMode
{
    my $idList = shift;
    return 0 if (!(@{$idList}+0));
    my $setStatus = shift;
    $setStatus = 1 if (!defined($setStatus));
    my $moduleList = shift || 0;

    my $retCode = 0;

    my ($rc, $applianceList, $mappList, $workUnits) =
        ImportWork::getRemoveWork(MAPP::getApplianceBuilds($idList),
                                  $moduleList);
    return -1 if ($rc);

    $rc = ImportWork::runScripts($mappList, 'cleanup');
    Progress::advanceProgress(1);

    foreach my $appliance (@{$applianceList}) {
        if ($appliance->{'pkgs'} && (@{$appliance->{'pkgs'}}+0)) {
            $rc = ImportWork::uninstallPkgsOnAppliance($appliance,
                                                       $appliance->{'pkgs'});
            return -1 if ($rc == -1);
            $retCode = 1 if ($rc);
        }

        if ($setStatus) {
            return -1
                if (Appliance::setApplianceStatus($appliance->{'appliance_id'}, 'D'));
        }
        Progress::advanceProgress(1);
    }

    return $retCode;
}

1;
