#!/bin/sh
# $Id: updateIP.sh,v 1.3.8.1 2005/08/30 19:04:40 ms152511 Exp $
# updateIP - Inserts information about the control station network
#            configuration into the appropriate files.
#            This script should be run whenever the control station
#            hostname or IP address changes.
# Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.

TOMCATROOT=/var/tomcat4

#
# fuctions
#

errorExit() {
   echo "ERROR: $@!" 1>&2;
   exit 1;
}

printInfo() {
   echo "Info: $@";
}

printWarn() {
   echo "WARN: $@";
}

#
# find control station hostname and IP addresses
#
printInfo "Determining hostname and IP addresses"
HOSTNAME=`hostname`
CSHOSTADDRS="'$HOSTNAME',"`LC_ALL=C /sbin/ifconfig -a | sed '/inet /!d;s/[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}/[&]/;s/^.*\[//;s/\].*$//;/^127.0.0./d;/^0.0.0./d' | awk "{ IPs = IPs \"'\" \\\$0 \"',\" } END{ print substr(IPs, 1, length(IPs) - 1) }"`
printInfo "This control station has the following addresses:"
printInfo $CSHOSTADDRS

#
# fix the hostname in the httpd.conf
#
printInfo "Updating httpd.conf"
[ -r $TOMCATROOT/conf/httpd.conf.orig ] || \
    errorExit "Can not read from $TOMCATROOT/conf/httpd.conf.orig"
sed "s/^ServerName localhost$/ServerName $HOSTNAME/" \
    "$TOMCATROOT/conf/httpd.conf.orig" > "$TOMCATROOT/conf/httpd.conf" || \
    errorExit "Could not write to $TOMCATROOT/conf/httpd.conf"

#
# fill in and publish host installation script
#
printInfo "Updating hostinstall.pl"
[ -r $TOMCATROOT/web/pub/hostinstall.pl.orig ] || \
    errorExit "Can not read from $TOMCATROOT/web/pub/hostinstall.pl.orig"
sed "s/@CSHostAddrs *= *( '__CONTROLSTATION__' );/@CSHostAddrs  = ( $CSHOSTADDRS );/" \
    "$TOMCATROOT/web/pub/hostinstall.pl.orig" > "$TOMCATROOT/web/pub/hostinstall.pl" || \
    errorExit "Could not write to $TOMCATROOT/web/pub/hostinstall.pl"
