#!/usr/bin/perl -w

# Copyright (c) 2003 Sun Microsystems, Inc. All rights reserved
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.


use strict;
use lib '/scs/lib/perl5';
use BDDB;
use SCSConfig;
use SysCmd;
use PropertyUtil;

my $mail_cmd = PropertyUtil::getProperty('cmd.mail');
my $regEmail = 'scs_registration@sun.com';

my @params = ( 'First name', 'Last name', 'Organization', 'Country', 'Job function', 'Phone', 'Email address');

if ($#ARGV < 6) {
  print STDERR<<EOD;

Usage: $0 <firstname> <lastname> <organization> <country> <jobfunction> <phone> <email>

EOD
  exit 1;
}

my $mailFile =  '/tmp/regMail.' . $$;
if (!open (MAILFILE, '>' . $mailFile))
{
  exit 1;
}
my ($lN, $fN);
foreach my $p (@params)
{
  $a = substr(shift @ARGV || '_', 0);
  $a =~ s/^_//;
  $lN = $a if ($p eq 'Last name');
  $fN = $a if ($p eq 'First name');
  print MAILFILE sprintf("%-20s : %s\n", $p, $a);
}
print MAILFILE sprintf("\n%-20s : %s\n", 'Operating system',
                                         SysCmd::runCmd('uname', '-a'));
print MAILFILE sprintf("%-20s : %s\n", 'Software version',
                                       SysCmd::runCmd('cat', '/etc/build'));
print MAILFILE sprintf("%-20s : %s\n", 'Serial Number',
                                       SCSConfig::getSerialNumber());
print MAILFILE sprintf("%-20s : %s\n", 'Managed hosts', BDDB::getResult("select count(*) from mgmt_appliance where status='M'"));

close (MAILFILE);

my $subject = $lN . ', ' . $fN . ' - Sun Control Station Registration';

my $cmd = $mail_cmd . ' -s "' . $subject . '" ' . $regEmail
        . ' -- -f "Sun Control Station" < ' . $mailFile;

system($cmd);
unlink($mailFile);

