#!/usr/bin/perl

use lib '/scs/lib/perl5';
use strict;
use Notification;

usage() if not defined $ARGV[0];

my $action = shift @ARGV;

# add listener
if ($action eq  '-a') {
    add_listener(@ARGV);
} elsif ($action eq '-d') {
    remove_listener(@ARGV);
} elsif ($action eq '-p') {
    post_notification(@ARGV);
} elsif ($action eq '-k') {
    acknowledge_notification(@ARGV);
} else {
    usage();
}

sub add_listener (@)
{
    my ($notification_type,$name,$description,$callback_cmd) = @_;

    my $rc = Notification::add_listener($notification_type,$name,$description,$callback_cmd);
    die "add_listener failed" if ($rc < 0);
    print "Added as listener_id = $rc.\n";
}

sub remove_listener (@)
{
    my ($listener_id) = @_;

    my $rc = Notification::remove_listener($listener_id);
    die "remove_listener failed" if ($rc < 0);
    print "Removed listener_id $listener_id.\n";
}

sub post_notification (@)
{
    my ($notification_type,$description,$data,$callback_cmd,$callback_type) = @_;

    my $rc = Notification::post_notification($notification_type,$description,$data,$callback_cmd,$callback_type);
    die "post_notification failed" if ($rc < 0);
    print "Posted notification to $rc listeners.\n";
}

sub acknowledge_notification (@)
{
    my ($post_id, $listener_id) = @_;

    my $rc = Notification::acknowledge_notification($post_id,$listener_id);
    die "acknowledge_notification failed" if ($rc < 0);
    print "Listener $listener_id acknowledged notification $post_id.";
}

sub usage ()
{
    my $errorMsg = $_[0];

    print "\nERROR: $errorMsg\n" if (defined $errorMsg);

    print STDERR<<EOUSAGE;

Usage: $0 [debug] <mode> [parameters]

Modes:
------
 -a <notification_type> <listener name> <description> <callback>
    Register a listener for notification_type.
 -d <listener_id>
    Unregister a listener.
 -p <notification_type> <description> <data> <callback> <callback_type>
    Post a notification to listeners registered for notification_type.
 -k <post_id> <listener_id>
    Acknowledge notification post_id directed toward listener_id.
EOUSAGE

  exit 0;
}
