#!/usr/bin/perl
#
#
#  Module notifications tables
#  Copyright 2004 Sun Microsystems, Inc. All rights reserved.
#

use lib '/scs/lib/perl5';
use strict;
use SCSDB;

exit (1) if (SCSDB::mkTable('mgmt_notification_listeners',
    'listener_id           serial          PRIMARY KEY',
    'name                  varchar(127)    NOT NULL',
    'description           varchar(255)',
    'notification_type     varchar(127)    NOT NULL',
    'callback_cmd          varchar(511)    NOT NULL'));

exit (1) if (SCSDB::mkTable('mgmt_posted_notifications',
    'post_id               serial          PRIMARY KEY',
    'notification_type     varchar(127)    NOT NULL',
    'description           varchar(255)',
    'data                  varchar(511)',
    'post_time             timestamp       NOT NULL',
    "callback_cmd          varchar(511)    CHECK (CASE WHEN callback_type='NONE' THEN callback_cmd IS NULL " .
			                              'ELSE callback_cmd IS NOT NULL ' .
			                         'END)',
    "callback_type         varchar(15)     NOT NULL CHECK (callback_type='NONE' OR callback_type='AFTER_EACH' OR callback_type='AFTER_ALL')"));

exit (1) if (SCSDB::mkTable('mgmt_notified_listeners',
    'post_id               integer         REFERENCES mgmt_posted_notifications (post_id)',
    'listener_id           integer         REFERENCES mgmt_notification_listeners (listener_id) ON DELETE CASCADE',
    'acknowledged          boolean         NOT NULL DEFAULT FALSE',
    'ack_time              timestamp',
    'PRIMARY KEY (post_id, listener_id)'));
