#!/usr/bin/perl -w
# $Id: 014_set_serial_num.pl,v 1.2.8.1 2005/04/22 20:08:46 ms152511 Exp $
# 014_set_serial_num.pl - set the station serial number
# Copyright 2004 Sun Microsystems, Inc., All rights reserved.
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
#
# WARNING: Can't run with -T because we need to autoload in eval
#

use lib '/scs/lib/perl5';
use strict;

use SCSConfig;

my $LINE = "";
my $HASH = "";

$ENV{'PATH'} = "/sbin:/bin:/usr/bin:/usr/sbin";
delete @ENV{'IFS', 'CDPATH', 'ENV', 'BASH_ENV'};

exit (1) unless (open(IFCONFIG,"LC_ALL=C /sbin/ifconfig -a|"));

while (<IFCONFIG>) {
    $LINE .= $_ if (/(?:hwaddr)|(?:ether)/i);
}
close(IFCONFIG);

exit (1) unless ($LINE ne "");

$HASH = &doHash($LINE);

exit (1) if ($HASH eq "" || 
	     SCSConfig::setConfig('mgmt_serial_no', $HASH));

exit (0);

#
# subroutines
#

sub doHash
{
    my $hashCmd = 'use Digest::MD5 qw(md5 md5_hex md5_base64);';
    $hashCmd .= " md5_hex('@_'); ";
    
    my $hash = eval $hashCmd ;
    if ($@ || !(defined($hash) && $hash ne "")) {
	$hashCmd = 'use Digest::SHA1 qw(sha1 sha1_hex sha1_base64);';
	$hashCmd = " sha1_hex('@_'); ";
	$hash = eval $hashCmd ;
    }

    return ($@ || !(defined($hash) && $hash ne "") ? "" : $hash);
}

