#!/usr/bin/perl -w
# $Id: 010_mgmt_tables.pl,v 1.11 2004/10/05 17:31:59 ms152511 Exp $
# 010_mgmt_tables.pl - perl script to add the mgmt tables
# Copyright 2004 Sun Microsystems, Inc., All rights reserved.
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.

use lib '/scs/lib/perl5';
use strict;
use SCSDB;

#
# Alerts 
#

exit (1) if (SCSDB::mkTable('mgmt_alerts',
			   'message varchar(255) NOT NULL',
			   'url     varchar(255) NOT NULL',
			   'img     varchar(255) NOT NULL',
                           'UNIQUE(url)'));

#
# Appliance status
#

exit (1) if (SCSDB::mkTable('mgmt_appliance_status',
                            'status              varchar(2)   PRIMARY KEY',
                            'description         varchar(255)',
                            'icon_url            varchar(255)'));

#
# Builds
#

exit (1) if (SCSDB::mkTable('mgmt_build',
			   'build_id    serial       PRIMARY KEY',
			   'build_type  varchar(64)  NOT NULL',
			   'build_class varchar(128) NOT NULL',
			   'UNIQUE(build_type, build_class)'));

#
# Appliance
#

exit (1) if (SCSDB::mkTable('mgmt_appliance',
                            'appliance_id serial       PRIMARY KEY',
                            'ip_address   varchar(64)  NOT NULL',
                            'host_name    varchar(256)',
                            "mac_address  char(20)     DEFAULT 'ff:ff:ff:ff:ff:ff'",
                            'build_id     integer      DEFAULT 1 REFERENCES mgmt_build',
                            "status       varchar(2)   NOT NULL DEFAULT 'U' REFERENCES mgmt_appliance_status",
                            'reason       varchar(255)',
                            'email_addr   varchar(255)',
                            'username     varchar(64)',
                            'password     varchar(64)',
                            'description  text',
                            'modtime      timestamp    NOT NULL DEFAULT CURRENT_TIMESTAMP',
                            "fingerprint  char(47)     NOT NULL DEFAULT 'ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff'"));

#
# Backup paths
#

exit (1) if (SCSDB::mkTable('mgmt_backup_path',
			   'backup_path_id serial       PRIMARY KEY',
			   'mapp_id        integer      NOT NULL',
			   'backup_path    varchar(255) NOT NULL'));

# 
# MAPPs (modules)
#

exit (1) if (SCSDB::mkTable('mgmt_mapp',
                            'mapp_id        serial       PRIMARY KEY',
                            'mapp_name      varchar(128) UNIQUE NOT NULL',
                            'version        varchar(16)  NOT NULL',
                            'vendor         varchar(128) NOT NULL',
                            'name_tag       varchar(128) NOT NULL',
                            'version_tag    varchar(128) NOT NULL',
                            'vendor_tag     varchar(128) NOT NULL',
                            'update_bool    char(1)      NOT NULL',
                            'init_script    varchar(255) NOT NULL',
                            'cleanup_script varchar(255) NOT NULL',
                            'install_time   timestamp    NOT NULL ' .
                                                        'DEFAULT CURRENT_TIMESTAMP',
                            'status         char(2)      NOT NULL',
                            "CHECK(update_bool in ('Y', 'N'))"));

#
# MAPP client side pkgs
#

exit (1) if (SCSDB::mkTable('mgmt_mapp_client_rpm',
                            'mapp_client_rpm_id serial       PRIMARY KEY',
                            'mapp_id            integer      NOT NULL REFERENCES mgmt_mapp',
                            'build_id           integer      NOT NULL REFERENCES mgmt_build',
                            'rpm_name           varchar(255) NOT NULL',
                            'path_info          varchar(255) NOT NULL',
                            'status             char(2)      NOT NULL',
                            'UNIQUE (mapp_id,build_id,rpm_name)'));


#
# MAPP server side pkgs
#

exit (1) if (SCSDB::mkTable('mgmt_mapp_server_rpm',
                            'mapp_server_rpm_id serial       PRIMARY KEY',
                            'mapp_id            integer      NOT NULL REFERENCES mgmt_mapp',
                            'rpm_name           varchar(255) NOT NULL',
                            'pkg_type           varchar(16)  NOT NULL',
                            'UNIQUE (mapp_id,rpm_name)'));

#
# MAPP installed pkgs 
#

exit (1) if (SCSDB::mkTable('mgmt_installed_rpm',
                            'installed_rpm_id   serial  PRIMARY KEY',
                            'mapp_client_rpm_id integer NOT NULL REFERENCES mgmt_mapp_client_rpm',
                            'appliance_id       integer NOT NULL REFERENCES mgmt_appliance ON DELETE CASCADE',
                            'status             char(1) NOT NULL',
                            "reason             text    NOT NULL DEFAULT ''",
                            'UNIQUE (appliance_id,mapp_client_rpm_id)'));

#
# MAPP icons
#

exit (1) if (SCSDB::mkTable('mgmt_appliance_icon',
                            'appliance_icon_id serial       PRIMARY KEY',
                            'mapp_id           integer      NOT NULL',
                            'icon              varchar(128) NOT NULL',
                            'description       varchar(255) NOT NULL',
                            'target_url        varchar(255) NOT NULL'));

#
# MAPP deny
#

exit (1) if (SCSDB::mkTable('mgmt_deny_mapp',
                            'deny_mapp_id serial       PRIMARY KEY',
                            'mapp_name    varchar(128) NOT NULL',
                            'max_version  varchar(16)  NOT NULL'));

#
# Appliance view
#

exit (1) if (SCSDB::mkTable('mgmt_view',
                            'view_id          serial       PRIMARY KEY',
                            'view_name        varchar(128) NOT NULL UNIQUE CHECK (char_length(view_name) > 0)',
                            'view_description varchar(255) NOT NULL'));

#
# View to appliance
#

exit (1) if (SCSDB::mkTable('mgmt_view_to_appliance',
                            'view_id          integer      REFERENCES mgmt_view      ON DELETE CASCADE',
                            'appliance_id     integer      REFERENCES mgmt_appliance ON DELETE CASCADE',
                            'PRIMARY KEY (view_id, appliance_id)'));

#
# Config
#

exit (1) if (SCSDB::mkTable('mgmt_config',
                            'name      varchar(64) PRIMARY KEY',
                            'value     text        NOT NULL'));

exit (0);
