#!/usr/bin/perl -w
# $Id: SCSConfig.pm,v 1.3 2004/09/18 20:18:27 sv122840 Exp $
# SCSConfig.pm - scs global configuration access
# Copyright 2004 Sun Microsystems, Inc., All rights reserved.
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.

package SCSConfig;

use strict;
use lib '/scs/lib/perl5';

use SCSDB;

#
# globals
#

my $STMT_setConfigSelect = 0; 
my $STMT_setConfigInsert = 0;
my $STMT_getConfig = 0; 

my %SCSPROPS = ( 'SNUM'       => 'mgmt_serial_no',
		 'HTTP_PROXY' => 'mgmtHttpProxyServer',
		 'FTP_PROXY'  => 'mgmtFtpProxyServer' );
#
# Subroutines
#
# setConfig ($name, $value);
# getConfig ($name);
#

#
# setConfig
#
# sets the given name to the given value
#

sub setConfig
{
    my $name = shift @_;
    return SCSDB::errorCode('EPARM', 'Name is null')
	unless (defined($name) && $name ne "");

    my $value = shift @_;
    $value = "" unless (defined($value));

    my $sql = "";

    unless ($STMT_setConfigSelect) {
	$sql = 'SELECT name FROM mgmt_config WHERE name = ? ';
	$sql .= 'FOR UPDATE';
	$STMT_setConfigSelect = SCSDB::prepareStmt($sql);
	return SCSDB::errorCode('EDBERR', "Cannot prepare '$sql'")
	    unless($STMT_setConfigSelect);
    }

    unless ($STMT_setConfigInsert) {
	$sql = 'INSERT INTO mgmt_config (name, value) VALUES(?, ?)';
	$STMT_setConfigInsert = SCSDB::prepareStmt($sql);
	return SCSDB::errorCode('EDBERR', "Cannot prepare '$sql'")
	    unless($STMT_setConfigInsert);
    }

    &SCSDB::startTxn();

    my $selectedName = 0;    
    my $rc = 0;
    
    eval {
	$selectedName = SCSDB::getResult($STMT_setConfigSelect, $name);

	if (defined($selectedName) && $selectedName ne "" &&
	    $selectedName ne "0") {
	    $sql = "UPDATE mgmt_config SET value = '$value' ";
	    $sql .= "WHERE name = '$name'";
	    $rc = SCSDB::runCommand($sql);
	} else {
	    $rc = SCSDB::executeStmt($STMT_setConfigInsert, 
				     $name, 
				     $value);
	}

	$rc = ($rc ? SCSDB::rollBack() : SCSDB::commit());
    };
    
    if ($@) {
	eval {
	    &SCSDB::rollBack();
	};
	return SCSDB::errorCode('EDBERR', 'Error setting config');
    }

    return SCSDB::errorCode('OKAY');
}

#
# getConfig
#
# returns the value for a given name
#

sub getConfig
{
    my $name = shift @_;
    return "" unless (defined($name) && $name ne "");
    
    unless ($STMT_getConfig) {
	my $sql = 'SELECT value FROM mgmt_config WHERE name = ?';
	$STMT_getConfig = SCSDB::prepareStmt($sql);
	return "" unless ($STMT_getConfig);      
    }
    
    return SCSDB::getResult($STMT_getConfig, $name);
}

#
# getSerialNumber
#
# returns the mgmt station's serial number
#

sub getSerialNumber
{
    return getConfig($SCSPROPS{'SNUM'});
}

#
# setHttpProxy
#
# sets the global http proxy url
#

sub setHttpProxy
{
    my $proxy = shift @_;
    return SCSDB::errorCode('EPARM', 'Http Proxy Url is null!')
	unless (defined($proxy) && $proxy ne "");

    $proxy = "http://$proxy" unless ($proxy =~ /^(http:\/\/)?/);

    return setConfig($SCSPROPS{'HTTP_PROXY'}, $proxy);
}

#
# getHttpProxy
#
# returns the global http proxy url
#

sub getHttpProxy
{
    return getConfig($SCSPROPS{'HTTP_PROXY'});
}

#
# setFtpProxy
#
# sets the global ftp proxy url
#

sub setFtpProxy
{
    my $proxy = shift @_;
    return SCSDB::errorCode('EPARM', 'Ftp Proxy Url is null!')
	unless (defined($proxy) && $proxy ne "");
    
    $proxy = "http://$proxy" unless ($proxy =~ /^(http:\/\/)?/);
    
    return setConfig($SCSPROPS{'FTP_PROXY'}, $proxy);
}

#
# getFtpProxy
#
# returns the globabl ftp proxy url
#

sub getFtpProxy
{
    return getConfig($SCSPROPS{'FTP_PROXY'});
}

1;
