package PropertyUtil;

# Copyright (c) 2003 Sun Microsystems, Inc. All rights reserved
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.

use strict;

# WARNING: the module uses ErrorUtil which uses LogUtil which uses PropertyUtil.
# It would be nice to break this cycle but I don't see any way around it for
# now.
use lib '/scs/lib/perl5';
use ErrorUtil;
use SCSUtil;

my $genericStr = 'generic';

# OS specific properties.  The generic list is used for properties that
# are common in all operating systems.
my %propertyList = (
  'redhat' => {
  },
  'solaris' => {
    'dir.sql.exe' => '/opt/sfw/mysql/bin',
    'dir.mysql.sock' => '/tmp',

    'cmd.echo.esc' => 'echo',
    'cmd.echo.nonewline' => '/usr/ucb/echo -n',
    'cmd.mkdir'    => '/usr/bin/mkdir',
    'cmd.rm'       => '/usr/bin/rm',
    'cmd.mv'       => '/usr/bin/mv',
    'cmd.ping'     => '/usr/sbin/ping',
    'cmd.chmod'    => '/usr/bin/chmod',
    'cmd.chown'    => '/usr/bin/chown',
    'cmd.grep'     => '/usr/bin/grep',
    'cmd.cp'       => '/usr/bin/cp',
    'cmd.mail'     => '/usr/bin/mail',
    'cmd.ps'       => '/usr/bin/ps',
    'cmd.wget'     => '/usr/local/bin/wget',
    'cmd.cat'      => '/usr/bin/cat',
    'cmd.killall'  => '/usr/bin/pkill',
    'cmd.ln'       => '/usr/bin/ln',
    'cmd.touch'    => '/usr/bin/touch',
    'cmd.awk'      => '/usr/bin/awk',
    'cmd.uname'    => '/usr/bin/uname',
    'cmd.ls'       => '/usr/bin/ls',
    'cmd.useradd'  => '/usr/sbin/useradd',
    'cmd.groupadd' => '/usr/sbin/groupadd'
  },
  'suse'    => {
  },
  'generic' => {
    'dir.base'     => '/scs',              # main scs directory.
    'dir.backups'  => '/scs/backups',      # backup files
    'dir.bin'      => '/scs/bin',          # binary files.
    'dir.data'     => '/scs/data',         # directory for misc module data.
    'dir.etc'      => '/scs/etc',          # config releated files
    'dir.lib'      => '/scs/lib',          # 
    'dir.perl'     => '/scs/lib/perl5',    # perl modules
    'dir.sql'      => '/scs/lib/sql',      # sql files
    'dir.libexec'  => '/scs/libexec',      # 
    'dir.logs'     => '/scs/logs',         # directory for all log files.
    'dir.sbin'     => '/scs/sbin',         # perl libs    
    'dir.db'       => '/scs/db',
    'dir.csadminhome' => '/var/csadmin',
    
    'dir.tmp'        => '/var/tmp',
    'dir.sql.exe'    => '/usr/bin',
    'dir.mysql.sock' => '/var/lib/mysql',
    
    'cmd.at'       => '/usr/bin/at',
    'cmd.atrm'     => '/usr/bin/atrm',
    'cmd.awk'      => '/bin/awk',
    'cmd.cat'      => '/bin/cat',
    'cmd.chmod'    => '/bin/chmod',
    'cmd.chown'    => '/bin/chown',
    'cmd.cksum'    => '/usr/bin/cksum',
    'cmd.cp'       => '/bin/cp',
    'cmd.crontab'  => '/usr/bin/crontab',
    'cmd.echo'     => 'echo',
    'cmd.echo.esc' => 'echo -e',
    'cmd.echo.nonewline' => 'echo -n',
    'cmd.find'     => '/usr/bin/find',
    'cmd.grep'     => '/bin/grep',
    'cmd.killall'  => '/usr/bin/killall',
    'cmd.kill'     => '/usr/bin/kill',
    'cmd.ln'       => '/bin/ln',
    'cmd.ls'       => '/bin/ls',
    'cmd.mail'     => '/bin/mail',
    'cmd.mkdir'    => '/bin/mkdir',
    'cmd.mv'       => '/bin/mv',
    'cmd.ping'     => '/bin/ping',
    'cmd.ps'       => '/bin/ps',
    'cmd.rm'       => '/bin/rm',
    'cmd.scp'      => '/usr/bin/scp',
    'cmd.ssh'      => '/usr/bin/ssh',
    'cmd.ssh-keygen'       => '/usr/bin/ssh-keygen',
    'cmd.ssh-keyscan'      => '/usr/bin/ssh-keyscan',
    'cmd.touch'    => '/bin/touch',
    'cmd.uname'    => '/bin/uname',
    'cmd.uuencode' => '/usr/bin/uuencode',
    'cmd.wc'       => '/usr/bin/wc',
    'cmd.wget'     => '/usr/bin/wget',
    'cmd.useradd'  => '/usr/sbin/useradd',
    'cmd.groupadd' => '/usr/sbin/groupadd',

    'cmd.pe'       => '/usr/mgmt/sbin/pe',
    'cmd.pkgMgr'   => '/usr/mgmt/libexec/pkgMgr.pl',
    
    'file.build'         => '/etc/build',
    'file.privatekey'    => '/scs/etc/ssh/csid_rsa',
    'file.publickey'     => '/scs/etc/ssh/csid_rsa.pub',
    'file.knownhosts'    => '/scs/etc/ssh/ssh_known_hosts',
    'email.registration' => 'scs_registration@sun.com'
  }
);

#
# Look up the given property in the property list.  Use the os specific
# property if it exists.
#
sub getProperty
{

  # Get the property name
  my $propertyName = shift;

  # validate we have a parameter
  if ( !defined($propertyName) )
  {
    ErrorUtil::setError('No propertyName specified in getProperty()');
    return;
  }

  # Get the os
  my $os = SCSUtil::getOS();
  return if ( !defined($os) );

  # Attempt to get the os specific property.
  if ( exists( $propertyList{$os}->{$propertyName} ) )
  {
    return $propertyList{$os}->{$propertyName};
  }

  # Attempt to get the generic property.
  if ( exists( $propertyList{$genericStr}->{$propertyName} ) )
  {
    return $propertyList{$genericStr}->{$propertyName};
  }

  ErrorUtil::setError(
    "Undefined property: os=" . $os . " property=" . $propertyName );
  return;
}

1;
