package LogUtil;

# Copyright (c) 2003 Sun Microsystems, Inc. All rights reserved
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.

use strict;

# Warning: adding the following line we get a cyclical include.
use lib '/scs/lib/perl5';

#use PropertyUtil;

my $logFile   = 0;
my $startTime = time();

#
# Log the given error message to the log file.
#
sub logError
{
  my $errorStr = shift || '';
  if ($logFile)
  {
    printf $logFile "%3d ERROR    : %s\n", ( time() - $startTime ), $errorStr;
  }
}

#
# Log the given warning message to the log file.
#
sub logWarning
{
  my $warningStr = shift || '';
  if ($logFile)
  {
    printf $logFile "%3d WARNING  : %s\n", ( time() - $startTime ), $warningStr;
  }
}

#
# Log the given info message to the log file.
#
sub logInfo
{
  my $infoStr = shift || '';

  if ($logFile)
  {
    printf $logFile "%3d INFO     : %s\n", ( time() - $startTime ), $infoStr;
  }
}

#
# Open the named log file.
#
sub openLog
{
  my $moduleName = shift || 'mgmt';
  my $logPath    = PropertyUtil::getProperty('dir.logs');

  return if ( exists( $ENV{'TERM'} ) && ( !exists( $ENV{'WANT_LOG'} ) ) );

  # validate the variables.
  if ( !defined($logPath) )
  {
    print STDERR 'ERROR: Property dir.logs is undefined.\n';
    return -1;
  }

  # Generate the log file name and open it.
  system( PropertyUtil::getProperty('cmd.mkdir') . $logPath )
    if ( !-d $logPath );
  my ( $sec, $min, $hour, $mday, $mon, $year ) = localtime( time() );
  my $fileName = $logPath . '/'
    . sprintf(
    "%4d-%02d-%02d_%02d:%02d:%02d_%s.log",
    ( $year + 1900 ),
    ( $mon + 1 ),
    $mday, $hour, $min, $sec, $moduleName
    );
  if ( !open( LOG_FILE, '>' . $fileName ) )
  {
    print STDERR 'ERROR: Could not open log file : ' . $fileName . "\n";
    return -1;
  }

  $logFile = \*LOG_FILE;
  logInfo( '***** ' . $fileName . ' *****' );
  return 0;
}

#
# Close the open log file.
#
sub closeLog
{
  if ($logFile)
  {
    info( '**** Closing log, time is ' . time() . ' *****' );
    close($logFile);
  }
}

1;
