package I18nUtil;

# Copyright (c) 2003 Sun Microsystems, Inc. All rights reserved
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.

use strict;

my $domainName = '';
my $lastDomain = '';

my $propertiesFilePath = '/var/tomcat4/webapps/sdui/WEB-INF/classes';

my $tagHash = 0;

#
# setDomain
#
sub setDomain
{
  $lastDomain = $domainName;
  $domainName = shift || '';
  $domainName .= '.' if ( $domainName ne '' );
}

#
# restoreLastDomain
#
sub restoreLastDomain
{
  $domainName = $lastDomain;
}

#
#
#
sub getMsg
{
  my $tag  = shift;
  my $args = shift || 0;

  return interpolate( $tag, $args );
}

#
#
#
sub getSimpleMsg
{
  return interpolate(@_);
}

#
#
#
sub reloadTags
{
  $tagHash = 0;
}

#
#
#
sub interpolate
{
  my $t    = shift;
  my $args = shift || 0;

  readTags() if ( !$tagHash );
  my $tag;

  $t =~ s/^\[\[//;
  $t =~ s/\]\]$//;
  if ( $t !~ /\./ )
  {
    $tag = $domainName . $t;
  }
  else
  {
    $tag = $t;
  }

  return $tag             if ( !exists( $tagHash->{$tag} ) );
  return $tagHash->{$tag} if ( !$args );

  my $r = $tagHash->{$tag};

  if ( ref($args) eq 'HASH' )
  {
    foreach my $k ( keys %{$args} )
    {
      if ( defined( $args->{$k} ) )
      {
        $r =~ s/\[\[VAR\.$k\]\]/$args->{$k}/g;
        $r =~ s/\[$k\]/$args->{$k}/g;
      }
    }
  }
  elsif ( ref($args) eq 'ARRAY' )
  {
    my $n = 0;
    foreach my $x ( @{$args} )
    {
      $r =~ s/\{$n\}/$x/g;
      ++$n;
    }
  }

  return $r;
}

#
#
#
sub readTags
{
  return if ( !opendir( XD, $propertiesFilePath ) );
  my @files = readdir(XD);
  close(XD);
  my ( $line, @toks );
  $tagHash = {};
  foreach my $f (@files)
  {
    next if ( $f =~ /^\./ ) || ( $f !~ /\.properties$/ );
    next if ( !open( TF, $propertiesFilePath . '/' . $f ) );

    #print 'Reading ' . $f . "\n";
    while ( $line = <TF> )
    {
      chomp($line);
      next if ( ( $line =~ /^[\r\t\n ]*$/ ) || ( $line =~ /^#/ ) );
      $line =~ /^([a-zA-Z0-9_\.-]+)=(.*)$/;
      if ( defined($2) )
      {
        $tagHash->{$1} = $2;
      }
      else
      {
        $tagHash->{$1} = "";
      }
    }
    close(TF);
  }
}

1;
