package ErrorUtil;

# Copyright (c) 2003 Sun Microsystems, Inc. All rights reserved
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.

use strict;
use lib '/scs/lib/perl5';
use LogUtil;

my $errorMsg   = '';
my $warningMsg = '';
my $infoMsg    = '';

#
# Set the error message and log it if needed.
#
sub setError
{
  $errorMsg = shift || '';
  LogUtil::logError($errorMsg);
}

#
# Set the warning message and log it if needed.
#
sub setWarning
{
  $warningMsg = shift || '';
  LogUtil::logWarning($warningMsg);
}

#
# Set the info message and log it if needed.
#
sub setInfo
{
  $infoMsg = shift || '';
  LogUtil::logInfo($infoMsg);
}

#
# Get the error message.
#
sub getError
{
  return $errorMsg;
}

#
# Get the warning message.
#
sub getWarning
{
  return $warningMsg;
}

#
# Get the info message.
#
sub getInfo
{
  return $infoMsg;
}

#
# Log and print the error message then exit.
#
sub printError
{
  my $msg = shift;
  if ( defined($msg) )
  {
    setError($msg);
  }
  LogUtil::logError($errorMsg);
  print STDERR 'ERROR: ' . $errorMsg . "\n";
  LogUtil::closeLog();
  exit(1);
}

#
# Log and print the warning message, then exit.
#
sub printWarning
{
  my $msg = shift;
  if ( defined($msg) )
  {
    setWarning($msg);
  }
  LogUtil::logWarning($warningMsg);
  print STDERR 'WARNING: ' . $warningMsg . "\n";
  LogUtil::closeLog();
  exit(1);
}

#
# Log and print the info message, then exit.
#
sub printInfo
{
  my $msg = shift;
  if ( defined($msg) )
  {
    setInfo($msg);
  }
  LogUtil::logInfo($infoMsg);
  print STDERR 'INFO: ' . $infoMsg . "\n";
  LogUtil::closeLog();
  exit(1);
}

1;
