package CLIips;

# Copyright (c) 2003 Sun Microsystems, Inc. All rights reserved
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
# $Id: CLIips.pm,v 1.2 2004/03/31 22:07:03 sv122840 Exp $

use lib '/scs/lib/perl5';
use BDUtil;

my $infoMsgs = 0;
sub setInfoMsgs
{
  $infoMsgs = 1;
}

#
#
#
sub printUsage
{
  print STDERR<<EOD;

Instead of specifying IP addresses one by one, you may specify ranges of
IP addresses like so:
 * 10.6.1.1-10.6.1.3 : 3 addresses, could also be specified as:
 * 10.6.1.1-3 : same as above
 * 10.6.1.100-200 : 101 addresses, between 10.6.1.100 and 10.6.1.200
 * 10.6.1.1-2.255 : 510 addresses, between 10.6.1.1 and 10.6.2.255
 * 0.0.0.0-255.255.255.255 : Every single possible IP address

EOD
}

#
#
#
my $exitOnError = 0;
sub setExitOnError
{
  $exitOnError = 1;
}

#
#
#
sub getIPs
{
  my $args = shift;

  if (!$args || !defined($args->[0]))
  {
    processError('No IP address parameters');
    return [];
  }

  my @ipList = ();
  #my @hostList = ();

  my ($arg, $ipRange, $rc);

  BDUtil::info('Parsing IP arguments:') if ($infoMsgs);
  foreach $arg (@{$args})
  {
    ($rc, $ipRange) = isIPrange($arg);
    if ($rc)
    {
      if ($rc > 0) # else it was bad
      {
        BDUtil::info(' - IP range = ' . $arg . ' expanded to '
                   . scalar(@{$ipRange}) . ' addresses') if ($infoMsgs);
        push (@ipList, @{$ipRange});
      }
    }
    elsif ($rc = isIPaddress($arg))
    {
      if ($rc > 0)  # else it was bad
      {
        BDUtil::info(' - IP address = ' . $arg) if ($infoMsgs);
        push(@ipList, $arg);
      }
    }
    #elsif ($rc = isHostName($arg))
    #{
    #  if ($rc > 0)  # else it was bad
    #  {
    #    BDUtil::info(' - Host name = ' . $arg) if ($infoMsgs);
    #    push(@hostList, "'" . $arg . "'");
    #  }
    #}
    else
    {
      processError(' - Invalid arg = ' . $arg);
    }
  }

  if (!scalar(@ipList))
  {
    processError('No IP addresses yielded by given arguments');
    return [];
  }

  BDUtil::info('Returning ' . scalar(@ipList) . ' IP addresses: '
             . join(' : ', @ipList)) if ($infoMsgs);
  return \@ipList;
}

#
#
#
sub isHostName
{
  my $arg = shift;

  if ($arg =~ /^[a-zA-Z0-9\.\-]+$/) # Only chars allowed for hostnames
  {
    if (($arg =~ /^\./)                # No leading .
     || ($arg =~ /\.$/)                # or trailing
     || ($arg =~ /\.\./))              # No consecutive .'s
    {
      processError(' - Illegal host name = ' . $arg);
      return -1;
    }

    foreach my $t (split(/\./, $arg))
    {
      if (($t =~ /^[0-9]+$/)            # Can't be just digits
       || ($t =~ /^\-/)                 # No leading hyphen
       || ($t =~ /\-$/))                # Or trailing
      {
        processError(' - Illegal host name = ' . $arg
                   . ' ("' . $t . '" is an illegal term)');
        return -1;
      }
    }
    return 1;
  }
  return 0;
}

#
#
#
sub isIPaddress
{
  my $ip = shift;

  return 0 if ($ip !~ /^[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+$/);

  my @t = split(/\./, $ip);
  for (my $i=0; $i < 4; $i++)
  {
    if (($t[$i] !~ /^[0-9]+$/) || ($t[$i] < 0) || ($t[$i] > 255))
    {
      processError(' - Illegal IP address : ' . $ip);
      return -1;
    }
  }
  return 1; # good
}

#
#
#
sub isIPrange
{
  my $arg = shift;
  my $q = shift || '';

  return 0 if ($arg !~ /^([0-9]+\.[0-9]+\.[0-9]+\.[0-9]+)\-([0-9\.]+)$/);
  my ($start, $end) = ($1, $2);

  my @s = split(/\./, $start);
  my @te = split(/\./, $end);

  if (scalar(@s) != 4)
  {
    processError(' - Invalid start IP format in range : ' . $start);
    return -1;
  }

  if ((scalar(@te) > 4) || (scalar(@te) < 1))
  {
    processError(' - Invalid end IP format in range, must be between 1 and 4 terms : ' . $end);
    return -1;
  }

  my @e = ();
  my $i;
  for ($i=0; $i < (scalar(@s) - scalar(@te)); $i++)
  {
    push(@e, $s[$i]);
  }
  for (; $i < 4; $i++)
  {
    push(@e, shift @te);
  }

  for ($i=0; $i < 4; $i++)
  {
    if (($s[$i] !~ /^[0-9]+$/) || ($s[$i] < 0) || ($s[$i] > 255))
    {
      processError(' - Illegal IP address : ' . $start);
      return -1;
    }
    if (($e[$i] !~ /^[0-9]+$/) || ($e[$i] < 0) || ($e[$i] > 255))
    {
      processError(' - Illegal IP address : ' . join('.', @e));
      return -1;
    }
  }

  my ($a, $b, $c, $d, $sI, $eI);
  my @ipList = ();
  $a = $s[0];
  while ($a <= $e[0])
  {
    $b = $s[1];
    while ($b <= $e[1])
    {
      $c = $s[2];
      while ($c <= $e[2])
      {
        $sI = 0;
        if (($a == $s[0]) && ($b == $s[1]) && ($c == $s[2]))
        {
          $sI = $s[3];
        }
        $eI = 255;
        if (($a == $e[0]) && ($b == $e[1]) && ($c == $e[2]))
        {
          $eI = $e[3];
        }
        for ($d=$sI; $d <= $eI; $d++)
        {
          push(@ipList, $q . $a . '.' . $b . '.' . $c . '.' . $d . $q);
        }
        ++$c;
      }
      ++$b;
    }
    ++$a;
  }

  return (1, \@ipList);
}

#
#
#
sub isHostRange
{
  my $host = shift;
  my $q = shift || '';

  if ($host !~ /^([a-zA-Z]+)([0-9]+)(.*)\-([a-zA-Z]+)([0-9]+)(.*)$/)
  {
    return 0;
  }

  my ($c1, $n1, $d1, $c2, $n2, $d2) = ($1, $2, $3 || '', $4, $5, $6 || '');

  if (($c1 ne $c2) || ($d1 ne $d2) || (length("$n1") != length("$n2")))
  {
    return 0;
  }

  if ($n1 > $n2) { my $t = $n1 ; $n1 = $n2 ; $n2 = $t; }

  my $l = length("$n1");

  my @hostL = ();
  while ($n1 <= $n2)
  {
    push(@hostL, $q . $c1 . sprintf("%0*d", $l, $n1) . $d1 . $q);
    ++$n1;
  }

  return (1, \@hostL);
}

#
#
#
sub processError
{
  my $msg = shift;
  my $exitForErr = shift;
  $exitForErr = $exitOnError if (!defined($exitForErr));

  if ($exitForErr)
  {
    BDUtil::printError($msg);
  }
  BDUtil::warning($msg);
  return 0;
}

1;
