#!/usr/bin/perl -w
# $Id: Builds.pm,v 1.7 2004/08/27 02:06:03 sv122840 Exp $
# Builds.pm - Build information
# Copyright 2003, 2004 Sun Microsystems, Inc., All rights reserved.
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms

package Builds;

use lib '/scs/lib/perl5';
use strict;
use SCSDB;

my %matchStrings = 
(
  'linux'   => [ 'Red Hat', 'LX50' ],
  'solaris' => [ 'Netra', 'Ultra', 'Enterprise' ],
  'cobalt'  => [ 'Qube', 'RaQ' ]
);

#
# getBuilds
#
# ???
#

sub getBuilds
{
  my ($field, $matchStrList, $arch) = @_;

  my $sql = 'select ' . $field
           . ' from mgmt_build';
  my $sep = ' where ';
  if ($matchStrList)
  {
    $sql .= ' where (';
    $sep = '';
    foreach my $m (@{$matchStrList})
    {
      $sql .= $sep . " build_class like '%" . $m . "%'";
      $sep = ' or ';
    }
    $sql .= ')';
    $sep = ' and ';
  }
  if ($arch ne '')
  {
    $sql .= $sep . "build_class like '%" . $arch . "%'";
  }

  return SCSDB::getResultList($sql);
}

#
# getLinuxBuildIds
#

sub getLinuxBuildIds
{
  my $arch = shift;
  $arch = 'x86' if (!defined($arch));

  return getBuilds('build_id', $matchStrings{'linux'}, $arch);
}

#
# getLinuxBuildClasses
# 

sub getLinuxBuildClasses
{
  my $arch = shift;
  $arch = 'x86' if (!defined($arch));

  return getBuilds('build_class', $matchStrings{'linux'}, $arch);
}

#
# getSolarisBuildClasses
#

sub getSolarisBuildClasses
{
  my $arch = shift || '';

  return getBuilds('build_class', $matchStrings{'solaris'}, $arch);
}

#
# getSolarisBuildIds
#
# ???
#

sub getSolarisBuildIds
{
  my $arch = shift || '';

  return getBuilds('build_id', $matchStrings{'solaris'}, $arch);
}

#
#  getCobaltBuildIds
#
# ???
#

sub getCobaltBuildIds
{
    return ();
}

#
#  getCobaltBuildClasses
#
# ???
#

sub getCobaltBuildClasses
{
    return ();
}

#
# getBuildIdByType
#
# returns the build id for the specified build type
#

sub getBuildIdByType
{
    my $buildId = 0;

    my $buildType = shift @_;
    $buildType = "<UnknownType>" 
	unless (defined($buildType) && $buildType ne "");

    my $sql = "SELECT build_id, build_class FROM mgmt_build WHERE ";
    $sql .= "build_type = '$buildType'";

    my $res = SCSDB::getResultHash($sql);
    if (defined($res) && ref($res) eq "HASH") {
	$buildId = $res->{'build_id'};
	$buildId = 0 unless (defined($buildId) && $buildId+0 > 0);
    }

    return $buildId;
}

#
# getBuildIdsByClass
#
# returns the build id for the specified build class
#

sub getBuildIdsByClass
{
    my $buildClass = shift @_;
    $buildClass = "<UnknownClass>" 
	unless (defined($buildClass) && $buildClass ne "");

    my $sql = "SELECT build_id FROM mgmt_build WHERE ";
    $sql .= "build_class = '$buildClass'";

    return SCSDB::getResultList($sql);
}

#
# addBuild
#
# adds a new build type and class and returns the build id
#

sub addBuild
{
    my $buildId = 0;

    my $buildType = shift @_;
    return SCSDB::errorCode('EPARM', 'Build type is null')
	unless (defined($buildType) && $buildType ne "");

    my $buildClass = shift @_;
    return SCSDB::errorCode('EPARM', 'Build class is null')
	unless (defined($buildClass) && $buildClass ne "");

    my $sql = "SELECT build_id, build_class FROM mgmt_build WHERE ";
    $sql .= "build_type = '$buildType' AND build_class = ";
    $sql .= "'$buildClass'";

    my $res = SCSDB::getResultHash($sql);

    if (defined($res) && ref($res) eq "HASH") {
	$buildId = $res->{'build_id'}
    } 

    return $buildId if (defined($buildId) && $buildId+0 > 0);

    my %buildHash = ( 'build_type'  => "'$buildType'",
		      'build_class' => "'$buildClass'" );

    $buildId = SCSDB::insertHash('mgmt_build', 'build_id', \%buildHash);
    return SCSDB::errorCode('EDBERR', 'Cannot add build class')
	unless (defined($buildId) && $buildId+0 > 0);

    return $buildId;
}

#
# getBuildList
#
# returns a build list for the specified type and class
#

sub getBuildList
{
    my $buildType = shift @_;
    $buildType = "" unless (defined($buildType));

    my $buildClass = shift @_;
    $buildClass = "" unless (defined($buildClass));

    my $sql = "";
    my $build = "";
    my @buildIds = ();

    if ($buildClass eq '') {
	$build = Builds::getBuildIdByType($buildType);
	unless (defined($build) && $build+0 > 0) {
	    $build = 
	      Builds::addBuild(($buildType eq "" ? 
				'<UnknownType>' : 
				$buildType),
			       ($buildClass eq "" ?
				'<UnknownClass>' :
				$buildClass));
	}

	return SCSDB::errorCode('EDBERR', 'Cannot add new build')
	    unless (defined($build) && $build+0 >= 0);
	push (@buildIds, $build);
    } else {
	my $ids = Builds::getBuildIdsByClass($buildClass);
	if (defined($ids) && ref($ids) eq "ARRAY" &&
	    defined($ids->[0]) && $ids->[0]+0 > 0) {
	    @buildIds = @{ $ids };
	} else {
	    $build = Builds::addBuild("<UnknownType>",$buildClass);
	    return SCSDB::errorCode('EDBERR', 'Cannot add new build')
		unless (defined($build) && $build+0 >= 0);
	    push (@buildIds, $build);
	}
    }
    
    return (SCSDB::errorCode('OKAY'), \@buildIds);
}

1;
