package BDi18n;

# Copyright (c) 2003 Sun Microsystems, Inc. All rights reserved
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.


#
# $Id: BDi18n.pm,v 1.17 2004/10/05 17:32:44 ms152511 Exp $
#

# This hash contains all the current locale we support
my $locale_hash = {'en_US' => 'Y',
					'fr' => 'Y',
					'ja' => 'Y',
					'ko' => 'Y',
					'zh' => 'Y',
	'zh_TW' => 'Y'};

my $defaultLocale = 'en_US';
my $tmp_locale = $ENV{'SCSLOCALE'};
setLocale($tmp_locale);
my $domainName = '';
my $lastDomain = '';

#my $propertiesFilePath = '/var/tomcat4/webapps/sdui/WEB-INF/classes';
my $propertiesFilePath = '/scs/share/locale/';


my $tagHash = 0;

#
#
#
sub setLocale
{
	my $tmp_locale = shift @_ || 'en_US';
	if (defined($locale_hash->{$tmp_locale})) {
		$locale = $tmp_locale;
	} else {
		$locale = 'en_US';
	}
}

#
# setDomain
#
sub setDomain
{
  $lastDomain = $domainName;
  $domainName = shift || '';
  $domainName .= '.' if ($domainName ne '');
}

#
# restoreLastDomain
#
sub restoreLastDomain
{
  $domainName = $lastDomain;
}

#
#
#
sub getMsg
{
  my $tag = shift;
  my $args = shift || 0;

  if (ref($tag) eq 'HASH') {
      return interpolate( $tag->{'tag'}, $tag );
  } else {
      return interpolate($tag, $args);
  }
}

sub getSimpleMsg
{
  return interpolate(@_);
}

#
#
#
sub reloadTags
{
  $tagHash = 0;
}

#
#
#
sub interpolate
{
  my $t = shift;
  my $args = shift || 0;

  readTags() if (!$tagHash);
  my $tag;

  $t =~ s/^\[\[//;
  $t =~ s/\]\]$//;
  if ($t !~ /\./)
  {
    $tag  = $domainName . $t;
  }
  else
  {
    $tag = $t;
  }

  return $tag if (!exists($tagHash->{$tag}));
  return $tagHash->{$tag} if (!$args);

  my $r = $tagHash->{$tag};

  if (ref($args) eq 'HASH')
  {
    foreach my $k (keys %{$args})
    {
      if (defined($args->{$k})) 
      {
        $r =~ s/\[\[VAR\.$k\]\]/$args->{$k}/g;
	$r =~ s/\[$k\]/$args->{$k}/g;
      }
    }
  }
  elsif (ref($args) eq 'ARRAY')
  {
    my $n = 0;
    foreach my $x (@{$args})
    {
      $r =~ s/\{$n\}/$x/g;
      ++$n;
    }
  }

  return $r;
}

#
#
#
sub readTags
{
  return if (!opendir(XD, $propertiesFilePath . '/' . $locale));
  my @files = readdir(XD);
  close(XD);
  my ($line, @toks);
  $tagHash = {};
  foreach my $f (@files)
  {
    next if ($f =~ /^\./) || ($f !~ /\.strings$/);
    next if (!open(TF, $propertiesFilePath . '/' . $locale . '/' . $f));
    while ($line = <TF>)
    {
      chomp($line);
      next if (($line =~ /^[\r\t\n ]*$/) || ($line =~ /^#/));
      $line =~ /^([a-zA-Z0-9_\.-]+)=(.*)$/;
      if (defined($2))
      {
        $tagHash->{$1} = $2;
      }
      else
      {
        $tagHash->{$1} = "" if (defined $1 && $1 ne "");
      }
    }
    close (TF);
  }
}

1;
