#!/usr/bin/perl -w
# $Id: BDUtil.pm,v 1.5.4.1 2005/01/17 22:09:18 ms152511 Exp $
# BDUtil.pm - SCS utility functions
# Copyright 2004 Sun Microsystems, Inc., All rights reserved.
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms

package BDUtil;

use lib '/scs/lib/perl5';
use strict;
use SCSDB;
use PropertyUtil;

my $logPath = PropertyUtil::getProperty('dir.logs');
my $mkdir_cmd = PropertyUtil::getProperty('cmd.mkdir');

my $logFile = 0;
my $startTime = time();

my %MgmtDebugLevels =
(
  'OFF'   => 0x00000000,
  'MIN'   => 0x00000001,
  'ERR'   => 0x00000002,
  'WARN'  => 0x00000003,
  'INFO'  => 0x00000004,
  'VRB'   => 0x00000005,
  'FENT'  => 0x00000006,
  'FEXT'  => 0x00000007,
  'FCALL' => 0x00000008,
  'MAX'   => 0xffffffff
);

my $MgmtDebug = $MgmtDebugLevels{'OFF'};    

#
#
#
sub openLog
{
  my $moduleName = shift || 'mgmt';

  return if (exists $ENV{'SCS_NO_LOG'});

  system($mkdir_cmd . ' ' . $logPath) if ( ! -d $logPath);
  my ($sec, $min, $hour, $mday, $mon, $year) = localtime(time());
  my $fileName = $logPath . '/'
   . sprintf("%4d-%02d-%02d_%02d:%02d:%02d_%s.log",
     ($year+1900), ($mon+1), $mday, $hour, $min, $sec, $moduleName);

  if (!open (LOG_FILE, '>' . $fileName))
  {
    setError('Could not open log file : ' . $fileName);
    return -1;
  }
  $logFile = \*LOG_FILE;
  info('**** ' . $fileName . ' ****');
  return 0;
}

#
#
#
sub closeLog
{
  if ($logFile)
  {
    info('**** Closing log, time is ' . localtime() . ' ****');
    close ($logFile);
  }
}

#
#
#
sub info
{
  my $msg = join(' ', @_);

  print STDERR 'INFO   : ' . $msg . "\n";
  if ($logFile)
  {
    printf $logFile "%3d INFO   : %s\n", (time() - $startTime), $msg;
  }
}

#
#
#
my $warningStr = '';
sub warning
{
  $warningStr = join(' ', @_);

  print STDERR 'WARNING: ' . $warningStr . "\n";
  if ($logFile)
  {
    printf $logFile "%3d WARNING: %s\n", (time() - $startTime), $warningStr;
  }
}

#
#
#
my $errorStr = '';
sub setError
{
  $errorStr = shift || '';

    print STDERR 'ERROR  : ' . $errorStr . "\n";
  if ($logFile)
  {
    printf $logFile "%3d ERROR  : %s\n", (time() - $startTime), $errorStr;
  }
}

#
#
#
sub dbError
{
  my $rc = shift || 0;

  $errorStr = SCSDB::getErrorMessage();

  print STDERR 'DB ERR : ' . $errorStr . "\n";
  if ($logFile)
  {
    printf $logFile "%3d : ERROR  : %s\n", (time() - $startTime), $errorStr;
  }
  return $rc;
}

#
#
#
sub getError
{
  return $errorStr;
}

#
#
#
sub getWarning
{
  return $warningStr;
}

#
#
#
sub setDebug
{
  my $debug_lvl = shift;
  $debug_lvl = $MgmtDebugLevels{'MAX'}
    unless (defined $debug_lvl && int($debug_lvl) > 1);
  $MgmtDebug = $debug_lvl;    
  return $MgmtDebug;
}

#
#
#
sub setWarning
{
  $warningStr = join(' ', @_);
}

sub debugP
{
   return $MgmtDebug;
}

#
#
#
sub printDebug
{
  print STDERR "DEBUG  : @_\n" if ($MgmtDebug != 0);
}

#
#
#
sub printError
{
  setError(@_);
  closeLog();
  exit(1);
}

1;
