#!/usr/bin/perl -w
# $Id: BDDB.pm,v 1.12 2004/11/22 20:54:38 ms152511 Exp $
# BDDB.pm - SCS db access routines
# Copyright 2004 Sun Microsystems, Inc., All rights reserved.
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms

package BDDB;

use lib '/scs/lib/perl5';
use strict;
use SCSDB;

#
# Subroutines
#
# Open / close connection:
# ------------------------
#  openConnection  : No need to call this, done automatically.
#  closeConnection : Call on program exit, or it will be done automatically.
#  forkProcess     : Call this to make sure both parent & child can use DB
#                    instead of fork(), returns pid.
#
# Command functions: (for insert, update, delete)
# ------------------
#  runCommand      : returns 0 upon success, -1 otherwise.
#  getInsertId     : returns last ID given to auto_increment column for insert
#  getRowsAffected : returns number of rows affected by last command
#
# Query functions taking a SQL string argument, return value:
# -----------------------------------------------------------
# (call this...       if you want this...)
#
#  getResult       :  Scalar (single record, single value)
#  getResultList   :  Reference to list of scalars (records have only one item)
#  getResultHash   :  Hash reference (single record)
#  getResultHashes :  Reference to list of hash references
#  hasResults      :  Boolean on whether or not results exist for query
#
# Diagnostic functions:
# ---------------------
#  errorCode         : set error message, return error code
#  getDBerrorString  : Get message set by DB engine for a failed query
#  getErrorMessage   : Get message set by errorCode() function in an API
#  getLastSQL        : Get last SQL command processed by DB engine
#

sub enableDBDebugging
{
    return SCSDB::enableDBDebugging(@_);
}

sub disableDBDebugging
{
    return SCSDB::disableDBDebugging(@_);
}

sub printSQLDebug
{
    return SCSDB::printSQLDebug(@_);
}

#
# openConnection
#
# Opens a db connection
#

sub openConnection
{
    return SCSDB::openConnection(@_);
}

#
# closeConnection
#
# closes a db connection
#

sub closeConnection
{
    return SCSDB::closeConnection(@_);
}

#
# forkProcess
#
# ???
#

sub forkProcess
{
    return SCSDB::forkProcess(@_);
}

# 
# runCommand
#
# Run a SQL command that does not return any rows, like INSERT
#
#

sub runCommand
{
    return SCSDB::runCommand(@_);
}

#
# mkTable
#
# creates a table if it doesn't exist
#

sub mkTable
{
    return SCSDB::mkTable(@_);
}

#
# getInsertId
#
# Return last ID given to auto_increment column
#
# WARNING: This should really use currval or something
#

sub getInsertId
{
    return SCSDB::getInsertId(@_);
}

#
# getRowsAffected
#
# return number of rows affected by the last sql command
#

sub getRowsAffected
{
    return SCSDB::getRowsAffected(@_);
}

#
# executeQuery
#
# Helper funcion for various query functions
#

sub executeQuery
{
    return SCSDB::executeQuery(@_);
}

#
# hasResults
#
# Check to see if a query yields any results
#

sub hasResults
{
    return SCSDB::hasResults(@_);
}

#
# getResultHashes
#
# Return a reference to a list of hash references containing
# the results of the given SQL query.
#

sub getResultHashes
{
    return SCSDB::getResultHashes(@_);
}

#
# getResultHash
#
# Return a hash reference for a single record
#

sub getResultHash
{
    return SCSDB::getResultHash(@_);
}

#
# getResultList
#
# Return a reference to a list of scalars.
# The given SQL must only request one item per row.
#

sub getResultList
{
    return SCSDB::getResultList(@_);
}

#
# getResult
#
# Return a scalar value from a query
# Hence, the query must return a single row with a single field
# Returns 0 if no row returned.
#

sub getResult
{
    return SCSDB::getResult(@_);
}

#
# errorCode
#
# ???
#

sub errorCode
{
    return SCSDB::errorCode(@_);
}

#
# getErrorMessage
#
# ???
#

sub getErrorMessage
{
    return SCSDB::getErrorMessage(@_);
}

#
# getDBerrorString
#
# returns the db's error string
# 

sub getDBerrorString
{
    return SCSDB::getDBerrorString(@_);
}

#
# getLastSQL
#
# returns the last sql statement executed
#

sub getLastSQL
{
    return SCSDB::getLastSQL(@_);
}

1;
