package Alerts;

# Copyright (c) 2003 Sun Microsystems, Inc. All rights reserved
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.


#
# Alert.pm : alert database API
# $Id: Alerts.pm,v 1.8 2004/09/22 06:30:28 jl123456 Exp $
#
# Functions provided:
# -------------------
#   addAlert
#   removeAlert
#

use lib "/scs/lib/perl5";
use SCSDB;

#------------------------------------------------------------------------
#                           addAlert
#------------------------------------------------------------------------
#
# In : message, url, image
#
# Out : exit code
#
sub addAlert
{
  my ($message, $url, $image) = @_;

  return SCSDB::errorCode(EPARM, 'message, url and image are required')
    if (! defined($message) || ! defined($url) || ! defined($image));

  my $msg = SCSDB::getResult("select message from mgmt_alerts where url = '$url'");

  return SCSDB::errorCode(OKAY) if ($msg);

  return SCSDB::errorCode(EDBERR, 'Error inserting new record into alert')
    if (SCSDB::runCommand("insert into mgmt_alerts (message, url, img) values ('$message', '$url', '$image')"));

  return SCSDB::errorCode(OKAY);



}
#------------------------------------------------------------------------

#------------------------------------------------------------------------
#                          removeAlert
#------------------------------------------------------------------------
#
# In : url
#
# Out : Return code
#   
# Remove all the health alert 
#
sub removeAlert
{
  my $url = shift;
  return SCSDB::errorCode(EPARM, 'alert url is required')
    unless (defined $url);

  return SCSDB::errorCode(EDBERR, 'Error deleting from mgmt_alerts')
    if (SCSDB::runCommand("delete from mgmt_alerts where url='$url'"));

  return SCSDB::errorCode(OKAY)
}
#------------------------------------------------------------------------

1;
