# Copyright (c) 2004 Sun Microsystems, Inc. All rights reserved
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
# $Id: Service.pm,v 1.8 2004/12/13 16:00:38 jb122832 Exp $
# written by: Jeff Bilicki

package Service;

use strict;
use lib "/scs/lib/perl5";
require SCSUtil;

use vars qw($vend);
$vend = SCSUtil::getOS();

1;

# turns a service on for runlevels default on for 3 and 5
# usage set_service_on(service, runlevels)
# examples: set_service_on(telnet);
# set_service_on(telnet, '345');
sub set_on 
{
	my $service = shift;
	my $runlevel = shift || '35';
	my ($cmd, $ret);

	if($vend eq 'redhat') {
		$cmd = '/sbin/chkconfig --level '.$runlevel.' '.$service.' on';	
	} elsif($vend eq 'suse') {
		$cmd = '/sbin/chkconfig '.$service.' on';
	} else { return -1; }
		
	$ret = system($cmd);
	if($ret != 0) { return -1; } 
	else { return 1; }
}

# turns service off for runleves default off for all runlevels
# usage set_service_off(service, runlevels);
# examples: set_service_off(telnet);
# set_service_off(telnet, '3');
sub set_off
{
	my $service = shift;
	my $runlevel = shift || '0123456';
	my ($cmd, $ret);

	if($vend eq 'redhat') {
		$cmd = '/sbin/chkconfig --level '.$runlevel.' '.$service.' off';	
	} elsif($vend eq 'suse') {
		$cmd = '/sbin/chkconfig '.$service.' off';
	} else { return -1; }
		
	$ret = system($cmd);

	if($ret != 0) { return -1; } 
	else { return 1; }
}

# retstarts a service
# usage service_restart(service);
sub restart 
{
	my $service = shift;
	my $cmd = '/etc/init.d/'.$service.' restart';
	my $ret = system($cmd);
	if($ret != 0) { return -1; } 
	else { return 1; }
}

# reload a service use for nfs
# not all init scripts support this
sub reload 
{
	my $service = shift;
	my $cmd = '/etc/init.d/'.$service.' reload';
	my $ret = system($cmd);
	if($ret != 0) { return -1; } 
	else { return 1; }
}


# starts a service
# usage service_start(service)
sub start
{
	my $service = shift;
	my $cmd = '/etc/init.d/'.$service.' start';
	my $ret = system($cmd);
	if($ret != 0) { return -1; } 
	else { return 1; }
}

# stops a service
# usage service_stop(service)
sub stop
{
	my $service = shift;
	my $cmd = '/etc/init.d/'.$service.' stop';
	my $ret = system($cmd);
	if($ret != 0) { return -1; } 
	else { return 1; }
}

1;
