// Author: Kevin K.M. Chiu
// Copyright 2000, Cobalt Networks.  All rights reserved.
// $Id: select.js,v 1.6 2003/10/03 20:22:19 liwang Exp $

// description:
// This is a library for Select objects

//
// public functions
//

function selectMultiple(document){
    for (var i=0;i<document.forms.length;i++) {
        addFormSelect(document.forms[i]);
    }
}

function addFormSelect(aForm){
    for (var i=0;i<aForm.elements.length;i++) {
        if (aForm.elements[i].type == "select-multiple") {
            selectAll(aForm.elements[i]);
        }
    }
}

function selectAll(m){
    for (var i=0;i<m.options.length;i++) {
        m.options[i].selected=true;
    }
}

function moveSelected(m1,m2) {
	m1len = m1.length;
	for ( i = (m1len -1); i>=0; i--) {
		if (m1.options[i].selected == true ) {
			var name = m1.options[i].text;
            var value = m1.options[i].value;
            var defaultSelected = m1.options[i].defaultSelected;
            // var selected=m1.options[i].selected;
            var selected=false;
            m2.options[m2.length]= new Option(name, value, defaultSelected, selected);
            m1.options[i] = null;
		}
	}
}

function moveUp(m1) {
    m1len = m1.length;
    firstSelected = -1;
    lastSelected = -1;
    for ( i = 0; i<m1len; i++) {
        if (m1.options[i].selected == true ) {
            if (firstSelected == -1) {
                firstSelected = i;
            }
            lastSelected = i;
        }
    }
    if (firstSelected > 0) {
        var name = m1.options[firstSelected-1].text;
        var value = m1.options[firstSelected-1].value;
        var defaultSelected = m1.options[firstSelected-1].defaultSelected;
        var selected=m1.options[firstSelected-1].selected;
        m1.options[firstSelected-1] = m1.options[firstSelected];

        if (lastSelected < m1len-1) {
            for (c=m1len-2; c>=lastSelected; c--) {
                var lowName = m1.options[c].text;
                var lowValue = m1.options[c].value;
                var lowDefaultSelected = m1.options[c].defaultSelected;
                var lowSelected=m1.options[c].selected;
                m1.options[c+1] = new Option(lowName, lowValue, lowDefaultSelected, lowSelected);
            }
        }
        m1.options[lastSelected] = new Option(name, value, defaultSelected, selected);
    }
}

function moveDown(m1) {
    m1len = m1.length;
    firstSelected = -1;
    lastSelected = -1;
    for ( i = 0; i<m1len; i++) {
        if (m1.options[i].selected == true ) {
            if (firstSelected == -1) {
                firstSelected = i;
            }
            lastSelected = i;
        }
    }

    if (lastSelected < m1len-1) {
        var name = m1.options[lastSelected+1].text;
        var value = m1.options[lastSelected+1].value;
        var defaultSelected = m1.options[lastSelected+1].defaultSelected;
        var selected=m1.options[lastSelected+1].selected;

        for (c=lastSelected; c>=firstSelected; c--) {
            var lowName = m1.options[c].text;
            var lowValue = m1.options[c].value;
            var lowDefaultSelected = m1.options[c].defaultSelected;
            var lowSelected=m1.options[c].selected;
            m1.options[c+1] = new Option(lowName, lowValue, lowDefaultSelected, lowSelected);
        }
        m1.options[firstSelected] = new Option(name, value, defaultSelected, selected);
    }
}

function select_addOption(element, emptyLabel, parentDocument, text, value, defaultSelected, selected) {
  if(value == "" || value == null)
    return;

  var options = element.options;

  // clean up
  if(select_getLength(element, emptyLabel) == 0)
    options.length = 0;

  // use createElement if available because IE 5.X on Windows does not allow
  // options created outside the document of the select element to be added
  // to it
  // cannot just do parentDocument.createElement == null to see if this
  // function is available because IE4 barfs
  var name = navigator.appName;
  var version = navigator.appVersion;

  // if not IE 5.X or 6.X on windows
  if(  name.indexOf("Microsoft") == -1 ||
       version.indexOf("Win") == -1 &&
       (version.indexOf("MSIE 5") == -1 || version.indexOf("MSIE 6") == -1)
  ) {
    options[options.length] = new Option(text, value, defaultSelected, selected)
  } else {
    var option = parentDocument.createElement("OPTION");
    option.text = text;
    option.value = value;
    option.defaultSelected = defaultSelected;
    option.selected = selected;
    options[options.length] = option;
  }
}

function select_getLength(element, emptyLabel) {
  if(element.options.length == 0)
    return 0;

  if(element.options.length == 1
    && element.options[0].text == emptyLabel)
    return 0;

  return element.length;
}

function select_countSelected(element, emptyLabel) {
  if(select_getLength(element, emptyLabel) == 0)
    return 0;

  var options = element.options;
  var count = 0;
  for(var i = 0; i < options.length; i++)
    if(options[i].selected)
      count++;

  return count;
}

function select_removeOption(element, emptyLabel, parentDocument, index) {
  // do nothing if out of range
  if(index < 0 || index >= select_getLength(element, emptyLabel))
    return;

  element.options[index] = null;

  if(select_getLength(element, emptyLabel) == 0) {
    select_addOption(element, emptyLabel, parentDocument, emptyLabel, emptyLabel, false, false);
    element.selectedIndex = -1;
  }
}
