/*     dynamic select menus -- written by Matt Reinfeldt
        feel free to use, modify, copy, distribute, and otherwise abuse this code!
        if you find any problems, let me know, and I will try to find a fix for it.

*/

/******************************************************************************************************/

function stringSplit ( string, delimiter ) { 
    if ( string == null || string == "" ) { 
        return null; 
    } else if ( string.split != null ) { 
        return string.split ( delimiter ); 
    } else { 
        var ar = new Array(); 
        var i = 0; 
        var start = 0; 
        while( start >= 0 && start < string.length ) { 
             var end = string.indexOf ( delimiter, start ) ; 
             if( end >= 0 ) { 
                 ar[i++] = string.substring ( start, end ); 
                 start = end+1; 
             } else { 
                 ar[i++] = string.substring ( start, string.length ); 
                 start = -1; 
             } 
        } 
        return ar; 
    } 
} 
/******************************************************************************************************/
var menu1 = new Array();
var menu2 = new Array();
/******************************************************************************************************/
function createMenus (value1, value2, defaultvalue1, defaultvalue2) {

  var select1value = 0;
  var select2value = 0;
    for ( var i=0; i < info.length; i++ ) {
        menu1[i] = stringSplit ( info[i], '*' );
        menu2[i] = stringSplit ( menu1[i][1], '|' );
    }


    value1.length = menu1.length;
    for ( var i=0; i < menu1.length; i++ ) {
         value1.options[i].value  = menu1[i][0];
         value1.options[i].text   = menu1[i][0];
	if (menu1[i][0] == defaultvalue1) {
	   select1value = i;
	}
    }
    value1.options[select1value].selected = true;
    value2.length = menu2[select1value].length; 
    for (var x=0; x < menu2[select1value].length; x++) {
         value2.options[x].text = menu2[select1value][x];
         value2.options[x].value = menu2[select1value][x];
	if (menu2[select1value][x] == defaultvalue2) {
	    select2value = x;
	}
    }         
    value2.options[select2value].selected = true;
}

/******************************************************************************************************/

function updateMenus ( what, value ) {
    var sel = what.selectedIndex;

    if ( sel >= 0 && sel < menu1.length ) 
        var temp = menu2[sel];
    else
        var temp = new Array ();
    
	value.length = temp.length; 	

    for ( var i = 0; i < temp.length; i++ ) {
        value.options[i].text  = temp[i];
        value.options[i].value = temp[i];
    }
    value.options[0].selected=true;
}
