#!/usr/bin/perl -w

# Copyright (c) 2003 Sun Microsystems, Inc. All rights reserved
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.


#
# Schedule item runner
# Author: Phil Ploquin (phil.ploquin@sun.com)
# $Id: runSchedule.pl,v 1.13.4.1 2005/01/27 18:08:31 bm122834 Exp $
#

use strict;
use lib '/scs/lib/perl5';
use BDUtil;
use Event;
use PropertyUtil;
use Schedule;
use SCSDB;
use SysCmd;
use Task;

sub printUsage
{
  print STDERR "Usage: $0 <schedule id>\n";
  exit 0;
}

printUsage() if (!defined($ARGV[0]));
my $scheduleId = shift @ARGV;

# BDUtil::openLog('runSchedule');
# Make sure the 
$ENV{'SCSLOCALE'} = 'en_US';

#
# Fetch the schedule item
#
my $schedule = Schedule::getSchedule($scheduleId);

if (!$schedule)
{
  # BDUtil::setError('No schedule with id = ' . $scheduleId . " found.");
  # BDUtil::closeLog();
  print STDERR 'No schedule with id = ' . $scheduleId . " found.\n";
  exit 0;
}

#BDUtil::info('Schedule id = ' . $scheduleId);
#BDUtil::info('Type        = ' . $schedule->{'type'});
#BDUtil::info('Settings    = ' . $schedule->{'verbose_settings'});

#
# Delete the schedule item if it's a run only once deal
#
if ($schedule->{'type'} eq 'once')
{
  # BDUtil::info('Deleting schedule record since it is a once type');
  if (Schedule::deleteSchedule($schedule->{'schedule_id'}))
  {
    BDUtil::dbError();
    # BDUtil::closeLog();
    exit -1;
  }
}

#
# Create a task for this instance
#
my $numItems = 1;
$numItems = scalar(@{$schedule->{'appliance_list'}})
  if (($schedule->{'use_appliances'}) &&
      $schedule->{'appliance_list'} &&
      scalar(@{$schedule->{'appliance_list'}}));

my $taskId;
if ($schedule->{'hide_tasks'} eq 'Y')
{
  $taskId = Task::addHiddenTask($schedule->{'name'}, $numItems);
}
else
{
  $taskId = Task::addTask($schedule->{'name'}, $numItems);
}
if ($taskId <= 0)
{
  BDUtil::dbError();
  # BDUtil::closeLog();
  exit -1;
}

#
# Associate new task with schedule
#
if ($schedule->{'type'} ne 'once')
{
  Task::setTaskSchedule($taskId, $scheduleId);
}

# BDUtil::info('Created task, id = ' . $taskId . ', set numItems = ' . $numItems);

#
# Construct the command
#
my $cmd = $schedule->{'program_path'};
$cmd .= ' -t ' . $taskId;
$cmd .= ' ' . $schedule->{'program_args'}
  if ($schedule->{'program_args'} ne '');
$cmd .= ' ' . join(' ', @{$schedule->{'appliance_list'}})
  if ($schedule->{'appliance_list'});

#
# Send task start notification if required
#
if ($schedule->{'email_when_starting'} eq 'Y')
{
  sendNotification(1);
}

#
# Run the command
#
# BDUtil::info('Running command: ' . $cmd);

my $rc = system($cmd);

# BDUtil::info('Return code = ' . $rc);

#
# Get the task record to make sure the task cleaned up after itself
#
my $task = Task::getTask($taskId);
if (!$task)
{
  BDUtil::setError('Task record is gone!!');
  # BDUtil::closeLog();
  exit -1;
}

#
# Send task finish notification if required
#
if ($schedule->{'email_when_done'} eq 'Y')
{
  sendNotification(0);
}

if ($task->{'status'} eq 'R')
{
  # BDUtil::warning('Command did not set the task to complete or failed status, setting now');
  Task::setTaskStatus($rc?'F':'C', $taskId);
}

# BDUtil::info('All done.');
# BDUtil::closeLog();

exit 0;

########

#
#
#
sub sendNotification
{
  my $start = shift;

  # BDUtil::info('Sending email notification to '
  #             . $schedule->{'notification_email'});
  my $subject = $schedule->{'name'} . ' ' . ($start?'starting':'finished');
    my $body = $schedule->{'name'} . ' (' . $schedule->{'type'} . ') '. ', '
#	. $schedule->{'verbose_settings'} 
	. ($start?'has started':'has finished');
  # Encode in 64 bit for localized text
  my $mailFile =  '/tmp/schedulerMail.' . $$;
  my $syscmd = "/bin/echo \"$body\" >> $mailFile";
  $rc = system($syscmd);
  if (!$rc) {
      if (!$start)
      {
	  my $events = SCSDB::getResultHashes('select type, message from mgmt_event where task_id = ' . $taskId . ' order by modtime, task_id');
	  system ("/bin/echo \"\nEvents generated by this task:\n\" >> $mailFile");
	  system ("/bin/echo \"------------------------------\n\" >> $mailFile");
	  foreach my $e (@{$events})
	  {
	      system("/bin/echo \"" . $e->{'type'} . " : ". $e->{'message'} ." \n\" >> $mailFile ");
	  }
      }
      my $rc = SysCmd::sendEmail('Sun Control Station',
				 $schedule->{'notification_email'},
				 $subject, 0, $mailFile);
    unlink($mailFile);
      if ($rc)
      {
	Event::addEvent($taskId, 'warning', '127.0.0.1', 'Scheduler', 0,
			'Failed to send email notification to '
			. $schedule->{'notification_email'});
      }
      else
      {
	Event::addEvent($taskId, 'info', '127.0.0.1', 'Scheduler', 0, 
			'Successfully sent email notification to '
			. $schedule->{'notification_email'});
      }
  }
  else
  {
    Event::addEvent($taskId, 'warning', '127.0.0.1', 'Scheduler', 0,
                    'Failed to create email message to send to '
                       . $schedule->{'notification_email'} . ' via '
                       . $mailFile);
  }
}
