#!/usr/bin/perl -w
# $Id: mkBackup.pl,v 1.3 2004/12/18 00:12:36 ms152511 Exp $
# mkBackup.pl - backup database and configuration files for SCS
# Copyright 2004 Sun Microsystems, Inc. All rights reserved.
# Use is subject to license terms.


use strict;
use lib '/scs/lib/perl5';
use BDDB;
use BDi18n;
use BDUtil;
use Progress;
use SysCmd;
use PropertyUtil;

# secure the environment

$ENV{'PATH'} = "/sbin:/bin:/usr/bin:/usr/sbin";
delete @ENV{'IFS', 'CDPATH', 'ENV', 'BASH_ENV'};

BDi18n::setDomain('base-mgmt-backup');
Progress::initProgress(\@ARGV);
Progress::setProcessName('Backup');
Progress::setWorkItems(3);
BDUtil::openLog('mkBackup');

my $backupPath = shift @ARGV || PropertyUtil::getProperty('dir.backups');
if ( ! -d $backupPath )
{
  BDUtil::info($backupPath . ' does not exist, creating');
  if (!system(PropertyUtil::getProperty('cmd.mkdir'), '-p', $backupPath))
  {
    Progress::infoEvent(BDi18n::getMsg('createdDirectory',
                                       { 'path' => $backupPath }));
  }
}

my $msg;
if ( ! -d $backupPath || ! -w $backupPath)
{
  $msg = BDi18n::getMsg('cannotWriteTo', { 'path' => $backupPath });
  BDUtil::setError($msg);
  Progress::progressFailed($msg);
  BDUtil::closeLog();
  exit 1;
}

my $sbin_dir = PropertyUtil::getProperty('dir.sbin');

my $xmlPath  = '/var/tomcat4/webapps/sdui/WEB-INF/';
my $dbTool   = $sbin_dir . '/db_tool.pl';

my ($d, $rc) = SysCmd::runCmd('date', "'+%Y%m%d_%H%M'");
my $outFile = $backupPath . '/bk_' . $d;

Progress::setMessage(BDi18n::getMsg('backingUpDB'));
BDUtil::info('Starting database backup');
system($dbTool, 'backup');
$rc = $?;
Progress::updateProgress();
if ($rc)
{
  Progress::progressFailed(BDi18n::getMsg('dbBackupFailed'));
}
else
{
  Progress::infoEvent(BDi18n::getMsg('dbBackedUp'));
  Progress::setMessage(BDi18n::getMsg('backingUpFiles'));
  BDUtil::info('Backing up files');

  my $backupPaths = BDDB::getResultList('select backup_path from mgmt_backup_path');
  my @fileList = '/tmp/mgmt_db.sql';
  push( @fileList, @{$backupPaths} ) if ($backupPaths);

  my $modules = BDDB::getResultList("select mapp_name from mgmt_mapp where status='AS'");
  if ($modules)
  {
    my $f;
    foreach my $module (@{$modules})
    {
      push( @fileList, $xmlPath . 'struts-config-' . $module . '.xml' );
      push( @fileList, $xmlPath . 'menu-config-'   . $module . '.xml' );
    }
  }

  my @foundList = ();
  foreach my $f (@fileList)
  {
    if ( -r $f )
    {
      push(@foundList, $f);
    }
    else
    {
      Progress::warningEvent(BDi18n::getMsg('fileNotThere', { 'path' => $f }));
    }
  }

  (my $outS, $rc) = SysCmd::runCmd('tar', 'cPf ' . $outFile . '.tar '
                                           . join(' ', @foundList));
  if (!$rc)
  {
    Progress::updateProgress();
    Progress::setMessage(BDi18n::getMsg('backingUpFiles'));
    ($outS, $rc) = SysCmd::runCmd('gzip', $outFile . '.tar');
    if (!$rc)
    {
      Progress::updateProgress();
      ($outS, $rc) = SysCmd::runCmd('mv', $outFile . '.* ' . $outFile . '.scs');
    }
  }

  if ($rc)
  {
    $msg = BDi18n::getMsg('fileBackupFailed');
    Progress::progressFailed($msg);
    BDUtil::setError($msg);
  }
  else
  {
    $msg = BDi18n::getMsg('fileBackupSuccess');
    Progress::infoEvent($msg);
    BDUtil::info($msg);
    Progress::progressComplete(BDi18n::getMsg('backupSuccess',
                                           { 'file' => $outFile . '.scs'}));
  }
}
BDUtil::closeLog();
unlink('/tmp/mgmt_db.sql');
