#!/usr/bin/perl -w

# Copyright (c) 2003 Sun Microsystems, Inc. All rights reserved
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
# $Id: kickoffRestore.pl,v 1.8.2.2.4.1 2005/05/02 18:31:03 ms152511 Exp $

use strict;
use lib '/scs/lib/perl5';
use BDi18n;
use BDUtil;
use Progress;
use PropertyUtil;
use SysCmd;

my $base_dir  = PropertyUtil::getProperty('dir.base');
my $sbin_dir  = PropertyUtil::getProperty('dir.sbin');
my $etc_dir   = PropertyUtil::getProperty('dir.etc');

my $atAdd = SysCmd::getCmd('at');
my $restoreScript = '/tmp/restore.sh'; #_' . $$ . '.sh';
my $dbTool  = $sbin_dir . '/db_tool.pl';
my $initTool = $sbin_dir . '/init_tool.pl';
my $zcatCmd = SysCmd::getCmd('zcat');
my $tarCmd = SysCmd::getCmd('tar');
my @backupPaths =
(
  $etc_dir,
  $base_dir . '/mappScripts',
  $base_dir . '/clientRpms',
  $base_dir . '/msRpms'
);

my $pathsStr = join(' ', @backupPaths);

Progress::initProgress(\@ARGV);
Progress::setProcessName('prepareRestore');
Progress::setWorkItems(1);
BDUtil::openLog('kickoffRestore');
BDi18n::setDomain('base-mgmt-restore');

if (scalar @ARGV != 1) {
    print STDERR "Usage: kickoffRestore.pl <backupfile>\n";
    BDUtil::closeLog();
    Progress::progressFailed(BDi18n::getMsg('noBackupFile'));
    exit 1;
}

Progress::setMessage(BDi18n::getMsg('preparingToRestore'));

my $msg;
my $backupFile = shift @ARGV || 0;
if (!$backupFile || ! -r $backupFile)
{
  $msg = BDi18n::getMsg('cantOpenFile', { 'file' => $backupFile });
  BDUtil::setError($msg);
  BDUtil::closeLog();
  Progress::progressFailed($msg);
  exit 1;
}

BDUtil::info('Backup file is ' . $backupFile);

my ($sqlSize, $rc) = SysCmd::runFullCmd($zcatCmd . $backupFile . ' | ' . $tarCmd . 'tvf - | ' . SysCmd::getCmd('grep') . 'mgmt_db.sql | ' . SysCmd::getCmd('awk') . "{'" . 'print $3' . "'}");

if (!defined($sqlSize) || !$sqlSize)
{
  $msg = BDi18n::getMsg('badBackupFile', { 'file' => $backupFile });
  BDUtil::setError($msg);
  BDUtil::closeLog();
  Progress::progressFailed($msg);
  exit 1;
}
Progress::infoEvent(BDi18n::getMsg('validatedFile',
                                   { 'file' => $backupFile }));

my $version;
($version, $rc) = SysCmd::runFullCmd($zcatCmd . $backupFile . ' | ' . $tarCmd . 'xOf - /etc/build 2>/dev/null | ' . SysCmd::getCmd('awk') . "{'" . 'print $2' . "'}");

if (!$version)
{
  # out of date backup file (RR build)
  $msg = BDi18n::getMsg('badBackupFile', { 'file' => $backupFile });
  BDUtil::setError($msg);
  BDUtil::closeLog();
  Progress::progressFailed($msg);
  exit 1;
}

my $installPkgsSection = '';
if (SysCmd::getOS() eq 'Linux')
{
  $installPkgsSection = SysCmd::getCmd('rpm') . "-U $base_dir/msRpms/*.rpm";
}
else
{
  my $adminFile = SysCmd::checkAdminFile();
  my $pkgAdd = SysCmd::getCmd('pkgadd');
  $installPkgsSection =<<EOS;
for i in $base_dir/msRpms/*.pkg
do
  $pkgAdd -a $adminFile -d \$i all
done
EOS
}

if (open (RS, '>' . $restoreScript))
{
  BDUtil::info('Creating restore script : ' . $restoreScript);
  print RS <<EOF;
#!/bin/sh

START_T=`date '+%Y-%m-%d %H:%M:%S'`
if [ ! -r $backupFile ]; then
  echo $backupFile" not found!!"
  exit 1
fi
cd /
echo "INFO : Starting restore from $backupFile"
echo "INFO : Sleeping 3 seconds then stopping tomcat"
sleep 3
$initTool stop init.scs-tomcat4
rm -rf /var/cache/tomcat4/work/Standalone
echo "INFO : Removing old files and directories to be replaced by backed up files"
rm -f /etc/cron.d/mgmtScheduler
rm -rf $pathsStr
echo "INFO : Unpacking $backupFile"
echo "==============================="
$zcatCmd $backupFile | $tarCmd xvPf -
echo "==============================="
echo "INFO : Creating directories, just in case"
mkdir -p $pathsStr
rm -f $etc_dir/.bddbpass
for i in $base_dir/mappScripts/*; do if [ -x \$i/pre_install ]; then for j in \$i/pre_install/*; do echo "INFO : Running module pre_install script "\$j; \$j; done; fi; done
echo "INFO : Installing module server side packages"
$installPkgsSection
for i in $base_dir/mappScripts/*; do if [ -x \$i/post_install ]; then for j in \$i/post_install/*; do echo "INFO : Running module post_install script "\$j; \$j; done; fi; done
$dbTool restore
rm -f /tmp/mgmt_db.sql
TID=`$dbTool psql -Atc "select max(task_id) from mgmt_task"`
$dbTool psql -c "update mgmt_task set status='C', stop=start where task_id="\$TID
$dbTool psql -c "insert into mgmt_task (name,status,start,stop,ultimate_url) values ('Restore from backup : $backupFile', 'C', '\$START_T', now(), '')"
echo "INFO : Starting tomcat"
$initTool start init.scs-tomcat4
echo "INFO : Removing self : $restoreScript"
rm -f $restoreScript
echo "INFO : All done."
EOF
  close (RS);
  SysCmd::runCmd('chmod', '755 ' . $restoreScript);
  Progress::progressComplete( BDi18n::getMsg( 'restoreReady',
                                              { 'script' => $restoreScript } ) );
}
else
{
  $msg = BDi18n::getMsg('failedToWriteScript', { 'script' => $restoreScript });
  BDUtil::setError($msg);
  Progress::progressFailed($msg);
  BDUtil::closeLog();
  exit 1;
}

BDUtil::info('Successfully wrote restore script ' . $restoreScript);
BDUtil::closeLog();
