#!/usr/bin/perl -w

# Copyright (c) 2003 Sun Microsystems, Inc. All rights reserved
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.


#
# Script to delete old events & tasks
# $Id: cleanupEvents.pl,v 1.8 2004/09/02 17:51:46 ms152511 Exp $
#

use strict;
use lib '/scs/lib/perl5';
use SCSConfig;
use BDi18n;
use BDUtil;
use Progress;
use PropertyUtil;

BDi18n::setDomain('base-mgmt-event');
Progress::initProgress(\@ARGV);
BDUtil::openLog('cleanupEvents');
Progress::setProcessName(BDi18n::getMsg('cleanup'));
my $keepDays = SCSConfig::getConfig('mgmtEventKeepDays') || 2;
my $logPath = PropertyUtil::getProperty('dir.logs');
my $sbin_dir = PropertyUtil::getProperty('dir.sbin');
my $find_cmd = PropertyUtil::getProperty('cmd.find');
my $rm_cmd = PropertyUtil::getProperty('cmd.rm');

#
# Get rid of old events
#
my $numEvents = SCSDB::getResult('select count(*)'
                               . ' from mgmt_event'
                              . " where (now() - modtime) >= interval '" . $keepDays . " days'");
BDUtil::info($numEvents . ' events older than ' . $keepDays . ' days to delete');

if ($numEvents)
{
  SCSDB::runCommand('delete'
                  . ' from mgmt_event'
                 . " where (now() - modtime) >= interval '" . $keepDays . " days'");
  Progress::infoEvent(BDi18n::getMsg('deletedEvents',
                      { 'numEvents' => $numEvents,
                        'numDays' => $keepDays }));
}
else
{
  Progress::infoEvent(BDi18n::getMsg('noEvents', { 'numDays' => $keepDays }));
}

#
# And old tasks
#
my $numTasks = SCSDB::getResult('select count(*)' 
                               . ' from mgmt_task'
                              . " where (now() - start) >= interval '" . $keepDays . " days'");
BDUtil::info($numTasks . ' tasks older than ' . $keepDays . ' days to delete');

if ($numTasks)
{

  SCSDB::runCommand('delete '
                  . ' from mgmt_task'
                 . " where (now() - start) >= interval '" . $keepDays . " days'");
  Progress::infoEvent(BDi18n::getMsg('deletedTasks',
                                     { 'numTasks' => $numTasks,
                                       'numDays' => $keepDays }));
}
else
{
  Progress::infoEvent(BDi18n::getMsg('noTasks', { 'numDays' => $keepDays }));
}

BDUtil::info('Cleaning up log files in ' . $logPath . ' older than '
                . $keepDays . ' days old');
my $cmd = $find_cmd . ' ' . $logPath . ' -mtime +' . ($keepDays - 1)
                                 . ' -exec ' . $rm_cmd . ' {} \;';
system($cmd);
Progress::infoEvent(BDi18n::getMsg('clearedLogFiles',
                             { 'path' => $logPath, 'numDays' => $keepDays }));

Progress::updateProgress();
Progress::progressComplete(BDi18n::getMsg('finishedCleanup'));
BDUtil::info('All done!');
BDUtil::closeLog();
