#!/usr/bin/perl -w
# $Id: 040_event_tables.pl,v 1.10 2004/05/27 23:28:45 ms152511 Exp $
# 010_mgmt_tables.pl - perl script to add the mgmt tables
# Copyright 2004 Sun Microsystems, Inc., All rights reserved.
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.

use lib '/scs/lib/perl5';
use strict;
use SCSDB;

#
# Task
#

exit (1) if (SCSDB::mkTable('mgmt_task',
			   'task_id      serial',
			   'schedule_id  integer ',
			   'start        timestamp ',
			   'stop         timestamp ',
			   'status       char(1)      NOT NULL',
			   'message      text',
			   'msg_vars     varchar(255)',
			   'name         varchar(255) NOT NULL',
			   'items_done   integer default 0',
			   'total_items  integer default 0',
			   'hidden       char(1)     DEFAULT \'N\'',
			   'ultimate_url text         NOT NULL'));

#
# Event
#

exit (1) if (SCSDB::mkTable('mgmt_event',
			   'event_id   serial',			   
			   'task_id    integer      NOT NULL',
			   'type       varchar(16)  NOT NULL',
			   'ip_address char(16)     NOT NULL',
			   'process    varchar(128) NOT NULL',
			   'message    text	    NOT NULL',
			   'msg_vars   varchar(255) NOT NULL',
			   'modtime    timestamp    NOT NULL',
			   'invisible  char(1)      NOT NULL'));

#
# Schedule
#

exit (1) if (SCSDB::mkTable('mgmt_schedule',
			   'schedule_id      serial',
			   'modified         timestamp     NOT NULL'.
			   ' DEFAULT CURRENT_TIMESTAMP',
			   'type             varchar(16)   NOT NULL',
			   'name             varchar(128)  NOT NULL',
			   'program_path     varchar(255)  NOT NULL',
			   'program_args     varchar(4096) NOT NULL',			   
			   'use_appliances   char(1)       NOT NULL',
			   'new_appliances   char(1)       NOT NULL',
			   'dont_allow_new   char(1)       NOT NULL',
			   'read_only        char(1)       NOT NULL',
			   'email_when_done  char(1)       NOT NULL',
			   'email_when_starting char(1)    NOT NULL',
			   'notification_email varchar(255) NOT NULL',
			   'special_fields_lib varchar(128) NOT NULL',
			   'constant_type    char(1)       NOT NULL',
			   'mapp_name        varchar(128)  NOT NULL',
			   'verbose_settings varchar(255)  NOT NULL',
			   'hide_tasks       char(1)       NOT NULL',
			   'once_date        varchar(10)   NOT NULL',
			   'once_time        varchar(5)    NOT NULL',
			   'at_ident         integer       NOT NULL',
			   'hourly_start_hour integer      NOT NULL',
			   'hourly_last_hour integer       NOT NULL',
			   'hourly_minutes   varchar(255)  NOT NULL',
			   'hourly_frequency integer       NOT NULL',
			   'daily_hours      varchar(128)  NOT NULL',
			   'daily_minute     integer       NOT NULL',
			   'daily_frequency  integer       NOT NULL',
			   'weekly_days      varchar(32)   NOT NULL',
			   'weekly_time      varchar(5)    NOT NULL',
			   'monthly_days     varchar(128)  NOT NULL',
			   'monthly_time     varchar(5)    NOT NULL',
			   "CHECK(use_appliances  in ('Y', 'N'))",
			   "CHECK(new_appliances  in ('Y', 'N'))",
			   "CHECK(dont_allow_new  in ('Y', 'N'))",
			   "CHECK(read_only       in ('Y', 'N'))",
			   "CHECK(email_when_done in ('Y', 'N'))",
			   "CHECK(email_when_starting in ('Y','N'))",
			   "CHECK(constant_type   in ('Y', 'N'))",
			   "CHECK(hide_tasks      in ('Y', 'N'))"));

#
# Schedule Appliance
#

exit (1) if (SCSDB::mkTable('mgmt_schedule_appliance',
			   'schedule_appliance_id serial',
			   'schedule_id           integer NOT NULL',
			   'appliance_id          integer NOT NULL'));

#
# Schedulable Task
#

exit (1) if (SCSDB::mkTable('mgmt_schedulable_task',
			   'schedulable_task_id serial',
			   'mapp_id           integer      NOT NULL',
			   'name              varchar(128) NOT NULL',
			   'target_url        varchar(255) NOT NULL',
			   'target_tab        varchar(64)  NOT NULL',
			   'is_schedulable    char(1)      NOT NULL',
			   "CHECK(is_schedulable in ('Y', 'N'))",
			   'UNIQUE(name)'));

#
# Ignore appliance & application combos
#

exit (1) if (SCSDB::mkTable('mgmt_ignore_appliance',
			   'ignore_appliance_id serial',
			   'appliance_id        integer NOT NULL',
			   'mapp_id             integer NOT NULL'));

#
# Management task args 
#

exit (1) if (SCSDB::mkTable('mgmt_task_args',
			   'task_args_id serial',
			   'task_id      integer NOT NULL',
			   'args         text    NOT NULL'));

exit (0);
