#!/usr/bin/perl -w
# $Id: Schedule.pm,v 1.10 2004/10/13 23:48:05 ms152511 Exp $
# Schedule.pm - schedule tables interface
# Copyright 2004 Sun Microsystems, Inc., All rights reserved.
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms

package Schedule;

use lib '/scs/lib/perl5';
use strict;
use SCSDB;

#
# getSchedules
#
sub getSchedules
{
    my $type = shift @_ || 0;
    
    my $sql = 'SELECT * FROM mgmt_schedule ';

    CASE_GET_SCHEDULES_TYPE : {
	if ($type+0 == 1) {	
	    $sql .= "WHERE type = 'once' ";
	    last CASE_GET_SCHEDULES_TYPE;
	}

	if ($type+0 == 2) {
	    $sql .= "WHERE type != 'once' ";
	    last CASE_GET_SCHEDULES_TYPE;
	}
    }

    $sql .= ' ORDER BY schedule_id';

    my $schedules = SCSDB::getResultHashes($sql);
    return 0 unless (defined($schedules) && 
		     ref($schedules) eq "ARRAY");

    my @schedList = ();
    my $sched = "";

    foreach $sched (@{$schedules}) {
	push (@schedList, getExpandedSchedule($sched));
    }

    return \@schedList;
}

#
# addSchedule
#
sub addSchedule
{
    my $type = shift @_;
    return SCSDB::errorCode('EPARM', 'Schedule type is null')
	unless (defined($type) && $type ne "");

    my $params = shift @_;
    return SCSDB::errorCode('EPARM', 'Invalid schedule params')
	unless (defined($params) && ref($params) eq "HASH");

    my $newHosts = $params->{'new_appliances'};
    $newHosts = 'N' unless (defined($newHosts) && $newHosts ne "");

    my $hosts = $params->{'appliances'};
    $hosts = 0 unless (defined($hosts) && ref($hosts) eq "ARRAY");

    $params->{'use_appliances'} = 'Y' 
	if ($newHosts eq 'Y' || $hosts);

    if ($params->{'notification_email'} eq '') {
	$params->{'email_when_done'} = 'N';
	$params->{'email_when_starting'} = 'N';
    }

    my $hideTasks = $params->{'hide_tasks'};
    $params->{'hide_tasks'} = 'N' 
	unless (defined($hideTasks) && $hideTasks eq "Y");

    my $programArgs = $params->{'program_args'};
    $params->{'program_args'} = '' unless (defined($programArgs));
    $params->{'program_args'} =~ s/\'/\&quot\;/g;

    #
    # TODO: CHECK ALL FIELDS!!!! (Maybe update the db to default
    # a null value)
    #

    my @notNullFields = ( 'once_date', 
			  'once_time', 
			  'daily_hours',
			  'hourly_minutes',
			  'weekly_days',
			  'weekly_time',
			  'monthly_days',
			  'monthly_time' );

    my $notNullField = "";

    foreach $notNullField (@notNullFields) {
	$params->{$notNullField} = ""
	    unless (defined($params->{$notNullField}));
    }

    @notNullFields = ( 'hourly_start_hour',
		       'hourly_last_hour',
		       'hourly_frequency',
		       'daily_minute',
		       'daily_frequency' );

    foreach $notNullField (@notNullFields) {
	$params->{$notNullField} = -1
	    unless (defined($params->{$notNullField}));
    }
		       
    my $cols = "";
    my $values = "";
    my $colName = "";
    my $value = "";
    my $subvalue = "";

    foreach $colName (sort(keys(%{$params}))) {
	next if (!defined($colName) || 
		 $colName eq "" || 
		 $colName eq 'appliances');	

	$cols .= "$colName, ";
	
	if (ref($params->{$colName}) eq "ARRAY") {
	    if (ref($params->{$colName}->[0]) eq "ARRAY") {		
		foreach $subvalue (@{$params->{$colName}}) {
		    if (ref($subvalue) eq "ARRAY") {
			$value .= join(' ', @{$subvalue});
		    } else {
			$value .= $subvalue;
		    }
		    $value .= ",";
		}
 	    } else {
		$value = join(' ', @{$params->{$colName}});
	    }
	} else {
	    $value .= $params->{$colName};
	}

	$value =~ s/\'/\&quot\;/g;

	$values .= "'$value', ";	
	$value = "";	
    }

    $cols .= "type, at_ident";
    $values .= "'$type', 0";
    
    my $sql = "INSERT INTO mgmt_schedule ($cols) VALUES($values)";

    return SCSDB::errorCode('EDBERR', 'Cannot add new schedule')
	if (SCSDB::runCommand($sql));

    my $scheduleId;
    if (exists $params->{'schedule_id'}) {
        $scheduleId = $params->{'schedule_id'};
    } else {
        $scheduleId = SCSDB::getInsertId('mgmt_schedule', 
                                         'schedule_id');
    }
    
    return SCSDB::errorCode('EDBERR', 'Cannot add new schedule')
	unless (defined($scheduleId) && $scheduleId+0 > 0);

    my $host = 0;
    my $err = "";
    my %schedHash = ();
    my $schedInsertId = 0;

    if ($params->{'use_appliances'} eq 'Y' && $hosts) {
	foreach $host (@{$hosts}) {
	    next unless (defined($host) && $host+0 > 0);

	    %schedHash = ('schedule_id'  => int($scheduleId+0),
			  'appliance_id' => int($host+0) );

	    $schedInsertId = 
		SCSDB::insertHash('mgmt_schedule_appliance',
				 'schedule_appliance_id',
				 \%schedHash);
	    
	    unless (defined($schedInsertId) && 
		    $schedInsertId+0 > 0) {
		$err = "Cannot add schedule to host '$host'";
		last;
	    }
	}
    }

    return SCSDB::errorCode('EDBERR', $err)
	if ($err ne "");

    return $scheduleId;
}

#
# getSchedule
#
sub getSchedule
{
    my $scheduleId = shift @_;
    return 0 unless (defined($scheduleId) && $scheduleId+0 > 0);

    my $sql = 'SELECT * FROM mgmt_schedule WHERE schedule_id = ';
    $sql .= "'$scheduleId'";
    
    my $schedule = SCSDB::getResultHash($sql);
    return 0 unless (defined($schedule) && ref($schedule) eq "HASH");

    $sql = 'SELECT appliance_id FROM mgmt_schedule_appliance WHERE ';
    $sql .= 'schedule_id = '. int($scheduleId+0);

    $schedule->{'appliance_list'} = SCSDB::getResultList($sql);

    return getExpandedSchedule($schedule);
}

#
# deleteSchedule
#
sub deleteSchedule
{
    my $scheduleId = shift @_;
    return 0 unless (defined($scheduleId) && $scheduleId+0 > 0);

    my $sql = 'DELETE FROM mgmt_schedule_appliance WHERE ';
    $sql .= 'schedule_id = '. int($scheduleId+0);
    
    &SCSDB::runCommand($sql);

    $sql = 'DELETE FROM mgmt_schedule WHERE ';
    $sql .= 'schedule_id = '. int($scheduleId+0);

    return SCSDB::runCommand($sql);
}

#
# setAtId
#
sub setAtIdent
{
    my $scheduleId = shift @_;
    return 0 unless (defined($scheduleId) && $scheduleId+0 > 0);

    my $atId = shift @_;
    $atId = "" unless (defined($atId));

    my $sql = "UPDATE mgmt_schedule SET at_ident = '$atId' WHERE ";
    $sql .= 'schedule_id = '. int($scheduleId+0);
    
    return SCSDB::runCommand($sql);
}

#
#
#
sub splitList
{
  my $l = shift;
  my $splitter = shift || ' ';

  return 0 if ($l eq '');
  return [ split (/$splitter/, $l) ];
}

sub splitListOfLists
{
  my $l = shift;

  return 0 if ($l eq '');
  my @li = ();
  foreach my $i (split (' ', $l))
  {
    push (@li, splitList($l, ','));
  }
}

sub getExpandedSchedule
{
    my $sched = shift @_;
    return undef unless (defined($sched));
    return $sched unless (ref($sched) eq "HASH");
    
    my $field = "";
    my @fields = ( 'once_date', 
		   'once_time', 
		   'hourly_minutes',
		   'daily_hours',
		   'weekly_days',
		   'weekly_time',
		   'monthly_days',
		   'monthly_time' );
    
    foreach $field (@fields) {
	next unless (defined($sched->{$field}));
	$sched->{$field} = splitList($sched->{$field});
    }

    return $sched;
}

1;
