#!/usr/bin/perl -w
# $Id: Event.pm,v 1.5 2004/03/31 22:08:56 sv122840 Exp $
# Progress.pm - lib for manipulating the event table
# Copyright 2004 Sun Microsystems, Inc., All rights reserved.
# SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms

#
# Subroutines
# -----------
# addEvent
# getEvent
# getEvents
#

package Event;

use lib "/scs/lib/perl5";
use strict;
use SCSDB;

#
# addEvent
#
# In : Task ID, Type, IP Address, Process name, Invisible, Message
#
# Out : New event ID (positive integer) or error code (negative)
#

sub addEvent
{
    my $taskId = shift @_;
    return SCSDB::errorCode('EPARM', "Invalid task id")
	unless (defined($taskId) && $taskId+0 > 0);
    
    my $type = shift @_;
    return SCSDB::errorCode('EPARM', "A type must be specified")
	unless (defined($type));
    
    my $ip = shift @_;
    $ip = "" unless (defined($ip));

    my $proc = shift @_;
    return SCSDB::errorCode('EPARM', "A process must be specified")
	unless (defined($proc));

    my $invisible = shift @_;    
    return SCSDB::errorCode('EPARM', "Invisible/Visible not specified")
	unless (defined($invisible) && $invisible =~ /^[01]$/);
    
    my $msg = join(' ',@_);
    $msg = '' unless (defined($msg));

    my %eventHash = ( 'task_id'    => int($taskId+0),
		      'type'       => "'$type'",
		      'ip_address' => "'$ip'",
		      'process'    => "'$proc'",
		      'message'    => "'$msg'",
		      'msg_vars'   => '',
		      'modtime'    => 'now()',
		      'invisible'  => "'$invisible'" );

    my $eventId = 
	SCSDB::insertHash('mgmt_event', 'event_id', \%eventHash);

    return SCSDB::errorCode('EDBERR', 'Cannot add event')
	unless (defined($eventId) && $eventId+0 > 0);

    return $eventId;
}

#
# getEvent
#
# In : Event ID
#
# Out : Reference to hash of an event record
#

sub getEvent
{
    my $eventId = shift @_;
    return (SCSDB::errorCode('EPARM', 'Invalid event id'), 0)
	unless (defined($eventId) && $eventId+0 > 0);

    my $sql = 'SELECT * FROM mgmt_event WHERE event_id = ';
    $sql .= int($eventId+0);

    my $eventHash = SCSDB::getResultHash($sql);
    
    return (SCSDB::errorCode('EINVAL', 'No such event'), 0)
	unless (defined($eventHash) && ref($eventHash) eq "HASH");

    return (SCSDB::errorCode('OKAY'), $eventHash);
}

#
# getEvents
#
# In : Task ID (optional) type (optional)
#
# Out : Reference to list of hash references
#

sub getEvents
{
    my $sql = 'SELECT * FROM mgmt_event ';
    my $haveTask = 0;

    my $taskId = shift @_;
    
    if (defined($taskId) && $taskId+0 > 0) {
	$sql .= 'WHERE task_id = ' . int($taskId+0);
	$haveTask = 1;
    } else {
	return (SCSDB::errorCode('EPARM', 'Invalid task id'), 0);
    }

    my $type = shift @_;    

    if (defined($type)) {
	$sql .= ($haveTask ? 'AND ' : 'WHERE ');
	$sql .= "type = '$type'";
    }

    return (SCSDB::errorCode('OKAY'), SCSDB::getResultHashes($sql));
}

#
# delEvent
#
# deletes a given event
#

sub delEvent 
{
    my $eventId = shift @_;
    return (SCSDB::errorCode('EPARM', 'Invalid event id'), 0)
	unless (defined($eventId) && $eventId+0 > 0);

    my $sql = 'DELETE FROM mgmt_event WHERE event_id = ';
    $sql .= int($eventId+0);

    return SCSDB::runCommand($sql);
}

1;
